/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.jms.common;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJmsQueueConsumer
implements Runnable {
    protected static final int NETWORK_PAYLOAD_SIZE_WARNING_THRESHOLD = 0x100000;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final Connection jmsConnection;
    protected final String queueName;
    private Session session;

    public AbstractJmsQueueConsumer(Connection connection, String queueName) throws JMSException {
        this.jmsConnection = connection;
        this.queueName = queueName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            AbstractJmsQueueConsumer abstractJmsQueueConsumer = this;
            synchronized (abstractJmsQueueConsumer) {
                if (this.session != null) {
                    throw new IllegalStateException("Session not null");
                }
                this.session = this.jmsConnection.createSession(false, 1);
            }
            Queue queue = this.session.createQueue(this.queueName);
            MessageConsumer consumer = this.session.createConsumer((Destination)queue);
            this.log.debug((Object)("Running listener for queue " + queue.getQueueName() + " in thread " + Thread.currentThread().getName()));
            try {
                while (true) {
                    Message message;
                    block29: {
                        try {
                            message = consumer.receive();
                            if (message == null) {
                                this.log.debug((Object)("Clean shutdown of queue listener for " + queue.getQueueName() + ": received NULL"));
                            }
                            break block29;
                        }
                        catch (JMSException e) {
                            this.log.warn((Object)("Exception while listening on queue " + queue.getQueueName() + " (unclean shutdown?): " + e.toString()));
                        }
                        break;
                    }
                    try {
                        if (this.checkForShutdown(message)) {
                            this.log.debug((Object)("Clean shutdown of queue listener for " + queue.getQueueName() + ": received shutdown message"));
                            break;
                        }
                        this.dispatchMessage(message, this.jmsConnection);
                    }
                    catch (JMSException e) {
                        this.log.warn((Object)"Error while processing received message; continuing to listen", (Throwable)e);
                    }
                }
            }
            catch (Throwable throwable) {
                AbstractJmsQueueConsumer abstractJmsQueueConsumer2 = this;
                synchronized (abstractJmsQueueConsumer2) {
                    if (this.session != null) {
                        try {
                            this.session.close();
                        }
                        catch (JMSException e1) {
                            this.log.debug((Object)("JMS exception while closing inbox consumer session on " + this.queueName + ": " + e1.toString()));
                        }
                        this.session = null;
                    } else {
                        this.log.debug((Object)"JMS queue consumer reached shutdown after its shutdown was triggered asynchronously");
                    }
                }
                throw throwable;
            }
            AbstractJmsQueueConsumer abstractJmsQueueConsumer3 = this;
            synchronized (abstractJmsQueueConsumer3) {
                if (this.session != null) {
                    try {
                        this.session.close();
                    }
                    catch (JMSException e1) {
                        this.log.debug((Object)("JMS exception while closing inbox consumer session on " + this.queueName + ": " + e1.toString()));
                    }
                    this.session = null;
                } else {
                    this.log.debug((Object)"JMS queue consumer reached shutdown after its shutdown was triggered asynchronously");
                }
            }
        }
        catch (JMSException e) {
            this.log.warn((Object)"Unhandled exception in inbox consumer thread, terminating", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerShutDown() throws JMSException {
        AbstractJmsQueueConsumer abstractJmsQueueConsumer = this;
        synchronized (abstractJmsQueueConsumer) {
            if (this.session == null) {
                this.log.debug((Object)"JMS queue consumer received shutdown command, but has no session; it is either not initialized yet or was already shut down");
                return;
            }
            this.session.close();
            this.session = null;
        }
    }

    private boolean checkForShutdown(Message message) throws JMSException {
        String messageType = message.getStringProperty("messageType");
        if ("shutdown.queue.s2c".equals(messageType)) {
            String textContent = ((TextMessage)message).getText();
            this.log.debug((Object)("Received shutdown command, token=" + textContent));
            return true;
        }
        return false;
    }

    protected abstract void dispatchMessage(Message var1, Connection var2);
}

