/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.internal;

import de.rcenvironment.core.command.api.CommandExecutionResult;
import de.rcenvironment.core.command.api.CommandExecutionService;
import de.rcenvironment.core.command.internal.CommandPluginDispatcher;
import de.rcenvironment.core.command.internal.MultiCommandHandler;
import de.rcenvironment.core.command.internal.handlers.BuiltInCommandPlugin;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class CommandExecutionServiceImpl
implements CommandExecutionService {
    private static final String INDENT = "\t";
    private final CommandPluginDispatcher commandPluginDispatcher;
    private final AsyncTaskService threadPool;
    private final Set<CommandDescription> commandDescriptions = new TreeSet<CommandDescription>();
    private ConfigurationService configurationService;

    public CommandExecutionServiceImpl() {
        this.commandPluginDispatcher = new CommandPluginDispatcher();
        this.threadPool = ConcurrencyUtils.getAsyncTaskService();
    }

    public void activate() {
        this.registerCommandPlugin(new BuiltInCommandPlugin());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCommandPlugin(CommandPlugin plugin) {
        this.commandPluginDispatcher.registerPlugin(plugin);
        Set<CommandDescription> set = this.commandDescriptions;
        synchronized (set) {
            this.commandDescriptions.addAll(plugin.getCommandDescriptions());
        }
    }

    public void unregisterCommandPlugin(CommandPlugin plugin) {
        this.commandPluginDispatcher.unregisterPlugin(plugin);
    }

    public void bindConfigurationService(ConfigurationService service) {
        this.configurationService = service;
    }

    @Override
    public Future<CommandExecutionResult> asyncExecMultiCommand(List<String> tokens, TextOutputReceiver outputReceiver, Object initiator) {
        File profileOutput = this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_OUTPUT);
        MultiCommandHandler multiCommandHandler = new MultiCommandHandler(tokens, outputReceiver, this.commandPluginDispatcher, profileOutput);
        multiCommandHandler.setInitiatorInformation(initiator);
        return this.threadPool.submit((Callable)multiCommandHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printHelpText(boolean addCommonPrefix, boolean showDevCommands, TextOutputReceiver outputReceiver) {
        Set<CommandDescription> set = this.commandDescriptions;
        synchronized (set) {
            if (showDevCommands) {
                outputReceiver.addOutput("RCE User Commands:");
            } else {
                outputReceiver.addOutput("RCE Console Commands:");
            }
            for (CommandDescription contribution : this.commandDescriptions) {
                if (contribution.isDeveloperCommand()) continue;
                this.printHelpContribution(outputReceiver, contribution, addCommonPrefix);
            }
            if (showDevCommands) {
                outputReceiver.addOutput("RCE Developer Commands:");
                for (CommandDescription contribution : this.commandDescriptions) {
                    if (!contribution.isDeveloperCommand()) continue;
                    this.printHelpContribution(outputReceiver, contribution, addCommonPrefix);
                }
            }
        }
    }

    @Override
    public String getHelpText(boolean addCommonPrefix, boolean showDevCommands) {
        CapturingTextOutReceiver capturingReceiver = new CapturingTextOutReceiver();
        this.printHelpText(addCommonPrefix, showDevCommands, (TextOutputReceiver)capturingReceiver);
        return capturingReceiver.getBufferedOutput();
    }

    private void printHelpContribution(TextOutputReceiver outputReceiver, CommandDescription contribution, boolean addCommonPrefix) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(INDENT);
        if (addCommonPrefix) {
            buffer.append("rce ");
        }
        buffer.append(contribution.getStaticPart());
        if (contribution.hasDynamicPart()) {
            buffer.append(" ");
            buffer.append(contribution.getDynamicPart());
        }
        buffer.append(" - ");
        buffer.append(contribution.getFirstLine());
        outputReceiver.addOutput(buffer.toString());
        String[] stringArray = contribution.getAdditionalLines();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String additionalLine = stringArray[n2];
            outputReceiver.addOutput("\t\t" + additionalLine);
            ++n2;
        }
    }
}

