/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.execution.validator;

import de.rcenvironment.components.switchcmp.common.ScriptValidation;
import de.rcenvironment.components.switchcmp.execution.Messages;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractComponentValidator;
import de.rcenvironment.core.datamodel.api.DataType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SwitchComponentValidator
extends AbstractComponentValidator {
    public String getIdentifier() {
        return "de.rcenvironment.switchcmp";
    }

    protected List<ComponentValidationMessage> validateComponentSpecific(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        String condition = this.getProperty(componentDescription, "conditionKey");
        if (condition == null || condition.trim().isEmpty()) {
            ComponentValidationMessage emptyCondition = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "conditionKey", Messages.noConditionString, Messages.noConditionString);
            messages.add(emptyCondition);
        } else {
            String errorMessage = ScriptValidation.validateScript((String)condition, this.getInputAndConnectionStatus(componentDescription), this.getInputsAndDataTypes(componentDescription), (Object)((Object)this));
            if (!errorMessage.isEmpty()) {
                ComponentValidationMessage scriptError = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "conditionKey", errorMessage, errorMessage);
                messages.add(scriptError);
            }
        }
        return messages;
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }

    private Map<String, DataType> getInputsAndDataTypes(ComponentDescription componentDescription) {
        HashMap<String, DataType> inputs = new HashMap<String, DataType>();
        for (EndpointDescription description : this.getInputs(componentDescription)) {
            inputs.put(description.getName(), description.getDataType());
        }
        return inputs;
    }

    private Map<String, Boolean> getInputAndConnectionStatus(ComponentDescription componentDescription) {
        HashMap<String, Boolean> inputs = new HashMap<String, Boolean>();
        for (EndpointDescription description : this.getInputs(componentDescription)) {
            inputs.put(description.getName(), description.isConnected());
        }
        return inputs;
    }
}

