/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.gui.view;

import de.rcenvironment.components.excel.common.ChannelValue;
import de.rcenvironment.components.excel.common.ExcelUtils;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.notification.Notification;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.notification.SimpleNotificationService;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.apache.commons.logging.LogFactory;

public class ModelProvider
extends Observable
implements NotificationSubscriber {
    private static final long serialVersionUID = 611752605431248651L;
    private List<ChannelValue> channelValues = null;
    private boolean areNotificationsMissed = true;
    private Long lastMissedNotification = null;
    private Deque<Notification> queuedNotifications = new LinkedList<Notification>();
    private boolean isSubscribed = false;

    public ModelProvider() {
        this.channelValues = new ArrayList<ChannelValue>();
    }

    public void subscribeToLocalToolRunPlatForm(String componentIdentifier, ResolvableNodeId publishPlatform) throws RemoteOperationException {
        if (!this.isSubscribed) {
            Map lastMissedNotifications;
            SimpleNotificationService sns = new SimpleNotificationService();
            try {
                lastMissedNotifications = sns.subscribe(String.valueOf(componentIdentifier) + ":rce.component.excel", (NotificationSubscriber)this, publishPlatform);
            }
            catch (RemoteOperationException e) {
                LogFactory.getLog(this.getClass()).error((Object)("Failed to subscribe to Excel run platform: " + e.getMessage()));
                return;
            }
            for (String notifId : lastMissedNotifications.keySet()) {
                Long lastMissedNumber = (Long)lastMissedNotifications.get(notifId);
                if (lastMissedNumber == -1L) {
                    this.setNotificationsMissed(false);
                    this.setLastMissedNotification(lastMissedNumber);
                } else {
                    this.setNotificationsMissed(true);
                    this.setLastMissedNotification(lastMissedNumber);
                }
                for (List notifications : sns.getNotifications(notifId, publishPlatform).values()) {
                    Iterator notificationIterator = notifications.iterator();
                    while (notificationIterator.hasNext()) {
                        this.notify((Notification)notificationIterator.next());
                    }
                }
            }
            this.isSubscribed = true;
        }
    }

    public List<ChannelValue> getChannelValues() {
        return this.channelValues;
    }

    public void addNewChannelValues(List<ChannelValue> channelVals) {
        this.channelValues.addAll(channelVals);
        this.setChanged();
        this.notifyObservers();
        ExcelUtils.destroyGarbage();
    }

    public void addNewChannelValue(ChannelValue cval) {
        this.channelValues.add(cval);
        this.setChanged();
        this.notifyObservers();
        ExcelUtils.destroyGarbage();
    }

    @AllowRemoteAccess
    public void receiveBatchedNotifications(List<Notification> notifications) {
        try {
            for (Notification notification : notifications) {
                this.notify(notification);
            }
        }
        catch (RuntimeException e) {
            LogFactory.getLog(this.getClass()).error((Object)"Error in notification handler", (Throwable)e);
        }
    }

    private void notify(Notification notification) {
        if (this.areNotificationsMissed && this.lastMissedNotification == -1L) {
            this.queuedNotifications.add(notification);
        } else if (this.areNotificationsMissed && notification.getHeader().getNumber() > this.lastMissedNotification) {
            this.queuedNotifications.add(notification);
        } else {
            Serializable body = notification.getBody();
            if (body instanceof ChannelValue) {
                ChannelValue val = (ChannelValue)notification.getBody();
                this.channelValues.add(val);
                this.setChanged();
                this.notifyObservers();
                ExcelUtils.destroyGarbage();
            }
            if (this.areNotificationsMissed && notification.getHeader().getNumber() == this.lastMissedNotification.longValue()) {
                while (!this.queuedNotifications.isEmpty()) {
                    this.notify(this.queuedNotifications.getFirst());
                }
                this.areNotificationsMissed = false;
            }
        }
    }

    public Class<? extends Serializable> getInterface() {
        return NotificationSubscriber.class;
    }

    public void setLastMissedNotification(Long number) {
        this.lastMissedNotification = number;
    }

    public void setNotificationsMissed(boolean missed) {
        this.areNotificationsMissed = missed;
    }
}

