/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.common;

import de.rcenvironment.components.excel.common.ExcelAddress;
import de.rcenvironment.components.excel.common.ServiceHolder;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import java.io.File;
import java.io.Serializable;

public class ChannelValue
implements Serializable {
    private static final long serialVersionUID = 4317907370959158263L;
    private boolean isInputValue = false;
    private String valuesSerialized = null;
    private String channelName = null;
    private boolean expand = false;
    private File excelFile;
    private String preMacro = null;
    private String runMacro = null;
    private String postMacro = null;
    private long iteration;
    private ExcelAddress excelAddress;

    public ChannelValue(File excelFile, ExcelAddress address, String channelName, boolean isInputValue, boolean expanding, long iterationStep) {
        this.excelFile = excelFile;
        this.excelAddress = address;
        this.channelName = channelName;
        this.isInputValue = isInputValue;
        this.iteration = iterationStep;
    }

    public boolean isInputValue() {
        return this.isInputValue;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public long getIteration() {
        return this.iteration;
    }

    public SmallTableTD getValues() {
        TypedDatumSerializer serializer = new ServiceHolder().getSerializer();
        return (SmallTableTD)serializer.deserialize(this.valuesSerialized);
    }

    public void setValues(SmallTableTD vals) {
        TypedDatumSerializer serializer = new ServiceHolder().getSerializer();
        this.valuesSerialized = serializer.serialize((TypedDatum)vals);
    }

    public ExcelAddress getExcelAddress() {
        return this.excelAddress;
    }

    public boolean isExpanding() {
        return this.expand;
    }

    public File getFile() {
        return this.excelFile;
    }

    public String getPreMacro() {
        return this.preMacro;
    }

    public void setPreMacro(String preMacro) {
        this.preMacro = preMacro;
    }

    public String getRunMacro() {
        return this.runMacro;
    }

    public void setRunMacro(String runMacro) {
        this.runMacro = runMacro;
    }

    public String getPostMacro() {
        return this.postMacro;
    }

    public void setPostMacro(String postMacro) {
        this.postMacro = postMacro;
    }
}

