/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.util.Iterator;
import org.jpedal.parser.PdfStreamDecoder;

public class DecoderResults {
    private boolean imagesProcessedFully = true;
    private boolean hasNonEmbeddedCIDFonts;
    private boolean hasYCCKimages;
    private boolean ttHintingRequired;
    private boolean timeout = false;
    private Iterator colorSpacesUsed;
    private String nonEmbeddedCIDFonts = "";
    private boolean hasEmbeddedFonts = false;

    public boolean getImagesProcessedFully() {
        return this.imagesProcessedFully;
    }

    public void update(PdfStreamDecoder pdfStreamDecoder, boolean bl) {
        this.colorSpacesUsed = (Iterator)pdfStreamDecoder.getObjectValue(1);
        this.nonEmbeddedCIDFonts = (String)pdfStreamDecoder.getObjectValue(4);
        this.hasYCCKimages = pdfStreamDecoder.getBooleanValue(8);
        this.imagesProcessedFully = pdfStreamDecoder.getBooleanValue(2);
        this.hasNonEmbeddedCIDFonts = pdfStreamDecoder.getBooleanValue(4);
        this.ttHintingRequired = pdfStreamDecoder.getBooleanValue(32);
        this.timeout = pdfStreamDecoder.getBooleanValue(16);
        if (bl) {
            this.hasEmbeddedFonts = pdfStreamDecoder.getBooleanValue(-1);
        }
    }

    public void resetTimeout() {
        this.timeout = false;
    }

    public boolean getPageDecodeStatus(int n) {
        switch (n) {
            case 4: {
                return this.hasNonEmbeddedCIDFonts;
            }
            case 2: {
                return this.imagesProcessedFully;
            }
            case 16: {
                return this.timeout;
            }
            case 8: {
                return this.hasYCCKimages;
            }
            case 32: {
                return this.ttHintingRequired;
            }
        }
        new RuntimeException("Unknown parameter");
        return false;
    }

    public Iterator getPageInfo(int n) {
        switch (n) {
            case 1: {
                return this.colorSpacesUsed;
            }
        }
        return null;
    }

    public String getPageDecodeStatusReport(int n) {
        if (n == 4) {
            return this.nonEmbeddedCIDFonts;
        }
        new RuntimeException("Unknown parameter");
        return "";
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public void resetColorSpaces() {
        this.colorSpacesUsed = null;
    }
}

