/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.remoteaccess.server.internal;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.execution.api.SingleConsoleRowsProcessor;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.execution.api.FinalWorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionContextBuilder;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.embedded.ssh.api.EmbeddedSshServerControl;
import de.rcenvironment.core.monitoring.system.api.LocalSystemMonitoringAggregationService;
import de.rcenvironment.core.monitoring.system.api.model.AverageOfDoubles;
import de.rcenvironment.core.monitoring.system.api.model.SystemLoadInformation;
import de.rcenvironment.core.remoteaccess.server.internal.RemoteAccessService;
import de.rcenvironment.core.utils.common.InvalidFilenameException;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteAccessServiceImpl
implements RemoteAccessService {
    private static final int PERCENT_MULTIPLIER = 100;
    private static final int INT_NO_DATA_PLACEHOLDER = -1;
    private static final double DOUBLE_NO_DATA_PLACEHOLDER = -1.0;
    private static final String INTERFACE_ENDPOINT_NAME_INPUT = "input";
    private static final String INTERFACE_ENDPOINT_NAME_PARAMETERS = "parameters";
    private static final String INTERFACE_ENDPOINT_NAME_OUTPUT = "output";
    private static final String WF_PLACEHOLDER_PARAMETERS = "##RUNTIME_PARAMETERS##";
    private static final String WF_PLACEHOLDER_INPUT_DIR = "##RUNTIME_INPUT_DIRECTORY##";
    private static final String WF_PLACEHOLDER_OUTPUT_PARENT_DIR = "##RUNTIME_OUTPUT_DIRECTORY##";
    private static final String WF_PLACEHOLDER_OUTPUT_FILES_FOLDER_NAME = "##OUTPUT_FILES_FOLDER_NAME##";
    private static final String WORKFLOW_TEMPLATE_RESOURCE_PATH = "/resources/template.wf";
    private static final String WF_PLACEHOLDER_TOOL_ID = "##TOOL_ID##";
    private static final String WF_PLACEHOLDER_TOOL_VERSION = "##TOOL_VERSION##";
    private static final String WF_PLACEHOLDER_TOOL_NODE_ID = "##TOOL_NODE_ID##";
    private static final String WF_PLACEHOLDER_TIMESTAMP = "##TIMESTAMP##";
    private static final String WORKFLOW_FILE_ENCODING = "UTF-8";
    private static final String PUBLISHED_WF_DATA_FILE_SUFFIX = ".wf.dat";
    private static final String PUBLISHED_WF_PLACEHOLDER_FILE_SUFFIX = ".ph.dat";
    private static final String OUTPUT_INDENT = "    ";
    private final Log log = LogFactory.getLog(this.getClass());
    private final Map<String, String> publishedWorkflowTemplates = new HashMap<String, String>();
    private final Map<String, String> publishedWorkflowTemplatePlaceholders = new HashMap<String, String>();
    private final TempFileService tempFileService = TempFileServiceAccess.getInstance();
    private DistributedComponentKnowledgeService componentKnowledgeService;
    private HeadlessWorkflowExecutionService workflowExecutionService;
    private PlatformService platformService;
    private ConfigurationService configurationService;
    private LocalSystemMonitoringAggregationService localSystemMonitoringAggregationService;
    private File publishedWfStorageDir;
    private EmbeddedSshServerControl embeddedSshServerControl;

    public void activate() {
        this.initAndRestoreFromPublishedWfStorage();
        this.embeddedSshServerControl.setAnnouncedVersionOrProperty("RemoteAccess", "8.0.0");
    }

    @Override
    public void printListOfAvailableTools(TextOutputReceiver outputReceiver, String format, boolean includeLoadData, int timeSpanMsec, int timeLimitMsec) throws InterruptedException, ExecutionException, TimeoutException {
        Map systemLoadData;
        List<ComponentInstallation> components = this.getMatchingPublishedTools();
        if (includeLoadData) {
            HashSet<LogicalNodeId> reachableInstanceNodes = new HashSet<LogicalNodeId>();
            for (ComponentInstallation c : components) {
                reachableInstanceNodes.add(c.fetchNodeIdAsObject());
            }
            systemLoadData = this.localSystemMonitoringAggregationService.collectSystemMonitoringDataWithTimeLimit(reachableInstanceNodes, timeSpanMsec, timeLimitMsec);
        } else {
            systemLoadData = null;
        }
        if ("csv".equals(format)) {
            this.printComponentsListAsCsv(components, outputReceiver, systemLoadData);
        } else if ("token-stream".equals(format)) {
            this.printComponentsListAsTokens(components, outputReceiver, systemLoadData);
        } else {
            throw new IllegalArgumentException("Unrecognized output format: " + format);
        }
    }

    @Override
    public void printListOfAvailableWorkflows(TextOutputReceiver outputReceiver, String format) {
        if (!"token-stream".equals(format)) {
            throw new IllegalArgumentException("Unrecognized output format: " + format);
        }
        TreeSet<String> wfIds = new TreeSet<String>(this.publishedWorkflowTemplates.keySet());
        outputReceiver.addOutput(Integer.toString(wfIds.size()));
        outputReceiver.addOutput("4");
        for (String publishId : wfIds) {
            if (!this.checkIdOrVersionString(publishId)) {
                this.log.error((Object)("Not listing the previously published remote access workflow " + publishId + "; the name contains characters that are not allowed anymore"));
                continue;
            }
            String nodeId = this.platformService.getLocalDefaultLogicalNodeId().getLogicalNodeIdString();
            String nodeName = this.platformService.getLocalInstanceNodeSessionId().getAssociatedDisplayName();
            outputReceiver.addOutput(publishId);
            outputReceiver.addOutput("1");
            outputReceiver.addOutput(nodeId);
            outputReceiver.addOutput(nodeName);
        }
    }

    @Override
    public FinalWorkflowState runSingleToolWorkflow(String toolId, String toolVersion, String toolNodeId, String parameterString, File inputFilesDir, File outputFilesDir, SingleConsoleRowsProcessor consoleRowReceiver) throws IOException, WorkflowExecutionException {
        this.validateIdOrVersionString(toolId);
        this.validateIdOrVersionString(toolVersion);
        ExecutionSetup executionSetup = this.generateSingleToolExecutionSetup(toolId, toolVersion, toolNodeId, parameterString, inputFilesDir, outputFilesDir);
        return this.executeConfiguredWorkflow(executionSetup, consoleRowReceiver);
    }

    @Override
    public FinalWorkflowState runPublishedWorkflowTemplate(String workflowId, String parameterString, File inputFilesDir, File outputFilesDir, SingleConsoleRowsProcessor consoleRowReceiver) throws IOException, WorkflowExecutionException {
        this.validateIdOrVersionString(workflowId);
        ExecutionSetup executionSetup = this.generateWorkflowExecutionSetup(workflowId, parameterString, inputFilesDir, outputFilesDir);
        return this.executeConfiguredWorkflow(executionSetup, consoleRowReceiver);
    }

    @Override
    public void checkAndPublishWorkflowFile(File wfFile, File placeholdersFile, String publishId, TextOutputReceiver outputReceiver, boolean persistent) throws WorkflowExecutionException {
        WorkflowDescription wd;
        this.validateIdOrVersionString(publishId);
        try {
            wd = this.workflowExecutionService.loadWorkflowDescriptionFromFileConsideringUpdates(wfFile, (WorkflowDescriptionLoaderCallback)new HeadlessWorkflowDescriptionLoaderCallback(outputReceiver));
        }
        catch (WorkflowFileException e) {
            throw new WorkflowExecutionException("Failed to load workflow file: " + wfFile.getAbsolutePath(), (Exception)((Object)e));
        }
        if (placeholdersFile != null) {
            try {
                this.workflowExecutionService.validatePlaceholdersFile(placeholdersFile);
            }
            catch (WorkflowFileException e) {
                throw new WorkflowExecutionException("Failed to validate placeholders file: " + wfFile.getAbsolutePath(), (Exception)((Object)e));
            }
        }
        File workflowStorageFile = this.getWorkflowStorageFile(publishId);
        File placeholderStorageFile = this.getPlaceholderStorageFile(publishId);
        if (!persistent && workflowStorageFile.exists()) {
            throw new WorkflowExecutionException("You are trying to overwrite a persistently published workflow with a temporary/transient one; if this is what you want to do, unpublish the old workflow first, then publish the new one again");
        }
        outputReceiver.addOutput(StringUtils.format((String)"Checking workflow file \"%s\"", (Object[])new Object[]{wfFile.getAbsolutePath()}));
        if (this.validateWorkflowFileAsTemplate(wd, outputReceiver)) {
            try {
                String wfFileContent = this.readFile(wfFile);
                String replaced = this.publishedWorkflowTemplates.put(publishId, wfFileContent);
                if (persistent) {
                    FileUtils.writeStringToFile((File)workflowStorageFile, (String)wfFileContent);
                }
                if (placeholdersFile != null) {
                    String placeholdersFileContent = this.readFile(placeholdersFile);
                    this.publishedWorkflowTemplatePlaceholders.put(publishId, placeholdersFileContent);
                    if (persistent) {
                        FileUtils.writeStringToFile((File)placeholderStorageFile, (String)placeholdersFileContent);
                    }
                } else {
                    this.publishedWorkflowTemplatePlaceholders.put(publishId, null);
                }
                if (replaced == null) {
                    outputReceiver.addOutput(StringUtils.format((String)"Successfully published workflow \"%s\"", (Object[])new Object[]{publishId}));
                } else {
                    outputReceiver.addOutput(StringUtils.format((String)"Successfully updated the published workflow \"%s\"", (Object[])new Object[]{publishId}));
                }
            }
            catch (IOException iOException) {
                this.publishedWorkflowTemplates.remove(publishId);
                FileUtils.deleteQuietly((File)workflowStorageFile);
                throw new WorkflowExecutionException("Error publishing workflow file " + wfFile.getAbsolutePath());
            }
        }
    }

    @Override
    public void unpublishWorkflowForId(String publishId, TextOutputReceiver outputReceiver) throws WorkflowExecutionException {
        File placeholderStorageFile;
        this.validateIdOrVersionString(publishId);
        String removed = this.publishedWorkflowTemplates.remove(publishId);
        this.publishedWorkflowTemplatePlaceholders.remove(publishId);
        File workflowStorageFile = this.getWorkflowStorageFile(publishId);
        if (workflowStorageFile.isFile()) {
            try {
                Files.delete(workflowStorageFile.toPath());
            }
            catch (IOException iOException) {
                throw new WorkflowExecutionException("Failed to unpublish the specified workflow; its storage file may be write-protected");
            }
        }
        if ((placeholderStorageFile = this.getPlaceholderStorageFile(publishId)).isFile()) {
            try {
                Files.delete(placeholderStorageFile.toPath());
            }
            catch (IOException iOException) {
                throw new WorkflowExecutionException("Failed to unpublish the published placeholder file for the specified workflow; its storage file may be write-protected");
            }
        }
        if (removed != null) {
            outputReceiver.addOutput(StringUtils.format((String)"Successfully unpublished workflow \"%s\"", (Object[])new Object[]{publishId}));
        } else {
            outputReceiver.addOutput(StringUtils.format((String)"ERROR: There is no workflow with id \"%s\" to unpublish", (Object[])new Object[]{publishId}));
        }
    }

    @Override
    public void printSummaryOfPublishedWorkflows(TextOutputReceiver outputReceiver) {
        if (this.publishedWorkflowTemplates.isEmpty()) {
            outputReceiver.addOutput("There are no workflows published for remote execution");
            return;
        }
        outputReceiver.addOutput("Workflows published for remote execution:");
        for (String publishId : this.publishedWorkflowTemplates.keySet()) {
            String placeholders = "no";
            if (this.publishedWorkflowTemplatePlaceholders.get(publishId) != null) {
                placeholders = "yes";
            }
            outputReceiver.addOutput(StringUtils.format((String)"- %s (using placeholders: %s)", (Object[])new Object[]{publishId, placeholders}));
        }
    }

    @Override
    public String validateToolParametersAndGetFinalNodeId(String toolId, String toolVersion, String nodeId) throws WorkflowExecutionException {
        List<ComponentInstallation> availableTools = this.getMatchingPublishedTools();
        this.validateIdOrVersionString(toolId);
        this.validateIdOrVersionString(toolVersion);
        ComponentInstallation nodeMatch = null;
        for (ComponentInstallation compInst : availableTools) {
            ComponentInterface compInterface = compInst.getComponentRevision().getComponentInterface();
            if (!toolId.equals(compInterface.getDisplayName()) || !toolVersion.equals(compInterface.getVersion())) continue;
            if (nodeId != null) {
                if (!nodeId.equals(compInst.getNodeId())) continue;
                return compInst.getNodeId();
            }
            if (nodeMatch == null) {
                nodeMatch = compInst;
                continue;
            }
            throw new WorkflowExecutionException(StringUtils.format((String)"Tool selection is ambiguous without a node id; tool '%s', version '%s' is provided by more than one node", (Object[])new Object[]{toolId, toolVersion}));
        }
        if (nodeId == null) {
            if (nodeMatch != null) {
                return nodeMatch.getNodeId();
            }
            throw new WorkflowExecutionException(StringUtils.format((String)"No matching tool for tool '%s' in version '%s'", (Object[])new Object[]{toolId, toolVersion, nodeId}));
        }
        throw new WorkflowExecutionException(StringUtils.format((String)"No matching tool for tool '%s' in version '%s', running on a node with id '%s'", (Object[])new Object[]{toolId, toolVersion, nodeId}));
    }

    public void bindWorkflowExecutionService(HeadlessWorkflowExecutionService newInstance) {
        this.workflowExecutionService = newInstance;
    }

    public void bindPlatformService(PlatformService newInstance) {
        this.platformService = newInstance;
    }

    public void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService newInstance) {
        this.componentKnowledgeService = newInstance;
    }

    public void bindLocalSystemMonitoringAggregationService(LocalSystemMonitoringAggregationService newInstance) {
        this.localSystemMonitoringAggregationService = newInstance;
    }

    public void bindEmbeddedSshServerControl(EmbeddedSshServerControl newInstance) {
        this.embeddedSshServerControl = newInstance;
    }

    public void bindConfigurationService(ConfigurationService newInstance) {
        this.configurationService = newInstance;
    }

    private void initAndRestoreFromPublishedWfStorage() {
        this.publishedWfStorageDir = new File(this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_INTERNAL_DATA), "ra/published-wf");
        this.publishedWfStorageDir.mkdirs();
        if (!this.publishedWfStorageDir.isDirectory()) {
            this.log.error((Object)("Failed to create Remote Access workflow storage directory " + this.publishedWfStorageDir.getAbsolutePath()));
            this.publishedWfStorageDir = null;
            return;
        }
        File[] fileArray = this.publishedWfStorageDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String wfId;
            File f = fileArray[n2];
            String filename = f.getName();
            if (filename.endsWith(PUBLISHED_WF_DATA_FILE_SUFFIX)) {
                wfId = filename.substring(0, filename.length() - PUBLISHED_WF_DATA_FILE_SUFFIX.length());
                try {
                    this.publishedWorkflowTemplates.put(wfId, FileUtils.readFileToString((File)f));
                }
                catch (IOException e) {
                    this.log.error((Object)("Failed to restore data of published RemoteAccess workflow from storage file " + f.getAbsolutePath()), (Throwable)e);
                }
            } else if (filename.endsWith(PUBLISHED_WF_PLACEHOLDER_FILE_SUFFIX)) {
                wfId = filename.substring(0, filename.length() - PUBLISHED_WF_PLACEHOLDER_FILE_SUFFIX.length());
                try {
                    this.publishedWorkflowTemplatePlaceholders.put(wfId, FileUtils.readFileToString((File)f));
                }
                catch (IOException e) {
                    this.log.error((Object)("Failed to restore placeholder data of published RemoteAccess workflow from storage file " + f.getAbsolutePath()), (Throwable)e);
                }
            } else {
                this.log.error((Object)("Unexpected file in RemoteAccess storage directory, ignoring: " + f.getAbsolutePath()));
            }
            ++n2;
        }
    }

    private File getWorkflowStorageFile(String id) throws WorkflowExecutionException {
        if (this.publishedWfStorageDir == null) {
            throw new WorkflowExecutionException("The workflow storage directory was not properly initialized; cannot execute this command");
        }
        File file = new File(this.publishedWfStorageDir, String.valueOf(id) + PUBLISHED_WF_DATA_FILE_SUFFIX);
        this.log.debug((Object)("Resolved workflow publish id to storage filename " + file.getAbsolutePath()));
        return file;
    }

    private File getPlaceholderStorageFile(String id) throws WorkflowExecutionException {
        if (this.publishedWfStorageDir == null) {
            throw new WorkflowExecutionException("The workflow storage directory was not properly initialized; cannot execute this command");
        }
        return new File(this.publishedWfStorageDir, String.valueOf(id) + PUBLISHED_WF_PLACEHOLDER_FILE_SUFFIX);
    }

    private boolean isComponentSuitableAsRemoteAccessTool(ComponentInstallation compInst) {
        ComponentInterface compInterf = compInst.getComponentRevision().getComponentInterface();
        if (!this.checkIdOrVersionString(compInterf.getDisplayName()) || !this.checkIdOrVersionString(compInterf.getVersion())) {
            return false;
        }
        if (compInterf.getInputDefinitionsProvider().getStaticEndpointDefinitions().size() != 2) {
            return false;
        }
        EndpointDefinition endpoint = compInterf.getInputDefinitionsProvider().getStaticEndpointDefinition(INTERFACE_ENDPOINT_NAME_INPUT);
        if (endpoint == null || !endpoint.getPossibleDataTypes().contains(DataType.DirectoryReference)) {
            return false;
        }
        endpoint = compInterf.getInputDefinitionsProvider().getStaticEndpointDefinition(INTERFACE_ENDPOINT_NAME_PARAMETERS);
        if (endpoint == null || !endpoint.getPossibleDataTypes().contains(DataType.ShortText)) {
            return false;
        }
        endpoint = compInterf.getOutputDefinitionsProvider().getStaticEndpointDefinition(INTERFACE_ENDPOINT_NAME_OUTPUT);
        return endpoint != null && endpoint.getDefaultDataType() == DataType.DirectoryReference;
    }

    private List<ComponentInstallation> getMatchingPublishedTools() {
        ArrayList<ComponentInstallation> components = new ArrayList<ComponentInstallation>();
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentComponentKnowledge();
        for (ComponentInstallation ci : compKnowledge.getAllPublishedInstallations()) {
            if (!this.isComponentSuitableAsRemoteAccessTool(ci)) continue;
            components.add(ci);
        }
        return components;
    }

    private void printComponentsListAsCsv(List<ComponentInstallation> components, TextOutputReceiver outputReceiver, Map<LogicalNodeId, SystemLoadInformation> systemLoadData) {
        TreeSet<String> lines = new TreeSet<String>();
        CSVFormat csvFormat = CSVFormat.newFormat((char)' ').withQuote('\"').withQuoteMode(QuoteMode.ALL);
        for (ComponentInstallation ci : components) {
            ComponentInterface compInterface = ci.getComponentRevision().getComponentInterface();
            String nodeId = ci.getNodeId();
            String nodeName = NodeIdentifierUtils.parseLogicalNodeIdStringWithExceptionWrapping((String)nodeId).getAssociatedDisplayName();
            if (systemLoadData != null) {
                long availableRam;
                int timeSpan;
                int numSamples;
                double cpuAvg;
                SystemLoadInformation loadDataEntry = systemLoadData.get(ci.fetchNodeIdAsObject());
                if (loadDataEntry != null) {
                    AverageOfDoubles cpuLoadAvg = loadDataEntry.getCpuLoadAvg();
                    cpuAvg = cpuLoadAvg.getAverage() * 100.0;
                    numSamples = cpuLoadAvg.getNumSamples();
                    timeSpan = cpuLoadAvg.getNumSamples() * 1000;
                    availableRam = loadDataEntry.getAvailableRam();
                } else {
                    cpuAvg = -1.0;
                    numSamples = -1;
                    timeSpan = -1;
                    availableRam = -1L;
                }
                lines.add(csvFormat.format(new Object[]{compInterface.getDisplayName(), compInterface.getVersion(), nodeId, nodeName, StringUtils.format((String)"%.2f", (Object[])new Object[]{cpuAvg}), numSamples, timeSpan, availableRam}));
                continue;
            }
            lines.add(csvFormat.format(new Object[]{compInterface.getDisplayName(), compInterface.getVersion(), nodeId, nodeName}));
        }
        for (String line : lines) {
            outputReceiver.addOutput(line);
        }
    }

    private void printComponentsListAsTokens(List<ComponentInstallation> components, TextOutputReceiver outputReceiver, Map<LogicalNodeId, SystemLoadInformation> systemLoadData) {
        outputReceiver.addOutput(Integer.toString(components.size()));
        if (systemLoadData != null) {
            outputReceiver.addOutput("8");
        } else {
            outputReceiver.addOutput("4");
        }
        for (ComponentInstallation ci : components) {
            long availableRam;
            int timeSpan;
            int numSamples;
            double cpuAvg;
            ComponentInterface compInterface = ci.getComponentRevision().getComponentInterface();
            String nodeId = ci.getNodeId();
            String nodeName = NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)nodeId).getAssociatedDisplayName();
            outputReceiver.addOutput(compInterface.getDisplayName());
            outputReceiver.addOutput(compInterface.getVersion());
            outputReceiver.addOutput(nodeId);
            outputReceiver.addOutput(nodeName);
            if (systemLoadData == null) continue;
            SystemLoadInformation loadDataEntry = systemLoadData.get(ci.fetchNodeIdAsObject());
            if (loadDataEntry != null) {
                AverageOfDoubles cpuLoadAvg = loadDataEntry.getCpuLoadAvg();
                cpuAvg = cpuLoadAvg.getAverage() * 100.0;
                numSamples = cpuLoadAvg.getNumSamples();
                timeSpan = cpuLoadAvg.getNumSamples() * 1000;
                availableRam = loadDataEntry.getAvailableRam();
            } else {
                cpuAvg = -1.0;
                numSamples = -1;
                timeSpan = -1;
                availableRam = -1L;
            }
            outputReceiver.addOutput(StringUtils.format((String)"%.2f", (Object[])new Object[]{cpuAvg}));
            outputReceiver.addOutput(Integer.toString(numSamples));
            outputReceiver.addOutput(Integer.toString(timeSpan));
            outputReceiver.addOutput(Long.toString(availableRam));
        }
    }

    private boolean validateWorkflowFileAsTemplate(WorkflowDescription wd, TextOutputReceiver outputReceiver) throws WorkflowExecutionException {
        this.validateEquals(5, wd.getWorkflowVersion(), "Invalid workflow file version");
        MutableYesNoFlag foundInputDirSource = new MutableYesNoFlag();
        MutableYesNoFlag foundParametersSource = new MutableYesNoFlag();
        MutableYesNoFlag foundOutputReceiver = new MutableYesNoFlag();
        for (WorkflowNode node : wd.getWorkflowNodes()) {
            outputReceiver.addOutput("    Checking component \"" + node.getName() + "\"  [" + node.getIdentifier() + "]");
            ComponentDescription compDesc = node.getComponentDescription();
            String compId = compDesc.getIdentifier();
            String compVersion = compDesc.getVersion();
            if (compId.startsWith("de.rcenvironment.inputprovider/")) {
                this.validateEquals("3.2", compVersion, "Invalid component version");
                for (EndpointDescription outputEndpoint : node.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                    this.checkEndpoint(outputEndpoint, "input directory source", INTERFACE_ENDPOINT_NAME_INPUT, DataType.DirectoryReference, WF_PLACEHOLDER_INPUT_DIR, foundInputDirSource, outputReceiver);
                    this.checkEndpoint(outputEndpoint, "input parameters source", INTERFACE_ENDPOINT_NAME_PARAMETERS, DataType.ShortText, WF_PLACEHOLDER_PARAMETERS, foundParametersSource, outputReceiver);
                }
                continue;
            }
            if (!compId.startsWith("de.rcenvironment.outputwriter/")) continue;
            this.validateEquals("2.0", compVersion, "Invalid component version");
            Map compConfig = compDesc.getConfigurationDescription().getConfiguration();
            String selectedRoot = (String)compConfig.get("SelectedRoot");
            if (WF_PLACEHOLDER_OUTPUT_PARENT_DIR.equals(selectedRoot)) {
                for (EndpointDescription inputEndpoint : node.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
                    this.checkEndpoint(inputEndpoint, "output directory receiver", INTERFACE_ENDPOINT_NAME_OUTPUT, DataType.DirectoryReference, null, foundOutputReceiver, outputReceiver);
                }
                this.validateEquals("false", compConfig.get("SelectRootOnWorkflowStart"), "Invalid \"Select at workflow start\" setting");
                continue;
            }
            this.printEndpointValidationMessage(outputReceiver, StringUtils.format((String)"Ignoring this Output Writer as its \"Root folder\" setting is not the \"%s\" marker", (Object[])new Object[]{WF_PLACEHOLDER_OUTPUT_PARENT_DIR}));
        }
        if (foundInputDirSource.getValue() && foundParametersSource.getValue() && foundOutputReceiver.getValue()) {
            outputReceiver.addOutput("Validation successful");
            return true;
        }
        outputReceiver.addOutput("Validation failed:");
        outputReceiver.addOutput("    Found input directory source: " + foundInputDirSource);
        outputReceiver.addOutput("    Found input parameters source: " + foundParametersSource);
        outputReceiver.addOutput("    Found output receiver: " + foundOutputReceiver);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkEndpoint(EndpointDescription endpoint, String description, String expectedName, DataType expectedDataType, String placeholderMarker, MutableYesNoFlag detectionFlag, TextOutputReceiver outputReceiver) throws WorkflowExecutionException {
        boolean allMatched;
        String actualName;
        block12: {
            actualName = endpoint.getName();
            DataType actualDataType = endpoint.getDataType();
            boolean dataTypeMatches = expectedDataType == actualDataType;
            boolean nameMatches = expectedName.equals(actualName);
            allMatched = false;
            if (placeholderMarker != null) {
                boolean hasMarkerValue = placeholderMarker.equals(endpoint.getMetaDataValue("startValue"));
                if (!nameMatches && !hasMarkerValue) {
                    return;
                }
                if (nameMatches && dataTypeMatches && hasMarkerValue) {
                    allMatched = true;
                    break block12;
                } else {
                    this.printEndpointValidationMessage(outputReceiver, StringUtils.format((String)"Output \"%s\" is a candidate for the %s, but it does not quite match: ", (Object[])new Object[]{expectedName, description}));
                    if (!nameMatches) {
                        this.printEndpointValidationMessage(outputReceiver, StringUtils.format((String)"  - Unexpected name \"%s\" instead of \"%s\"", (Object[])new Object[]{actualName, expectedName}));
                    }
                    if (!dataTypeMatches) {
                        this.printEndpointValidationMessage(outputReceiver, StringUtils.format((String)"  - Unexpected data type \"%s\" instead of \"%s\"", (Object[])new Object[]{actualDataType.getDisplayName(), expectedDataType.getDisplayName()}));
                    }
                    if (!hasMarkerValue) {
                        this.printEndpointValidationMessage(outputReceiver, StringUtils.format((String)"  - Marker value \"%s\" not found", (Object[])new Object[]{placeholderMarker}));
                    }
                    return;
                }
            }
            if (!nameMatches || !dataTypeMatches) {
                this.printEndpointValidationMessage(outputReceiver, StringUtils.format((String)"Input \"%s\" is a candidate for the %s, but it does not quite match: ", (Object[])new Object[]{actualName, description}));
                if (!nameMatches) {
                    this.printEndpointValidationMessage(outputReceiver, StringUtils.format((String)"  - Unexpected name \"%s\" instead of \"%s\"", (Object[])new Object[]{actualName, expectedName}));
                }
                if (!dataTypeMatches) {
                    this.printEndpointValidationMessage(outputReceiver, StringUtils.format((String)"  - Unexpected data type \"%s\" instead of \"%s\"", (Object[])new Object[]{actualDataType.getDisplayName(), expectedDataType.getDisplayName()}));
                }
                return;
            }
            this.validateEquals(INTERFACE_ENDPOINT_NAME_OUTPUT, endpoint.getMetaDataValue("filename"), "Invalid \"Target name\" setting in Output Writer; must be \"output\"");
            this.validateEquals("[root]", endpoint.getMetaDataValue("folderForSaving"), "Invalid \"Target folder\" setting in Output Writer; must be \"[root]\"");
            allMatched = true;
        }
        if (!allMatched) {
            throw new IllegalStateException("Internal error: Expected flag not set");
        }
        if (detectionFlag.getValue()) {
            throw new WorkflowExecutionException("Found more than one " + description + " provider");
        }
        this.printEndpointValidationMessage(outputReceiver, StringUtils.format((String)"Found %s \"%s\"", (Object[])new Object[]{description, actualName}));
        detectionFlag.setValue(true);
    }

    private void printEndpointValidationMessage(TextOutputReceiver outputReceiver, String message) {
        outputReceiver.addOutput("        " + message);
    }

    private void validateEquals(Object expected, Object actual, String message) throws WorkflowExecutionException {
        if (!expected.equals(actual)) {
            throw new WorkflowExecutionException(StringUtils.format((String)"%s: Expected \"%s\", but found \"%s\"", (Object[])new Object[]{message, expected, actual}));
        }
    }

    private boolean checkIdOrVersionString(String id) {
        return StringUtils.checkAgainstCommonInputRules((String)id) == null;
    }

    private void validateIdOrVersionString(String id) throws WorkflowExecutionException {
        String valdationErrorMessage = StringUtils.checkAgainstCommonInputRules((String)id);
        if (valdationErrorMessage != null) {
            throw new WorkflowExecutionException("Invalid tool id, workflow id, or version \"" + id + "\": " + valdationErrorMessage);
        }
    }

    private String readFile(File placeholdersFile) throws IOException {
        return FileUtils.readFileToString((File)placeholdersFile, (String)WORKFLOW_FILE_ENCODING);
    }

    private void renameAsOld(File outputFilesDir) {
        File tempDestination = new File(outputFilesDir.getParentFile(), String.valueOf(outputFilesDir.getName()) + ".old." + System.currentTimeMillis());
        outputFilesDir.renameTo(tempDestination);
        if (outputFilesDir.isDirectory()) {
            this.log.warn((Object)("Tried to move directory " + outputFilesDir.getAbsolutePath() + " to " + tempDestination.getAbsolutePath() + ", but it is still present"));
        }
    }

    private ExecutionSetup generateSingleToolExecutionSetup(String toolId, String toolVersion, String toolNodeId, String parameterString, File inputFilesDir, File outputFilesDir) throws IOException {
        InputStream templateStream = this.getClass().getResourceAsStream(WORKFLOW_TEMPLATE_RESOURCE_PATH);
        if (templateStream == null) {
            throw new IOException("Failed to read remote tool access template");
        }
        String template = IOUtils.toString((InputStream)templateStream, (String)WORKFLOW_FILE_ENCODING);
        if (template == null || template.isEmpty()) {
            throw new IOException("Found remote tool access template, but had empty content after loading it");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
        String timestampString = dateFormat.format(new Date());
        String workflowContent = template.replace(WF_PLACEHOLDER_TOOL_ID, toolId).replace(WF_PLACEHOLDER_TOOL_VERSION, toolVersion).replace(WF_PLACEHOLDER_TOOL_NODE_ID, toolNodeId).replace(WF_PLACEHOLDER_PARAMETERS, StringUtils.escapeAsJsonStringContent((String)parameterString, (boolean)false)).replace(WF_PLACEHOLDER_TIMESTAMP, timestampString).replace(WF_PLACEHOLDER_INPUT_DIR, this.formatPathForWorkflowFile(inputFilesDir)).replace(WF_PLACEHOLDER_OUTPUT_PARENT_DIR, this.formatPathForWorkflowFile(outputFilesDir.getParentFile())).replace(WF_PLACEHOLDER_OUTPUT_FILES_FOLDER_NAME, outputFilesDir.getName());
        File wfFile = this.tempFileService.createTempFileFromPattern("rta-*.wf");
        FileUtils.write((File)wfFile, (CharSequence)workflowContent, (String)WORKFLOW_FILE_ENCODING);
        return new ExecutionSetup(wfFile, null, inputFilesDir, outputFilesDir);
    }

    private ExecutionSetup generateWorkflowExecutionSetup(String workflowId, String parameterString, File inputFilesDir, File outputFilesDir) throws IOException, WorkflowExecutionException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
        String timestampString = dateFormat.format(new Date());
        String template = this.publishedWorkflowTemplates.get(workflowId);
        String placeholdersFileContent = this.publishedWorkflowTemplatePlaceholders.get(workflowId);
        if (template == null) {
            throw new WorkflowExecutionException("There is no published workflow for id " + workflowId);
        }
        File placeholdersFile = null;
        if (placeholdersFileContent != null) {
            placeholdersFile = this.tempFileService.createTempFileFromPattern("rwa-properties-*.json");
            FileUtils.writeStringToFile((File)placeholdersFile, (String)placeholdersFileContent, (String)WORKFLOW_FILE_ENCODING);
        }
        String workflowContent = template.replace(WF_PLACEHOLDER_PARAMETERS, StringUtils.escapeAsJsonStringContent((String)parameterString, (boolean)false)).replace(WF_PLACEHOLDER_TIMESTAMP, timestampString).replace(WF_PLACEHOLDER_INPUT_DIR, this.formatPathForWorkflowFile(inputFilesDir)).replace(WF_PLACEHOLDER_OUTPUT_PARENT_DIR, this.formatPathForWorkflowFile(outputFilesDir.getParentFile()));
        File wfFile = this.tempFileService.createTempFileFromPattern("rwa-*.wf");
        FileUtils.write((File)wfFile, (CharSequence)workflowContent, (String)WORKFLOW_FILE_ENCODING);
        return new ExecutionSetup(wfFile, placeholdersFile, inputFilesDir, outputFilesDir);
    }

    private FinalWorkflowState executeConfiguredWorkflow(ExecutionSetup executionSetup, SingleConsoleRowsProcessor customConsoleRowReceiver) throws WorkflowExecutionException {
        HeadlessWorkflowExecutionContextBuilder exeContextBuilder;
        File logDir;
        this.log.debug((Object)("Executing remote access workflow " + executionSetup.getWorkflowFile().getAbsolutePath()));
        File inputFilesDir = executionSetup.getInputFilesDir();
        File outputFilesDir = executionSetup.getOutputFilesDir();
        if (outputFilesDir.isDirectory()) {
            this.renameAsOld(outputFilesDir);
        }
        if ((logDir = new File(outputFilesDir.getParent(), "logs")).isDirectory()) {
            this.renameAsOld(logDir);
        }
        logDir.mkdirs();
        CapturingTextOutReceiver outputReceiver = new CapturingTextOutReceiver();
        try {
            exeContextBuilder = new HeadlessWorkflowExecutionContextBuilder(executionSetup.getWorkflowFile(), logDir);
        }
        catch (InvalidFilenameException invalidFilenameException) {
            throw new IllegalStateException();
        }
        exeContextBuilder.setPlaceholdersFile(executionSetup.getPlaceholderFile());
        exeContextBuilder.setTextOutputReceiver((TextOutputReceiver)outputReceiver);
        exeContextBuilder.setSingleConsoleRowsProcessor(customConsoleRowReceiver);
        exeContextBuilder.setAbortIfWorkflowUpdateRequired(true);
        WorkflowExecutionException executionException = null;
        FinalWorkflowState finalState = FinalWorkflowState.FAILED;
        try {
            finalState = this.workflowExecutionService.executeWorkflowSync(exeContextBuilder.build());
        }
        catch (WorkflowExecutionException e) {
            executionException = e;
            File exceptionLogFile = new File(logDir, "error.log");
            try {
                FileUtils.writeStringToFile((File)exceptionLogFile, (String)("Workflow execution failed with an error: " + e.toString()));
            }
            catch (IOException iOException) {
                this.log.error((Object)("Failed to write exception log file " + exceptionLogFile.getAbsolutePath()));
            }
        }
        this.log.debug((Object)("Finished remote access workflow; captured output:\n" + outputReceiver.getBufferedOutput()));
        if (inputFilesDir.isDirectory()) {
            File tempDestination = new File(inputFilesDir.getParentFile(), "input.old." + System.currentTimeMillis());
            inputFilesDir.renameTo(tempDestination);
            if (inputFilesDir.isDirectory()) {
                this.log.warn((Object)("Tried to rename input directory " + inputFilesDir.getAbsolutePath() + " to " + tempDestination.getAbsolutePath() + ", but it is still present"));
            }
        }
        if (executionException != null) {
            throw executionException;
        }
        try {
            this.tempFileService.disposeManagedTempDirOrFile(executionSetup.getWorkflowFile());
        }
        catch (IOException iOException) {
            this.log.warn((Object)"Could not delete temporary workflow file");
        }
        return finalState;
    }

    private CharSequence formatPathForWorkflowFile(File directory) {
        return directory.getAbsolutePath().replaceAll("\\\\", "/");
    }

    private static final class ExecutionSetup {
        private File workflowFile;
        private File placeholdersFile;
        private File inputFilesDir;
        private File outputFilesDir;

        ExecutionSetup(File wfFile, File placeholdersFile, File inputFilesDir, File outputFilesDir) {
            this.workflowFile = wfFile;
            this.placeholdersFile = placeholdersFile;
            this.inputFilesDir = inputFilesDir;
            this.outputFilesDir = outputFilesDir;
        }

        public File getWorkflowFile() {
            return this.workflowFile;
        }

        public File getPlaceholderFile() {
            return this.placeholdersFile;
        }

        public File getInputFilesDir() {
            return this.inputFilesDir;
        }

        public File getOutputFilesDir() {
            return this.outputFilesDir;
        }
    }

    private static final class MutableYesNoFlag {
        private boolean value;

        private MutableYesNoFlag() {
        }

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            this.value = value;
        }

        public String toString() {
            if (this.value) {
                return "yes";
            }
            return "no";
        }
    }
}

