/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.instancemanagement.internal;

import de.rcenvironment.core.instancemanagement.internal.InstanceOperationsUtils;
import de.rcenvironment.core.toolkitbridge.transitional.TextStreamWatcherFactory;
import de.rcenvironment.core.utils.common.OSFamily;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.AbstractTextOutputReceiver;
import de.rcenvironment.core.utils.executor.LocalApacheCommandLineExecutor;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstanceStarterTask
implements Runnable {
    private static final String START_UP_HEADLESS_MESSAGE = "Starting instance %s in headless mode...";
    private static final String START_UP_GUI_MESSAGE = "Starting instance %s in GUI mode...";
    private final long timeout;
    private final boolean startWithGUI;
    private final TextOutputReceiver userOutputReceiver;
    private final File profile;
    private final File installationDir;
    private final Log log = LogFactory.getLog(this.getClass());
    private final CountDownLatch globalLatch;
    private final CountDownLatch startupOutputDetected;
    private final AtomicBoolean startupOutputIndicatesSuccess;

    public InstanceStarterTask(long timeout, boolean startWithGUI, TextOutputReceiver userOutputReceiver, File profile, File installationDir, CountDownLatch globalLatch, CountDownLatch startuputOutputDetected, AtomicBoolean startupOutputIndicatesSucess) {
        this.timeout = timeout;
        this.startWithGUI = startWithGUI;
        this.userOutputReceiver = userOutputReceiver;
        this.profile = profile;
        this.installationDir = installationDir;
        this.globalLatch = globalLatch;
        this.startupOutputDetected = startuputOutputDetected;
        this.startupOutputIndicatesSuccess = startupOutputIndicatesSucess;
    }

    @Override
    @TaskDescription(value="Instance Management: Starting an instance")
    public void run() {
        LocalApacheCommandLineExecutor executor;
        try {
            InstanceOperationsUtils.lockIMLockFile(this.profile, this.timeout);
        }
        catch (IOException iOException) {
            this.userOutputReceiver.addOutput(StringUtils.format((String)"Timeout reached while trying to acquire the lock, aborting startup of instance with id: %s.", (Object[])new Object[]{this.profile.getName()}));
            this.releaseLockIfErrorOccurs();
            return;
        }
        Path metadataLogFile = new File(this.profile, "workspace/.metadata/.log").toPath();
        try {
            Files.deleteIfExists(metadataLogFile);
        }
        catch (IOException e) {
            this.userOutputReceiver.addOutput("Failed to delete the existing .metadata/.log file " + metadataLogFile + " before starting the containing profile; error: " + e.toString());
            this.releaseLockIfErrorOccurs();
            return;
        }
        try {
            executor = new LocalApacheCommandLineExecutor(this.installationDir);
        }
        catch (IOException iOException) {
            this.userOutputReceiver.addOutput("The installation directory " + this.installationDir.getAbsolutePath() + " does not exist or can't be created. Aborting startup of instance with id: " + this.profile.getName() + ".");
            this.releaseLockIfErrorOccurs();
            return;
        }
        try {
            if (OSFamily.isWindows()) {
                if (!this.startWithGUI) {
                    this.userOutputReceiver.addOutput(StringUtils.format((String)START_UP_HEADLESS_MESSAGE, (Object[])new Object[]{this.profile.getName()}));
                    executor.start(StringUtils.format((String)"rce --headless -nosplash -p \"%s\"", (Object[])new Object[]{this.profile.getAbsolutePath()}));
                } else {
                    this.userOutputReceiver.addOutput(StringUtils.format((String)START_UP_GUI_MESSAGE, (Object[])new Object[]{this.profile.getName()}));
                    executor.start(StringUtils.format((String)"rce -p \"%s\" --use-default-workspace", (Object[])new Object[]{this.profile.getAbsolutePath()}));
                }
            } else if (!this.startWithGUI) {
                this.userOutputReceiver.addOutput(StringUtils.format((String)START_UP_HEADLESS_MESSAGE, (Object[])new Object[]{this.profile.getName()}));
                executor.start(StringUtils.format((String)"./rce --headless -nosplash -p \"%s\"", (Object[])new Object[]{this.profile.getAbsolutePath()}));
            } else {
                this.userOutputReceiver.addOutput(StringUtils.format((String)START_UP_GUI_MESSAGE, (Object[])new Object[]{this.profile.getName()}));
                executor.start(StringUtils.format((String)"./rce -p \"%s\" --use-default-workspace", (Object[])new Object[]{this.profile.getAbsolutePath()}));
            }
        }
        catch (IOException e) {
            this.userOutputReceiver.addOutput("An error occured on the target executable of instance with id: " + this.profile.getName() + ". Process aborted with message: " + e.getMessage());
            return;
        }
        this.startStdOutStreamWatcher(executor, this.profile.getName());
        this.startStdErrStreamWatcher(executor, this.profile.getName());
        try {
            executor.waitForTermination();
        }
        catch (IOException iOException) {
            this.releaseLockIfErrorOccurs();
        }
        catch (InterruptedException interruptedException) {
            this.releaseLockIfErrorOccurs();
        }
    }

    private void releaseLockIfErrorOccurs() {
        this.startupOutputDetected.countDown();
    }

    private void startStdOutStreamWatcher(LocalApacheCommandLineExecutor executor, final String profileName) {
        TextStreamWatcherFactory.create((InputStream)executor.getStdout(), (TextOutputReceiver[])new TextOutputReceiver[]{new AbstractTextOutputReceiver(){

            public void addOutput(String line) {
                InstanceStarterTask.this.log.debug((Object)("Stdout of instance with id: " + profileName + " : " + line));
                if (line.contains("complete")) {
                    InstanceStarterTask.this.startupOutputDetected.countDown();
                    InstanceStarterTask.this.globalLatch.countDown();
                    InstanceStarterTask.this.userOutputReceiver.addOutput("Successfully started instance " + profileName);
                }
            }
        }}).start();
    }

    private void startStdErrStreamWatcher(LocalApacheCommandLineExecutor executor, final String profileName) {
        TextStreamWatcherFactory.create((InputStream)executor.getStderr(), (TextOutputReceiver[])new TextOutputReceiver[]{new AbstractTextOutputReceiver(){

            public void addOutput(String line) {
                InstanceStarterTask.this.log.debug((Object)("Stderr of instance with id: " + profileName + " : " + line));
                if (line.contains("Failed to lock profile with id " + profileName)) {
                    InstanceStarterTask.this.startupOutputIndicatesSuccess.compareAndSet(true, false);
                    InstanceStarterTask.this.startupOutputDetected.countDown();
                    InstanceStarterTask.this.globalLatch.countDown();
                }
            }
        }}).start();
    }
}

