/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.xpathchooser;

import de.rcenvironment.core.gui.xpathchooser.XPathAttribute;
import de.rcenvironment.core.gui.xpathchooser.XPathLocation;
import de.rcenvironment.core.gui.xpathchooser.XPathNode;
import de.rcenvironment.core.gui.xpathchooser.XPathPredicate;
import de.rcenvironment.core.gui.xpathchooser.XPathStep;
import de.rcenvironment.core.gui.xpathchooser.XPathValue;
import java.util.List;
import java.util.regex.Pattern;

public final class XPathParser {
    private static final String SEP = "/";
    private static final String START = "[A-Za-z_:]";
    private static final String NAME = "[A-Za-z0-9$\ufffd%\\.,;\\-_:]*";
    private static final String QNAME = "[A-Za-z_:][A-Za-z0-9$\ufffd%\\.,;\\-_:]*";
    private static final String QVAL = "\"?[^<&\"]+\"?";
    private static final String OPT_VAL = "(=\"?[^<&\"]+\"?)?";
    private static final String QOPTVALNAME = "[A-Za-z_:][A-Za-z0-9$\ufffd%\\.,;\\-_:]*(=\"?[^<&\"]+\"?)?";
    private static final String PREDICATE = "([/]?[A-Za-z_:][A-Za-z0-9$\ufffd%\\.,;\\-_:]*(=\"?[^<&\"]+\"?)?(/[A-Za-z_:][A-Za-z0-9$\ufffd%\\.,;\\-_:]*(=\"?[^<&\"]+\"?)?)*(/@[A-Za-z_:][A-Za-z0-9$\ufffd%\\.,;\\-_:]*(=\"?[^<&\"]+\"?)?)?|(@[A-Za-z_:][A-Za-z0-9$\ufffd%\\.,;\\-_:]*(=\"?[^<&\"]+\"?)?)?)";

    private XPathParser() {
    }

    public static XPathLocation parse(String expr) {
        XPathLocation xpath = new XPathLocation();
        boolean inString = false;
        boolean inPredicate = false;
        XPathStep cur = null;
        int i = 0;
        while (i < expr.length()) {
            String c = expr.substring(i, i + 1);
            if (c.equals(SEP) && !inString && !(cur instanceof XPathPredicate)) {
                if (i == 0) {
                    xpath.setAbsolute(true);
                }
                cur = null;
            } else if (c.equals("@") && !inString && !(cur instanceof XPathPredicate)) {
                cur = new XPathAttribute();
                xpath.getSteps().add(cur);
            } else if (c.equals("[") && !inString && !(cur instanceof XPathPredicate)) {
                if (cur instanceof XPathNode) {
                    inPredicate = true;
                    ((XPathNode)cur).setPredicate(new XPathPredicate());
                    cur = ((XPathNode)cur).getPredicate();
                }
            } else if (c.equals("]") && !inString) {
                cur = null;
                inPredicate = false;
            } else if (c.equals("=") && !inString && !inPredicate) {
                cur = new XPathValue();
                xpath.getSteps().add(cur);
            } else {
                if (cur == null) {
                    cur = new XPathNode();
                    xpath.getSteps().add(cur);
                }
                cur.setValue(String.valueOf(cur.getValue()) + c);
            }
            if (c.equals("\"")) {
                inString = !inString;
            }
            ++i;
        }
        return xpath;
    }

    public static boolean isValid(String path) {
        XPathLocation loc = XPathParser.parse(path);
        List<XPathStep> steplist = loc.getSteps();
        boolean correct = true;
        for (XPathStep step : steplist) {
            if (step instanceof XPathNode) {
                XPathPredicate pred = ((XPathNode)step).getPredicate();
                if (pred != null && !Pattern.matches(PREDICATE, pred.getValue())) {
                    correct = false;
                    break;
                }
                String nonpred = ((XPathNode)step).getValue();
                if (Pattern.matches(QNAME, nonpred)) continue;
                correct = false;
                break;
            }
            if (step instanceof XPathAttribute) {
                int index = steplist.indexOf(step);
                if (index < steplist.size() - 2) {
                    correct = false;
                    break;
                }
                if (index == steplist.size() - 2) {
                    XPathStep lastStep = steplist.get(steplist.size() - 1);
                    if (lastStep instanceof XPathValue && Pattern.matches(NAME, step.getValue())) break;
                    correct = false;
                    break;
                }
                if (Pattern.matches(QOPTVALNAME, step.getValue())) continue;
                correct = false;
                break;
            }
            correct = false;
            break;
        }
        return correct;
    }

    public static String splitBase(String path) {
        XPathStep step;
        XPathLocation expr = XPathParser.parse(path);
        if (expr.getSteps().size() > 0 && (step = expr.getSteps().remove(expr.getSteps().size() - 1)) instanceof XPathValue) {
            expr.getSteps().remove(expr.getSteps().size() - 1);
        }
        return expr.toString();
    }

    public static String replacePath(String org, String remove) {
        if (remove.equals("") || org.equals("")) {
            return "";
        }
        XPathLocation orgLocation = XPathParser.parse(org);
        List<XPathStep> orgSteps = orgLocation.getSteps();
        List<XPathStep> removeSteps = XPathParser.parse(remove).getSteps();
        int i = 0;
        while (i < removeSteps.size()) {
            if (!orgSteps.get(0).getValue().equals(removeSteps.get(i).getValue())) break;
            orgSteps.remove(0);
            ++i;
        }
        XPathLocation retLocation = new XPathLocation();
        retLocation.setAbsolute(orgLocation.isAbsolute());
        retLocation.getSteps().addAll(orgSteps);
        String ret = retLocation.toString();
        if (ret.equals(SEP)) {
            return "";
        }
        return ret;
    }

    public static String removeLeadingPath(String org, String remove) {
        if (remove.equals("")) {
            return org;
        }
        XPathLocation orgLocation = XPathParser.parse(org);
        List<XPathStep> orgSteps = orgLocation.getSteps();
        List<XPathStep> removeSteps = XPathParser.parse(remove).getSteps();
        int i = 0;
        while (i < removeSteps.size()) {
            if (!orgSteps.get(0).toString().equals(removeSteps.get(i).toString())) break;
            orgSteps.remove(0);
            ++i;
        }
        XPathLocation retLocation = new XPathLocation();
        retLocation.setAbsolute(orgLocation.isAbsolute());
        retLocation.getSteps().addAll(orgSteps);
        String ret = retLocation.toString();
        if (ret.equals(SEP)) {
            return "";
        }
        return ret;
    }

    public static String[] parseValuesToStrings(String xpath) {
        XPathLocation location = XPathParser.parse(xpath);
        List<XPathStep> steps = location.getSteps();
        String[] ret = new String[steps.size()];
        int i = 0;
        while (i < steps.size()) {
            ret[i] = steps.get(i).getValue();
            ++i;
        }
        return ret;
    }

    public static String[] parseToStrings(String xpath) {
        XPathLocation location = XPathParser.parse(xpath);
        List<XPathStep> steps = location.getSteps();
        String[] ret = new String[steps.size()];
        int i = 0;
        while (i < steps.size()) {
            ret[i] = steps.get(i).toString();
            ++i;
        }
        return ret;
    }

    public static String removePredicates(String xpath) {
        XPathLocation location = XPathParser.parse(xpath);
        List<XPathStep> steps = location.getSteps();
        StringBuilder ret = new StringBuilder();
        int i = 0;
        while (i < steps.size()) {
            ret.append(SEP).append(steps.get(i).getValue());
            ++i;
        }
        return ret.toString();
    }
}

