/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentRevision;
import de.rcenvironment.core.component.model.impl.ComponentRevisionImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import org.apache.commons.logging.LogFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ComponentInstallationImpl
implements ComponentInstallation,
Serializable {
    private static final long serialVersionUID = 3895539478658080757L;
    private String nodeId;
    private ComponentRevisionImpl componentRevision;
    private String installationId;
    private boolean isPublished = false;
    private Integer maximumCountOfParallelInstances = null;

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public LogicalNodeId fetchNodeIdAsObject() {
        return NodeIdentifierUtils.parseLogicalNodeIdStringWithExceptionWrapping((String)this.nodeId);
    }

    public void setNodeId(String idString) {
        this.nodeId = idString;
    }

    public void setNodeIdFromObject(LogicalNodeId nodeIdObject) {
        this.nodeId = nodeIdObject != null ? nodeIdObject.getLogicalNodeIdString() : null;
    }

    @Override
    public ComponentRevision getComponentRevision() {
        if (this.installationId == null) {
            LogFactory.getLog(this.getClass()).warn((Object)"Undefined component revision");
        }
        return this.componentRevision;
    }

    public void setComponentRevision(ComponentRevisionImpl componentRevision) {
        this.componentRevision = componentRevision;
    }

    @Override
    public String getInstallationId() {
        if (this.installationId == null) {
            LogFactory.getLog(this.getClass()).warn((Object)"Undefined installation id");
        }
        return this.installationId;
    }

    public void setInstallationId(String installationId) {
        this.installationId = installationId;
    }

    @Override
    public boolean getIsPublished() {
        return this.isPublished;
    }

    public void setIsPublished(boolean isPublished) {
        this.isPublished = isPublished;
    }

    @Override
    public Integer getMaximumCountOfParallelInstances() {
        return this.maximumCountOfParallelInstances;
    }

    public void setMaximumCountOfParallelInstances(Integer maximumCountOfParallelInstances) {
        this.maximumCountOfParallelInstances = maximumCountOfParallelInstances;
    }

    public String toString() {
        return StringUtils.format((String)"ComponentInstallation(node=%s,rev=%s)", (Object[])new Object[]{this.nodeId, this.componentRevision});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComponentInstallationImpl)) {
            return false;
        }
        ComponentInstallationImpl other = (ComponentInstallationImpl)obj;
        return this.nodeId.equals(other.nodeId) && this.getInstallationId().equals(other.getInstallationId());
    }

    public int hashCode() {
        return this.nodeId.hashCode() ^ this.installationId.hashCode();
    }

    @Override
    public int compareTo(ComponentInstallation o) {
        return this.getComponentRevision().getComponentInterface().getDisplayName().compareTo(o.getComponentRevision().getComponentInterface().getDisplayName());
    }
}

