/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.api;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.api.ComponentRevision;
import de.rcenvironment.core.component.model.api.ComponentSize;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinitionsProvider;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.datamodel.api.EndpointType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class ComponentDescription
implements Serializable,
Cloneable,
Comparable<ComponentDescription> {
    public static final String PROPERTIES_PREFIX = "properties.";
    public static final String DEFAULT_CONFIG_ID = "de.rcenvironment.rce.component.configuration.default";
    private static final long serialVersionUID = -7551319972711119245L;
    private ComponentInstallation componentInstallation;
    private ComponentRevision componentRevision;
    private ComponentInterface componentInterface;
    private final EndpointDescriptionsManager inputDescriptionsManager;
    private final EndpointDescriptionsManager outputDescriptionsManager;
    private ConfigurationDescription configurationDescription;
    private boolean isNodeIdTransient = false;

    public ComponentDescription(ComponentInstallation componentInstallation) {
        this.componentInstallation = componentInstallation;
        this.componentRevision = componentInstallation.getComponentRevision();
        this.componentInterface = this.componentRevision.getComponentInterface();
        this.inputDescriptionsManager = new EndpointDescriptionsManager(this.componentInterface.getInputDefinitionsProvider(), EndpointType.INPUT);
        this.outputDescriptionsManager = new EndpointDescriptionsManager(this.componentInterface.getOutputDefinitionsProvider(), EndpointType.OUTPUT);
        this.configurationDescription = new ConfigurationDescription(this.componentInterface.getConfigurationDefinition(), this.componentInterface.getConfigurationExtensionDefinitions());
    }

    public void initializeWithDefaults() {
        this.inputDescriptionsManager.addInitialDynamicEndpointDescriptions();
        this.outputDescriptionsManager.addInitialDynamicEndpointDescriptions();
        this.configurationDescription.setConfigurationValue("storeComponentHistoryData", String.valueOf(true));
    }

    public String getIdentifier() {
        return this.componentInterface.getIdentifier();
    }

    public String getClassName() {
        return this.componentRevision.getClassName();
    }

    public String getName() {
        return this.componentInterface.getDisplayName();
    }

    public String getGroup() {
        return this.componentInterface.getGroupName();
    }

    public String getVersion() {
        return this.componentInterface.getVersion();
    }

    public ComponentSize getSize() {
        return this.componentInterface.getSize();
    }

    public boolean getIsNodeIdTransient() {
        return this.isNodeIdTransient;
    }

    public void setIsNodeIdTransient(boolean isNodeTransient) {
        this.isNodeIdTransient = isNodeTransient;
    }

    public EndpointDescriptionsManager getInputDescriptionsManager() {
        return this.inputDescriptionsManager;
    }

    public EndpointDescriptionsManager getOutputDescriptionsManager() {
        return this.outputDescriptionsManager;
    }

    public EndpointDefinitionsProvider getDeclarativeInputDescriptionsProvider() {
        return this.componentInterface.getInputDefinitionsProvider();
    }

    public EndpointDefinitionsProvider getDeclarativeOutputDescriptionsProvider() {
        return this.componentInterface.getOutputDefinitionsProvider();
    }

    public ConfigurationDescription getConfigurationDescription() {
        return this.configurationDescription;
    }

    public boolean canOnlyBeExecutedLocally() {
        return this.componentInterface.getLocalExecutionOnly();
    }

    public boolean performLazyDisposal() {
        return this.componentInterface.getPerformLazyDisposal();
    }

    public byte[] getIcon16() {
        return this.componentInterface.getIcon16();
    }

    public byte[] getIcon24() {
        return this.componentInterface.getIcon24();
    }

    public byte[] getIcon32() {
        return this.componentInterface.getIcon32();
    }

    public LogicalNodeId getNode() {
        if (this.componentInstallation.getNodeId() != null) {
            return NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)this.componentInstallation.getNodeId());
        }
        return null;
    }

    public void setComponentInstallationAndUpdateConfiguration(ComponentInstallation installation) {
        this.setComponentInstallation(installation);
        Map<String, String> config = this.configurationDescription.getConfiguration();
        Map<String, String> placeholders = this.configurationDescription.getPlaceholders();
        this.configurationDescription = new ConfigurationDescription(installation.getComponentRevision().getComponentInterface().getConfigurationDefinition(), installation.getComponentRevision().getComponentInterface().getConfigurationExtensionDefinitions());
        this.configurationDescription.setConfiguration(config);
        this.configurationDescription.setPlaceholders(placeholders);
    }

    public ComponentInstallation getComponentInstallation() {
        return this.componentInstallation;
    }

    public void setComponentInstallation(ComponentInstallation installation) {
        String interfaceId = this.componentInterface.getIdentifier();
        String newInterfaceId = installation.getComponentRevision().getComponentInterface().getIdentifier();
        if (!newInterfaceId.equals(interfaceId) && !newInterfaceId.startsWith("20ca0171b5e24e10a284af7c1d6d94e9missing_") && newInterfaceId.endsWith(interfaceId) && !interfaceId.startsWith("20ca0171b5e24e10a284af7c1d6d94e9missing_") && interfaceId.endsWith(newInterfaceId)) {
            throw new IllegalArgumentException("Component installation doesn't refer to the interface: " + this.componentInterface.getIdentifier());
        }
        this.componentInstallation = installation;
        this.componentRevision = this.componentInstallation.getComponentRevision();
        this.componentInterface = this.componentRevision.getComponentInterface();
    }

    public String toString() {
        return this.getNode() + ":" + this.componentInterface.getIdentifier();
    }

    public ComponentDescription clone() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bin);
            ComponentDescription cd = (ComponentDescription)ois.readObject();
            ois.close();
            bin.close();
            oos.close();
            bos.close();
            return cd;
        }
        catch (IOException e) {
            LogFactory.getLog(ComponentDescription.class).error((Object)"cloning component description failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            LogFactory.getLog(ComponentDescription.class).error((Object)"cloning component description failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(ComponentDescription o) {
        return this.getName().compareTo(o.getName());
    }

    public ComponentInterface getComponentInterface() {
        return this.componentInterface;
    }
}

