/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.internal;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import java.util.TreeSet;

public class ComponentsCommandPlugin
implements CommandPlugin {
    private static final String CMD_COMPONENTS = "components";
    private DistributedComponentKnowledgeService componentKnowledgeService;

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription(CMD_COMPONENTS, "", false, "short form of \"components list\"", new String[0]));
        contributions.add(new CommandDescription("components list", "", false, "show components published by reachable RCE nodes", new String[0]));
        return contributions;
    }

    public void execute(CommandContext context) throws CommandException {
        context.consumeExpectedToken(CMD_COMPONENTS);
        String subCmd = context.consumeNextToken();
        if (subCmd != null && !subCmd.equals("list")) {
            throw CommandException.unknownCommand((CommandContext)context);
        }
        this.performComponentsList(context);
    }

    protected void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService newInstance) {
        this.componentKnowledgeService = newInstance;
    }

    private void performComponentsList(CommandContext context) {
        TreeMap components = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentComponentKnowledge();
        for (ComponentInstallation ci : compKnowledge.getAllInstallations()) {
            if (components.get(ci.getNodeId()) == null) {
                components.put(ci.getNodeId(), new TreeSet(String.CASE_INSENSITIVE_ORDER));
            }
            ComponentInterface compInterface = ci.getComponentRevision().getComponentInterface();
            String component = compInterface.getDisplayName();
            if (!"".equals(compInterface.getVersion())) {
                component = String.valueOf(component) + " (" + compInterface.getVersion() + ")";
            }
            ((TreeSet)components.get(ci.getNodeId())).add(component);
        }
        for (String nodeId : components.keySet()) {
            context.println((Object)StringUtils.format((String)"Components available on %s:", (Object[])new Object[]{NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)nodeId)}));
            for (String component : (TreeSet)components.get(nodeId)) {
                context.println((Object)("  " + component));
            }
        }
    }
}

