/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.sshremoteaccess;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import de.rcenvironment.core.communication.sshconnection.SshConnectionService;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionSetup;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.FinalWorkflowState;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.ssh.jsch.JschFileTransfer;
import de.rcenvironment.core.utils.ssh.jsch.executor.JSchRCECommandLineExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshRemoteAccessClientComponent
extends DefaultComponent {
    private static final String COLON = ":";
    private static final Log LOG = LogFactory.getLog(SshRemoteAccessClientComponent.class);
    private static final String QUOT = "\"";
    private SshConnectionService sshService;
    private SshConnectionSetup connection;
    private TempFileService tempFileService;
    private ComponentDataManagementService datamanagementService;
    private ComponentContext componentContext;
    private String toolName;
    private String toolVersion;
    private String hostId;
    private String connectionId;
    private ComponentLog componentLog;
    private boolean isWorkflow;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.componentLog = componentContext.getLog();
    }

    public void start() throws ComponentException {
        this.tempFileService = TempFileServiceAccess.getInstance();
        this.datamanagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        this.sshService = (SshConnectionService)this.componentContext.getService(SshConnectionService.class);
        this.toolName = this.componentContext.getConfigurationValue("toolName");
        this.hostId = this.componentContext.getConfigurationValue("hostId");
        this.toolVersion = this.componentContext.getConfigurationValue("version");
        this.connectionId = this.componentContext.getConfigurationValue("connection");
        this.isWorkflow = Boolean.parseBoolean(this.componentContext.getConfigurationValue("isWorkflow"));
        if (this.toolName == null || this.toolVersion == null || this.connectionId == null) {
            throw new ComponentException("Configuration for remote tool is not valid.");
        }
        this.connection = this.sshService.getConnectionSetup(this.connectionId);
        if (this.connection == null) {
            throw new ComponentException("The SSH connection for this tool does not exist.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processInputs() throws ComponentException {
        String state;
        String sessionToken;
        JSchRCECommandLineExecutor rceExecutor;
        Session session;
        File outputDir;
        File tempRootDir;
        block57: {
            Object errStream;
            File inputDir;
            String inputShortText;
            block55: {
                inputShortText = null;
                try {
                    tempRootDir = this.tempFileService.createManagedTempDir();
                    inputDir = new File(tempRootDir, "input");
                    if (this.componentContext != null && this.componentContext.getInputsWithDatum() != null) {
                        for (String inputName : this.componentContext.getInputsWithDatum()) {
                            if (inputName.equals("input_directory") && this.componentContext.getInputDataType(inputName).equals((Object)DataType.DirectoryReference)) {
                                this.datamanagementService.copyDirectoryReferenceTDToLocalDirectory(this.componentContext, (DirectoryReferenceTD)this.componentContext.readInput(inputName), inputDir);
                                inputDir = inputDir.listFiles()[0];
                                continue;
                            }
                            if (inputName.equals("input_text") && this.componentContext.getInputDataType(inputName).equals((Object)DataType.ShortText)) {
                                inputShortText = ((ShortTextTD)this.componentContext.readInput(inputName)).toString();
                                continue;
                            }
                            LOG.warn((Object)("Invalid input " + inputName));
                        }
                    }
                    if (inputShortText == null) {
                        throw new ComponentException("Short text input is missing");
                    }
                }
                catch (IOException e1) {
                    throw new ComponentException("Temp directory for output could not be created.", (Throwable)e1);
                }
                outputDir = new File(tempRootDir, "output");
                session = this.sshService.getAvtiveSshSession(this.connectionId);
                rceExecutor = new JSchRCECommandLineExecutor(session);
                try {
                    rceExecutor.start("ra init --compact");
                    Throwable throwable = null;
                    Object var9_12 = null;
                    try {
                        InputStream stdoutStream = rceExecutor.getStdout();
                        try {
                            try (InputStream stderrStream = rceExecutor.getStderr();){
                                rceExecutor.waitForTermination();
                                sessionToken = IOUtils.toString((InputStream)stdoutStream).trim();
                                LOG.info((Object)("Received session token " + sessionToken));
                                errStream = IOUtils.toString((InputStream)stderrStream);
                                if (!((String)errStream).isEmpty()) {
                                    LOG.error(errStream);
                                }
                            }
                            if (stdoutStream == null) break block55;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (stdoutStream == null) throw throwable;
                            stdoutStream.close();
                            throw throwable;
                        }
                        stdoutStream.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException | InterruptedException e1) {
                    throw new ComponentException("Executing SSH command failed", (Throwable)e1);
                }
            }
            try {
                JschFileTransfer.uploadDirectoryToRCEInstance((Session)session, (File)inputDir, (String)StringUtils.format((String)"/ra/%s/input", (Object[])new Object[]{sessionToken}));
            }
            catch (JSchException | IOException | InterruptedException e2) {
                throw new ComponentException("Uploading input directory via SCP failed", e2);
            }
            String formattedToolName = QUOT + this.toolName.replace(QUOT, "\"\"") + QUOT;
            String formattedVersion = QUOT + this.toolVersion.replace(QUOT, "\"\"") + QUOT;
            String command = this.isWorkflow ? StringUtils.format((String)"ra run-wf %s --show-output %s %s %s", (Object[])new Object[]{sessionToken, formattedToolName, formattedVersion, inputShortText, inputDir.getName(), outputDir.getName()}) : StringUtils.format((String)"ra run-tool %s --show-output -n %s %s %s %s", (Object[])new Object[]{sessionToken, this.hostId, formattedToolName, formattedVersion, inputShortText, inputDir.getName(), outputDir.getName()});
            state = "";
            try {
                rceExecutor.start(command);
                errStream = null;
                Object var13_23 = null;
                try {
                    InputStream stdoutStream = rceExecutor.getStdout();
                    try {
                        try (InputStream stderrStream = rceExecutor.getStderr();){
                            LineIterator it = IOUtils.lineIterator((InputStream)stdoutStream, null);
                            while (true) {
                                if (!it.hasNext()) {
                                    rceExecutor.waitForTermination();
                                    String errStream2 = IOUtils.toString((InputStream)stderrStream);
                                    if (!errStream2.isEmpty()) {
                                        LOG.error((Object)errStream2);
                                    }
                                    break;
                                }
                                String line = it.nextLine();
                                state = this.parseLogLine(sessionToken, state, line);
                            }
                        }
                        if (stdoutStream == null) break block57;
                    }
                    catch (Throwable throwable) {
                        if (errStream == null) {
                            errStream = throwable;
                        } else if (errStream != throwable) {
                            ((Throwable)errStream).addSuppressed(throwable);
                        }
                        if (stdoutStream == null) throw errStream;
                        stdoutStream.close();
                        throw errStream;
                    }
                    stdoutStream.close();
                }
                catch (Throwable throwable) {
                    if (errStream == null) {
                        errStream = throwable;
                        throw errStream;
                    }
                    if (errStream == throwable) throw errStream;
                    ((Throwable)errStream).addSuppressed(throwable);
                    throw errStream;
                }
            }
            catch (IOException | InterruptedException e1) {
                throw new ComponentException("Executing SSH command failed", (Throwable)e1);
            }
        }
        if (!state.equals(FinalWorkflowState.FINISHED.toString())) {
            throw new ComponentException("Remote component or workflow ended in state: " + state);
        }
        try {
            JschFileTransfer.downloadDirectory((Session)session, (String)StringUtils.format((String)"/ra/%s/output", (Object[])new Object[]{sessionToken}), (File)outputDir.getParentFile());
        }
        catch (JSchException | IOException e1) {
            throw new ComponentException("Downloading outputput directory via SCP failed", e1);
        }
        try {
            rceExecutor.start(StringUtils.format((String)"ra dispose %s", (Object[])new Object[]{sessionToken}));
        }
        catch (IOException e1) {
            throw new ComponentException("Disposing SCP context failed.", (Throwable)e1);
        }
        try {
            try {
                DirectoryReferenceTD output = this.datamanagementService.createDirectoryReferenceTDFromLocalDirectory(this.componentContext, outputDir, outputDir.getName());
                this.componentContext.writeOutput("output", (TypedDatum)output);
            }
            catch (IOException e) {
                throw new ComponentException("Output directory reference could not be created. ", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            try {
                this.tempFileService.disposeManagedTempDirOrFile(tempRootDir);
                throw throwable;
            }
            catch (IOException iOException) {
                LOG.warn((Object)("Could not dispose managed temp dir " + tempRootDir));
            }
            throw throwable;
        }
        try {
            this.tempFileService.disposeManagedTempDirOrFile(tempRootDir);
            return;
        }
        catch (IOException iOException) {
            LOG.warn((Object)("Could not dispose managed temp dir " + tempRootDir));
        }
    }

    private String parseLogLine(String sessionToken, String state, String line) {
        if (line.startsWith(StringUtils.format((String)"[%s] StdOut: ", (Object[])new Object[]{sessionToken}))) {
            this.componentLog.toolStdout(line.substring(line.indexOf(COLON) + 2));
        } else if (line.startsWith(StringUtils.format((String)"[%s] State: ", (Object[])new Object[]{sessionToken}))) {
            state = line.substring(line.indexOf(COLON) + 2);
            if (this.isWorkflow) {
                this.componentLog.toolStdout("Workflow state changed, new state: " + WorkflowState.valueOf((String)state).getDisplayName());
            } else {
                this.componentLog.toolStdout("Tool state changed, new state: " + WorkflowState.valueOf((String)state).getDisplayName());
            }
        } else if (line.startsWith(StringUtils.format((String)"[%s] StdErr: ", (Object[])new Object[]{sessionToken}))) {
            this.componentLog.toolStderr(line.substring(line.indexOf(COLON) + 2));
        } else {
            LOG.error((Object)line);
        }
        return state;
    }
}

