/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.rpc.ServiceCallRequest;
import de.rcenvironment.core.communication.rpc.api.RemotableCallbackService;
import de.rcenvironment.core.communication.rpc.api.RemoteServiceCallSenderService;
import de.rcenvironment.core.communication.spi.CallbackMethod;
import de.rcenvironment.core.communication.spi.CallbackObject;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallbackInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 3758584730981030172L;
    private static final transient Log LOGGER = LogFactory.getLog(CallbackInvocationHandler.class);
    private final CallbackObject callbackObject;
    private final String objectId;
    private final InstanceNodeSessionId objectNodeId;
    private final InstanceNodeSessionId proxyNodeId;
    private final Class<?> callbackInterface;

    public CallbackInvocationHandler(CallbackObject callbackObject, String objectIdentifier, InstanceNodeSessionId objectHome, InstanceNodeSessionId proxyHome) {
        this.callbackObject = callbackObject;
        this.callbackInterface = callbackObject.getInterface();
        this.objectId = objectIdentifier;
        this.objectNodeId = objectHome;
        this.proxyNodeId = proxyHome;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
        String methodName = method.getName();
        Object returnValue = methodName.equals("getHomePlatform") ? this.objectNodeId : (methodName.equals("getObjectIdentifier") ? this.objectId : (this.matchesCallbackMethod(method) ? this.invokeRemoteMethod(methodName, parameters) : method.invoke((Object)this.callbackObject, parameters)));
        return returnValue;
    }

    private Object invokeRemoteMethod(String methodName, Object[] parameters) throws Throwable {
        ArrayList<Object> parameterList = new ArrayList<Object>();
        parameterList.add(0, this.objectId);
        parameterList.add(1, methodName);
        if (parameters != null) {
            List<Object> parametersAsList = Arrays.asList(parameters);
            parameterList.add(2, new ArrayList<Object>(parametersAsList));
        } else {
            parameterList.add(2, new ArrayList());
        }
        ServiceCallRequest serviceCallRequest = new ServiceCallRequest(this.objectNodeId.convertToDefaultLogicalNodeSessionId(), this.proxyNodeId.convertToDefaultLogicalNodeSessionId(), RemotableCallbackService.class.getCanonicalName(), "callback", parameterList);
        RemoteServiceCallSenderService remoteServiceCallService = RemoteServiceCallServiceHolder.getRemoteServiceCallService();
        return remoteServiceCallService.performRemoteServiceCallAsProxy(serviceCallRequest);
    }

    private boolean matchesCallbackMethod(Method method) {
        boolean isCommonMethod;
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        int parameterCount = parameterTypes.length;
        boolean bl = isCommonMethod = "hashCode".equals(methodName) && parameterCount == 0 || "toString".equals(methodName) && parameterCount == 0 || "equals".equals(methodName) && parameterCount == 1;
        if (isCommonMethod) {
            return false;
        }
        try {
            Method interfaceMethod = this.callbackInterface.getMethod(methodName, parameterTypes);
            return interfaceMethod.isAnnotationPresent(CallbackMethod.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Non-interface method called on callback object of interface " + this.callbackInterface.getName() + ": " + method));
            }
            return false;
        }
    }

    public static class RemoteServiceCallServiceHolder {
        private static RemoteServiceCallSenderService remoteServiceCallService;

        public static void bindRemoteServiceCallService(RemoteServiceCallSenderService newInstance) {
            remoteServiceCallService = newInstance;
        }

        private static RemoteServiceCallSenderService getRemoteServiceCallService() {
            return remoteServiceCallService;
        }
    }
}

