/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.routing.internal;

public final class NetworkStats {
    private int failedCommunications = 0;
    private int successfulCommunications = 0;
    private int sentLSAs = 0;
    private int receivedLSAs = 0;
    private int rejectedLSAs = 0;
    private int hopCountOfSentLSAs = 0;
    private int hopCountOfReceivedLSAs = 0;
    private int hopCountOfRejectedLSAs = 0;
    private int maxReceivedHopCount = 0;
    private int maxTimeToLive = 0;
    private int shortesPathComputations = 0;

    public synchronized int averageHopCountOfSentLSAs() {
        if (this.sentLSAs > 0) {
            return this.hopCountOfSentLSAs / this.sentLSAs;
        }
        return 0;
    }

    public synchronized int averageHopCountOfReceivedLSAs() {
        if (this.receivedLSAs > 0) {
            return this.hopCountOfReceivedLSAs / this.receivedLSAs;
        }
        return 0;
    }

    public synchronized int averageHopCountOfRejectedLSAs() {
        if (this.rejectedLSAs > 0) {
            return this.hopCountOfRejectedLSAs / this.rejectedLSAs;
        }
        return 0;
    }

    public synchronized int getFailedCommunications() {
        return this.failedCommunications;
    }

    public synchronized int incFailedCommunications() {
        return ++this.failedCommunications;
    }

    public synchronized int getSuccessfulCommunications() {
        return this.successfulCommunications;
    }

    public synchronized int incSuccessfulCommunications() {
        return ++this.successfulCommunications;
    }

    public synchronized int getReceivedLSAs() {
        return this.receivedLSAs;
    }

    public synchronized int incReceivedLSAs() {
        ++this.receivedLSAs;
        return this.receivedLSAs;
    }

    public synchronized int getSentLSAs() {
        return this.sentLSAs;
    }

    public synchronized int incSentLSAs() {
        ++this.sentLSAs;
        return this.sentLSAs;
    }

    public synchronized int getRejectedLSAs() {
        return this.rejectedLSAs;
    }

    public synchronized int incRejectedLSAs() {
        ++this.rejectedLSAs;
        return this.rejectedLSAs;
    }

    public synchronized int getShortestPathComputations() {
        return this.shortesPathComputations;
    }

    public synchronized int incShortestPathComputations() {
        ++this.shortesPathComputations;
        return this.shortesPathComputations;
    }

    public synchronized int getHopCountOfReceivedLSAs() {
        return this.hopCountOfReceivedLSAs;
    }

    public synchronized int incHopCountOfReceivedLSAs(int increment) {
        this.hopCountOfReceivedLSAs += increment;
        this.setMaxReceivedHopCount(increment);
        return this.hopCountOfReceivedLSAs;
    }

    public synchronized int getHopCountOfSentLSAs() {
        return this.hopCountOfSentLSAs;
    }

    public synchronized int incHopCountOfSentLSAs(int increment) {
        this.hopCountOfSentLSAs += increment;
        return this.hopCountOfSentLSAs;
    }

    public synchronized int getHopCountOfRejectedLSAs() {
        return this.hopCountOfRejectedLSAs;
    }

    public synchronized int incHopCountOfRejectedLSAs(int increment) {
        this.hopCountOfRejectedLSAs += increment;
        return this.hopCountOfRejectedLSAs;
    }

    private int setMaxReceivedHopCount(int value) {
        if (value > this.maxReceivedHopCount) {
            this.maxReceivedHopCount = value;
        }
        return this.maxReceivedHopCount;
    }

    public synchronized int getMaxReceivedHopCount() {
        return this.maxReceivedHopCount;
    }

    public synchronized int setMaxTimeToLive(int value) {
        if (value > this.maxTimeToLive) {
            this.maxTimeToLive = value;
        }
        return this.maxTimeToLive;
    }

    public synchronized int getMaxTimeToLive() {
        return this.maxTimeToLive;
    }
}

