/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.fileaccess.internal;

import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.fileaccess.api.RemoteFileConnection;
import de.rcenvironment.core.communication.fileaccess.spi.RemoteFileConnectionFactory;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class RemoteFileConnectionSupport {
    private static final String ERROR_SERVICE_NOT_REGISTERED = "A remote input stream factory service is not registered.";
    private static final Log LOGGER = LogFactory.getLog(RemoteFileConnectionSupport.class);
    private static BundleContext bundleContext;

    @Deprecated
    public RemoteFileConnectionSupport() {
    }

    public void activate(BundleContext context) {
        bundleContext = context;
    }

    public static RemoteFileConnection getRemoteFileConnection(URI uri) throws CommunicationException, IOException {
        RemoteFileConnectionFactory remoteFileConnectionFactory;
        ServiceReference[] factoryReferences = null;
        try {
            factoryReferences = bundleContext.getAllServiceReferences(RemoteFileConnectionFactory.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            LOGGER.error((Object)"Failed to get a remote input stream factory service: Invalid protocol filter syntax.");
        }
        if (factoryReferences != null && factoryReferences.length > 0) {
            remoteFileConnectionFactory = (RemoteFileConnectionFactory)bundleContext.getService(factoryReferences[0]);
            if (remoteFileConnectionFactory == null) {
                throw new CommunicationException(ERROR_SERVICE_NOT_REGISTERED);
            }
        } else {
            throw new CommunicationException(ERROR_SERVICE_NOT_REGISTERED);
        }
        return remoteFileConnectionFactory.createRemoteFileConnection(uri);
    }
}

