/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.common.registry.internal;

import de.rcenvironment.components.script.common.registry.ScriptExecutor;
import de.rcenvironment.components.script.common.registry.ScriptExecutorFactory;
import de.rcenvironment.components.script.common.registry.ScriptExecutorFactoryRegistry;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptExecutorFactoryRegistryImpl
implements ScriptExecutorFactoryRegistry {
    private static final Log LOGGER = LogFactory.getLog(ScriptExecutorFactoryRegistryImpl.class);
    private final List<ScriptExecutorFactory> executorFactories = Collections.synchronizedList(new LinkedList());

    @Override
    public synchronized void addScriptExecutorFactory(ScriptExecutorFactory factory) {
        if (factory != null && !this.executorFactories.contains(factory)) {
            this.executorFactories.add(factory);
        } else {
            LOGGER.warn((Object)"Could not register ScriptExecutorFactory.");
        }
    }

    @Override
    public synchronized void removeScriptExecutorFactory(ScriptExecutorFactory factory) {
        if (factory != null && this.executorFactories.contains(factory)) {
            this.executorFactories.remove(factory);
        } else {
            LOGGER.warn((Object)"Could not register ScriptExecutorFactor.");
        }
    }

    @Override
    public synchronized List<ScriptLanguage> getCurrentRegisteredExecutorLanguages() {
        LinkedList<ScriptLanguage> result = new LinkedList<ScriptLanguage>();
        for (ScriptExecutorFactory factory : this.executorFactories) {
            result.add(factory.getSupportingScriptLanguage());
        }
        return result;
    }

    @Override
    public synchronized ScriptExecutor requestScriptExecutor(ScriptLanguage language) {
        ScriptExecutor result = null;
        for (ScriptExecutorFactory currentFactory : this.executorFactories) {
            if (!currentFactory.getSupportingScriptLanguage().getName().equalsIgnoreCase(language.getName())) continue;
            result = currentFactory.createScriptExecutor();
        }
        return result;
    }
}

