/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.parametricstudy.gui.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class PipedPropertyChangeListener
implements PropertyChangeListener {
    private final Object target;
    private final Map<String, String> getterNameMappings = new HashMap<String, String>();
    private final Map<String, String> setterNameMappings = new HashMap<String, String>();
    private final Map<String, Converter> converterMappings = new HashMap<String, Converter>();

    public PipedPropertyChangeListener(Object target) {
        this.target = target;
    }

    public void addNameMapping(String from, String to) {
        this.addGetterNameMapping(from, to);
        this.addSetterNameMapping(from, to);
    }

    public void addGetterNameMapping(String from, String to) {
        this.getterNameMappings.put(from, to);
    }

    public void addSetterNameMapping(String from, String to) {
        this.setterNameMappings.put(from, to);
    }

    public void addConverterMapping(String propertyName, Converter converter) {
        this.converterMappings.put(propertyName, converter);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Method setter;
        Object currentValue;
        String propertyName = event.getPropertyName();
        Object value = event.getNewValue();
        if (this.converterMappings.containsKey(propertyName)) {
            value = this.converterMappings.get(propertyName).convert(value);
        }
        try {
            currentValue = this.getValue(propertyName);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            return;
        }
        if (currentValue == value) {
            return;
        }
        Class parameterType = Object.class;
        if (value != null) {
            parameterType = value.getClass();
        }
        if ((setter = this.getSetter(propertyName, parameterType)) == null) {
            return;
        }
        try {
            setter.invoke(this.target, value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object getValue(String propertyName) throws NoSuchFieldError {
        String realPropertyName = propertyName;
        if (this.getterNameMappings.containsKey(propertyName)) {
            realPropertyName = this.getterNameMappings.get(propertyName);
        }
        try {
            Method getter = this.getGetter(realPropertyName);
            if (getter == null) {
                return new NoSuchFieldError();
            }
            return getter.invoke(this.target, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Method getGetter(String propertyName) {
        if (!propertyName.matches("[_a-zA-Z][_a-zA-Z0-9]*")) {
            return null;
        }
        String[] prefixes = new String[]{"get", "is"};
        String suffix = String.valueOf(propertyName.substring(0, 1).toUpperCase()) + propertyName.substring(1);
        Method getter = null;
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            String getterName = String.valueOf(prefix) + suffix;
            try {
                try {
                    getter = this.target.getClass().getMethod(getterName, new Class[0]);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        return getter;
    }

    private Method getSetter(String propertyName, Class<?> parameterType) {
        String realPropertyName = propertyName;
        if (this.setterNameMappings.containsKey(propertyName)) {
            realPropertyName = this.setterNameMappings.get(propertyName);
        }
        if (!realPropertyName.matches("[_a-zA-Z][_a-zA-Z0-9]*")) {
            return null;
        }
        String setterName = "set" + realPropertyName.substring(0, 1).toUpperCase() + realPropertyName.substring(1);
        Method setter = null;
        try {
            Method[] methodArray = this.target.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (setterName.equals(method.getName()) && method.getParameterTypes().length == 1) {
                    Class<?> methodParameterType = method.getParameterTypes()[0];
                    if (methodParameterType.isAssignableFrom(parameterType)) {
                        setter = method;
                        break;
                    }
                    if (methodParameterType.isPrimitive()) {
                        setter = method;
                    }
                }
                ++n2;
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        return setter;
    }

    public static abstract class AbstractConverter
    implements Converter {
        @Override
        public Object convert(Object object) {
            return object;
        }

        @Override
        public Object invert(Object object) {
            return object;
        }
    }

    public static interface Converter {
        public Object convert(Object var1);

        public Object invert(Object var1);
    }
}

