/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.inputprovider.gui;

import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;

public final class InputProviderDynamicEndpointCommandUtils {
    private InputProviderDynamicEndpointCommandUtils() {
    }

    public static void setValueName(WorkflowNode workflowNode, DataType type, String name) {
        String placeholder = "${" + name + "}";
        InputProviderDynamicEndpointCommandUtils.setOutputValues(workflowNode, name, placeholder);
        InputProviderDynamicEndpointCommandUtils.setOutputValues(workflowNode, String.valueOf(name) + "_datatype_799ef365", InputProviderDynamicEndpointCommandUtils.getPlaceholderDataType(type));
    }

    private static void setOutputValues(WorkflowNode workflowNode, String name, String value) {
        workflowNode.getConfigurationDescription().setConfigurationValue(name, value);
    }

    private static String getPlaceholderDataType(DataType endpointDatatype) {
        String placeholderDatatype = "text";
        switch (endpointDatatype) {
            case FileReference: {
                placeholderDatatype = "file";
                break;
            }
            case DirectoryReference: {
                placeholderDatatype = "dir";
                break;
            }
            case Boolean: {
                placeholderDatatype = "bool";
                break;
            }
            case Integer: {
                placeholderDatatype = "int";
                break;
            }
            case Float: {
                placeholderDatatype = "float";
                break;
            }
        }
        return placeholderDatatype;
    }
}

