/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.database.gui;

import de.rcenvironment.components.database.common.DatabaseConnection;
import de.rcenvironment.components.database.gui.DatabaseConnectionDeleteCommand;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class DatabaseManagementDialog
extends Dialog {
    protected Composite composite;
    protected Composite client;
    protected ComponentInstanceProperties configuration;
    protected Table table;
    protected Button buttonAdd;
    protected Button buttonEdit;
    protected Button buttonRemove;
    protected MenuItem itemAdd;
    protected MenuItem itemEdit;
    protected MenuItem itemRemove;
    protected TableColumnLayout tableLayout;

    protected DatabaseManagementDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(34928);
    }

    protected void configureShell(Shell shell) {
        shell.setText("Manage Databases");
        super.configureShell(shell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Close", true);
    }

    protected Control createDialogArea(Composite parent) {
        this.client = new Composite(parent, 0);
        this.client.setLayout((Layout)new GridLayout(2, false));
        Composite tableComposite = new Composite(this.client, 0);
        this.tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)this.tableLayout);
        this.table = new Table(tableComposite, 68356);
        this.table.setHeaderVisible(true);
        GridData tableLayoutData = new GridData(4, 4, true, true, 1, 5);
        tableLayoutData.heightHint = 300;
        tableLayoutData.minimumWidth = 500;
        tableComposite.setLayoutData((Object)tableLayoutData);
        TableColumn colDbName = new TableColumn(this.table, 0);
        colDbName.setText("Name");
        TableColumn colType = new TableColumn(this.table, 0);
        colType.setText("Type");
        TableColumn colHost = new TableColumn(this.table, 0);
        colHost.setText("Host");
        TableColumn colPort = new TableColumn(this.table, 0);
        colPort.setText("Port");
        TableColumn colUsername = new TableColumn(this.table, 0);
        colUsername.setText("Username");
        TableColumn colPassword = new TableColumn(this.table, 0);
        colPassword.setText("Password");
        TableColumn colDefaultScheme = new TableColumn(this.table, 0);
        colDefaultScheme.setText("Scheme");
        TableColumn colStatus = new TableColumn(this.table, 0);
        colStatus.setText("Status");
        this.tableLayout.setColumnData((Widget)colDbName, (ColumnLayoutData)new ColumnWeightData(20, true));
        this.tableLayout.setColumnData((Widget)colType, (ColumnLayoutData)new ColumnWeightData(20, true));
        this.tableLayout.setColumnData((Widget)colHost, (ColumnLayoutData)new ColumnWeightData(20, true));
        this.tableLayout.setColumnData((Widget)colPort, (ColumnLayoutData)new ColumnWeightData(20, true));
        this.tableLayout.setColumnData((Widget)colUsername, (ColumnLayoutData)new ColumnWeightData(20, true));
        this.tableLayout.setColumnData((Widget)colPassword, (ColumnLayoutData)new ColumnWeightData(20, true));
        this.tableLayout.setColumnData((Widget)colDefaultScheme, (ColumnLayoutData)new ColumnWeightData(20, true));
        this.tableLayout.setColumnData((Widget)colStatus, (ColumnLayoutData)new ColumnWeightData(20, true));
        TableItem dummyItem = new TableItem(this.table, 0);
        String[] tableData = new String[8];
        dummyItem.setText(tableData);
        this.buttonAdd = new Button(this.client, 0x800000);
        this.buttonAdd.setLayoutData((Object)new GridData(4, 128, false, false));
        this.buttonAdd.setText(EndpointActionType.ADD.toString());
        this.buttonAdd.addSelectionListener((SelectionListener)new AddDatabaseButtonListener());
        this.buttonEdit = new Button(this.client, 0x800000);
        this.buttonEdit.setLayoutData((Object)new GridData(4, 128, false, false));
        this.buttonEdit.setText(EndpointActionType.EDIT.toString());
        this.buttonEdit.addSelectionListener((SelectionListener)new EditDatabaseButtonListener());
        this.buttonRemove = new Button(this.client, 0x800000);
        this.buttonRemove.setLayoutData((Object)new GridData(4, 128, false, false));
        this.buttonRemove.setText(EndpointActionType.REMOVE.toString());
        this.buttonRemove.addSelectionListener((SelectionListener)new RemoveDatabaseButtonListener());
        this.loadDatabaseConnections();
        return super.createDialogArea(parent);
    }

    private void loadDatabaseConnections() {
        for (DatabaseConnection dbCon : this.readDatabaseConnectionsFromConfig()) {
            this.parseDbConnectionAndAddToTable(dbCon);
        }
    }

    private TableItem parseDbConnectionAndAddToTable(DatabaseConnection dbCon) {
        TableItem item = new TableItem(this.table, 0);
        item.setText(0, dbCon.getName());
        item.setText(1, dbCon.getType());
        item.setText(2, dbCon.getHost());
        item.setText(3, dbCon.getPort());
        item.setText(4, dbCon.getUsername());
        item.setText(5, dbCon.getPassword());
        item.setText(6, dbCon.getScheme());
        item.setText(7, dbCon.getState());
        return item;
    }

    private List<DatabaseConnection> readDatabaseConnectionsFromConfig() {
        ArrayList<DatabaseConnection> connections = new ArrayList<DatabaseConnection>();
        return connections;
    }

    private final class AddDatabaseButtonListener
    implements SelectionListener {
        private AddDatabaseButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }

    private final class EditDatabaseButtonListener
    implements SelectionListener {
        private EditDatabaseButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            TableItem cfr_ignored_0 = DatabaseManagementDialog.this.table.getSelection()[0];
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }

    private final class RemoveDatabaseButtonListener
    implements SelectionListener {
        private RemoveDatabaseButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            int selectedItemIndex = DatabaseManagementDialog.this.table.getSelectionIndex();
            DatabaseConnectionDeleteCommand deleteCommand = new DatabaseConnectionDeleteCommand(DatabaseManagementDialog.this.table, selectedItemIndex);
            deleteCommand.execute();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }
}

