/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cpacs.writer.gui.runtime;

import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.datamanagement.DataManagementService;
import de.rcenvironment.core.gui.workflow.view.ComponentRuntimeView;
import de.rcenvironment.core.notification.Notification;
import de.rcenvironment.core.notification.SimpleNotificationService;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractCpacsRuntimeView
extends ViewPart
implements ComponentRuntimeView {
    protected static final TempFileService TEMP_MANAGER = TempFileServiceAccess.getInstance();
    private static final int MINIMUM_HEIGHT_OF_FILE_CONTENT_TEXT = 300;
    private static File managedTempDir = null;
    protected ComponentExecutionInformation componentInstanceDescriptor = null;
    protected SimpleNotificationService notificationService = new SimpleNotificationService();
    protected DataManagementService dataManagementService;
    protected ScrolledForm form = null;
    private Text fileContentText;
    private Log log;
    private File cpacsFile = null;
    private Button mappedB;

    @Deprecated
    public AbstractCpacsRuntimeView() {
    }

    public void initializeData(ComponentExecutionInformation componentExecutionInformation) {
        this.componentInstanceDescriptor = componentExecutionInformation;
        if (managedTempDir == null) {
            try {
                managedTempDir = TEMP_MANAGER.createManagedTempDir();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        this.dataManagementService = (DataManagementService)serviceRegistryAccess.getService(DataManagementService.class);
        String tempFileReference = this.getFileReference();
        if (tempFileReference != null) {
            try {
                this.cpacsFile = new File(managedTempDir, String.valueOf(tempFileReference) + ".xml");
                if (!this.cpacsFile.exists()) {
                    this.dataManagementService.copyReferenceToLocalFile(tempFileReference, this.cpacsFile, (ResolvableNodeId)this.componentInstanceDescriptor.getDefaultStorageNodeId());
                }
            }
            catch (CommunicationException | IOException e) {
                this.log.error((Object)"Fetching CPACS file failed", e);
            }
        }
    }

    public void initializeView() {
        if (this.mappedB != null) {
            this.mappedB.setEnabled(this.cpacsFile != null);
        }
        if (this.cpacsFile != null && this.cpacsFile.exists()) {
            try {
                this.fileContentText.setText(FileUtils.readFileToString((File)this.cpacsFile, (Charset)Charset.defaultCharset()));
            }
            catch (IOException e) {
                this.log.error((Object)e);
            }
        } else {
            this.fileContentText.setText("");
        }
    }

    protected void createPartControl(Composite parent, Log logger) {
        FormToolkit tk = new FormToolkit(parent.getDisplay());
        this.log = logger;
        this.form = tk.createScrolledForm(parent);
        this.form.getBody().setLayout((Layout)new GridLayout());
        if ("win32".equals(Platform.getOS())) {
            Composite main = tk.createComposite(this.form.getBody());
            main.setLayout((Layout)new FillLayout(256));
            this.mappedB = tk.createButton(main, "Show in TiGL Viewer", 8);
            this.mappedB.setEnabled(false);
            this.mappedB.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (AbstractCpacsRuntimeView.this.cpacsFile != null) {
                        AbstractCpacsRuntimeView.this.performShowAction(AbstractCpacsRuntimeView.this.cpacsFile);
                    }
                }
            });
        }
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        this.fileContentText = tk.createText(this.form.getBody(), "", 768);
        this.fileContentText.setEditable(false);
        this.fileContentText.setLayoutData((Object)gridData);
    }

    protected abstract void performShowAction(File var1);

    private String getFileReference() {
        block4: {
            List notifications;
            block5: {
                Map all = this.notificationService.getNotifications(String.valueOf(this.componentInstanceDescriptor.getExecutionIdentifier()) + ":rce.component.cpacswriter", (ResolvableNodeId)this.componentInstanceDescriptor.getNodeId());
                if (all.size() < 1) break block4;
                notifications = (List)all.values().iterator().next();
                if (notifications.size() >= 1) break block5;
                return null;
            }
            try {
                Serializable object = ((Notification)notifications.get(0)).getBody();
                if (object instanceof String) {
                    return (String)((Object)object);
                }
            }
            catch (RemoteOperationException remoteOperationException) {
                this.log.error((Object)"Getting CPACS file reference failed.");
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.cpacsFile != null) {
            try {
                TEMP_MANAGER.disposeManagedTempDirOrFile(this.cpacsFile);
            }
            catch (IOException e) {
                this.log.error((Object)"Deleting CPACS file in temp directory failed", (Throwable)e);
            }
        }
    }
}

