/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cpacs.vampzeroinitializer.gui;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class WidgetHelper {
    private FormToolkit tk;
    private Color backgroundColor;

    public WidgetHelper(FormToolkit formToolkit, Color bgColor) {
        this.tk = formToolkit;
        this.backgroundColor = bgColor;
    }

    public Label newLabel(Composite parent, String labelString, int ... columns) {
        TableWrapData td = new TableWrapData();
        td.align = 8;
        if (columns != null && columns.length > 0) {
            td.colspan = columns[0];
        }
        Label label = this.tk.createLabel(parent, labelString);
        label.setFont(JFaceResources.getBannerFont());
        label.setLayoutData((Object)td);
        return label;
    }

    public Button newButton(Composite parent, String label, Listener listener, int ... alignment) {
        TableWrapData td = new TableWrapData();
        if (alignment != null && alignment.length > 0) {
            td.align = alignment[0];
        }
        Button button = this.tk.createButton(parent, label, 0x800008);
        button.setLayoutData((Object)td);
        button.addListener(13, listener);
        return button;
    }

    public Text newText(Composite parent, String initialContent, int ... colSpan) {
        Text text = initialContent.contains("\n") ? this.tk.createText(parent, initialContent, 2114) : this.tk.createText(parent, initialContent, 2048);
        text.setBackground(this.backgroundColor);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.colspan = colSpan == null || colSpan.length == 0 ? 1 : colSpan[0];
        text.setSelection(0, text.getText().length());
        text.setLayoutData((Object)td);
        return text;
    }

    public List newList(Composite parent, Listener selectionListener, int ... style) {
        List list = style == null || style.length < 1 ? new List(parent, 2052) : new List(parent, style[0] ^ 0x804);
        list.setBackground(this.backgroundColor);
        if (selectionListener != null) {
            list.addListener(13, selectionListener);
        }
        TableWrapData td = new TableWrapData();
        td.align = 128;
        list.setLayoutData((Object)td);
        return list;
    }

    public Button newRadioButton(Composite parent, String label, int ... style) {
        Button radioButton = style == null || style.length < 1 ? this.tk.createButton(parent, label, 16) : this.tk.createButton(parent, label, 0x10 ^ style[0]);
        radioButton.setLayoutData((Object)new TableWrapData());
        return radioButton;
    }

    public Button newCheckbox(Composite parent, String label, int ... columns) {
        Button checkbox = this.tk.createButton(parent, label, 32);
        TableWrapData td = new TableWrapData();
        if (columns != null && columns.length > 0) {
            td.colspan = columns[0];
        }
        checkbox.setLayoutData((Object)td);
        return checkbox;
    }

    public Scale newScale(Composite parent, int maxValue, Listener listener, int ... style) {
        Scale scale = style != null && style.length > 0 ? new Scale(parent, 0x100 ^ style[0]) : new Scale(parent, 256);
        scale.setMinimum(0);
        scale.setMaximum(2 * maxValue);
        scale.setIncrement(1);
        scale.setPageIncrement(3);
        scale.setSelection(maxValue);
        scale.setLayoutData((Object)new TableWrapData());
        if (listener != null) {
            scale.addListener(13, listener);
        }
        return scale;
    }

    public Label newSeparator(Composite parent, boolean vertical, int ... columns) {
        Label label = vertical ? new Label(parent, 514) : new Label(parent, 258);
        TableWrapData td = new TableWrapData();
        if (columns != null && columns.length > 0) {
            td.colspan = columns[0];
        }
        td.align = 128;
        label.setLayoutData((Object)td);
        return label;
    }

    public Composite newButtonGroup(Composite parent, Layout layout, int ... columns) {
        Composite group = this.tk.createComposite(parent);
        TableWrapData td = new TableWrapData();
        if (columns != null && columns.length > 0) {
            td.colspan = columns[0];
        }
        group.setLayoutData((Object)td);
        group.setLayout(layout);
        return group;
    }

    public Combo newReadonlyCombo(Composite parent, String[] values, Listener listener) {
        Combo combo = new Combo(parent, 12);
        if (values != null) {
            combo.setItems(values);
        }
        TableWrapData td = new TableWrapData();
        td.align = 128;
        combo.setLayoutData((Object)td);
        if (listener != null) {
            combo.addListener(13, listener);
        }
        return combo;
    }

    public Group newGroup(Composite parent, String title, int style, int internalColumns, int ... columns) {
        Group group = new Group(parent, 0);
        TableWrapData td = new TableWrapData();
        if (columns != null && columns.length > 0) {
            td.colspan = columns[0];
        }
        td.align = 128;
        td.grabHorizontal = true;
        if (title != null && !title.equals("")) {
            group.setText(title);
        }
        group.setLayoutData((Object)td);
        Layout designGroupLayout = this.newDefaultLayout(internalColumns);
        group.setLayout(designGroupLayout);
        this.tk.adapt((Composite)group);
        return group;
    }

    public Composite newComposite(Composite parent) {
        Composite composite = this.tk.createComposite(parent);
        return composite;
    }

    public Composite newComposite(Composite parent, int internalColumns, int ... columns) {
        Composite composite = this.newComposite(parent);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        if (columns != null && columns.length > 0) {
            td.colspan = columns[0];
        }
        composite.setLayoutData((Object)td);
        Layout layout = this.newDefaultLayout(internalColumns);
        composite.setLayout(layout);
        return composite;
    }

    public Layout newDefaultLayout(int internalColumns) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = internalColumns;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        return layout;
    }
}

