/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cpacs.vampzeroinitializer.execution;

import com.fasterxml.jackson.core.JsonParseException;
import de.rcenvironment.components.cpacs.vampzeroinitializer.common.VampZeroInitializerComponentConstants;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.api.PersistentComponentDescriptionUpdaterUtils;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import java.io.IOException;

public class VampZeroInitializerPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String V3_0 = "3.0";
    private static final String V3_1 = "3.1";
    private final String currentVersion = "3.1";

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return VampZeroInitializerComponentConstants.COMPONENT_IDS;
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int versionsToUpdate = 0;
        if (!silent) {
            if (persistentComponentDescriptionVersion == null || persistentComponentDescriptionVersion.compareTo(V3_0) < 0) {
                versionsToUpdate |= 2;
            }
            if (persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V3_1) < 0) {
                versionsToUpdate |= 4;
            }
        }
        return versionsToUpdate;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        if (!silent) {
            if (formatVersion == 2) {
                description = this.updateToV30(description);
            } else if (formatVersion == 4) {
                description = this.updateFromV30ToV31(description);
            }
        }
        return description;
    }

    private PersistentComponentDescription updateFromV30ToV31(PersistentComponentDescription description) throws JsonParseException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.updateSchedulingInformation((PersistentComponentDescription)description);
        description.setComponentVersion(V3_1);
        return description;
    }

    private PersistentComponentDescription updateToV30(PersistentComponentDescription description) throws JsonParseException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.updateAllDynamicEndpointsToIdentifier((String)"dynamicOutputs", (String)"default", (PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.updateAllDynamicEndpointsToIdentifier((String)"dynamicInputs", (String)"default", (PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.addStaticOutput((PersistentComponentDescription)description, (String)"CPACS");
        description = PersistentComponentDescriptionUpdaterUtils.updateDynamicInputsOptional((PersistentComponentDescription)description);
        description.setComponentVersion(V3_1);
        return description;
    }
}

