/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.configmanager.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.configmanager.internal.ConfigurationAdminFacade;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

final class ConfigAdminServiceTracker
extends ServiceTracker {
    private static final String CONFIG_ADMIN_SERVICE_NAME = ConfigurationAdmin.class.getName();
    private static final Log mLogger = LogFactory.getLog(ConfigAdminServiceTracker.class);
    private ConfigurationAdminFacade mFacade;

    ConfigAdminServiceTracker(BundleContext bundleContext, ConfigurationAdminFacade facade) {
        super(bundleContext, CONFIG_ADMIN_SERVICE_NAME, null);
        NullArgumentException.validateNotNull(facade, "facade");
        this.mFacade = facade;
    }

    public final Object addingService(ServiceReference serviceReference) {
        ConfigurationAdmin service = (ConfigurationAdmin)super.addingService(serviceReference);
        this.mFacade.setConfigurationAdminService(service);
        try {
            this.mFacade.registerConfigurations(null, false);
        }
        catch (Throwable e) {
            mLogger.error("Can't load configuration", e);
        }
        return service;
    }

    public void removedService(ServiceReference serviceReference, Object service) {
        this.mFacade.setConfigurationAdminService(null);
        this.context.ungetService(serviceReference);
    }
}

