/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.nebula.visualization.internal.xygraph.undo.AxisPanOrZoomCommand;
import org.eclipse.nebula.visualization.internal.xygraph.undo.SaveStateCommand;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.figures.Grid;
import org.eclipse.nebula.visualization.xygraph.figures.IAxisListener;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.ZoomType;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.nebula.visualization.xygraph.util.GraphicsUtil;
import org.eclipse.nebula.visualization.xygraph.util.Log10;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Axis
extends LinearScale {
    static final double ZOOM_RATIO = 0.1;
    static final int ZOOM_SPEED = 200;
    private String title;
    private final List<Trace> traceList = new ArrayList<Trace>();
    private XYGraph xyGraph;
    private Grid grid;
    private Font titleFont;
    private FontData titleFontData;
    private FontData scaleFontData;
    private boolean autoScale = false;
    private boolean showMajorGrid = false;
    private boolean showMinorGrid = false;
    private Color majorGridColor;
    private Color minorGridColor;
    private boolean dashGridLine = true;
    private double autoScaleThreshold = 0.01;
    private final List<IAxisListener> listeners = new ArrayList<IAxisListener>();
    private ZoomType zoomType = ZoomType.NONE;
    private Point start;
    private Point end;
    private boolean armed;
    private Range startRange;
    private Cursor grabbing;
    private Color revertBackColor;
    private RGB colorRGB;
    private RGB majorGridColorRGB;

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.scaleFontData = this.getFont().getFontData()[0];
    }

    public FontData getTitleFontData() {
        return this.titleFontData;
    }

    public FontData getScaleFontData() {
        return this.scaleFontData;
    }

    public Axis(String title, boolean yAxis) {
        this.title = title;
        if (yAxis) {
            this.setOrientation(LinearScale.Orientation.VERTICAL);
        }
        if (GraphicsUtil.isRAP()) {
            this.setMinorTicksVisible(false);
        }
        AxisMouseListener panner = new AxisMouseListener();
        this.addMouseListener(panner);
        this.addMouseMotionListener((MouseMotionListener)panner);
        this.grabbing = XYGraphMediaFactory.getCursor(XYGraphMediaFactory.CURSOR_TYPE.GRABBING);
        Font sysFont = Display.getCurrent().getSystemFont();
        this.titleFont = XYGraphMediaFactory.getInstance().getFont(new FontData(sysFont.getFontData()[0].getName(), 12, 1));
        if (this.getBackgroundColor() != null) {
            RGB backRGB = this.getBackgroundColor().getRGB();
            this.revertBackColor = XYGraphMediaFactory.getInstance().getColor(255 - backRGB.red, 255 - backRGB.green, 255 - backRGB.blue);
        } else {
            this.revertBackColor = XYGraphMediaFactory.getInstance().getColor(100, 100, 100);
        }
    }

    public void addListener(IAxisListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public boolean removeListener(IAxisListener listener) {
        return this.listeners.remove(listener);
    }

    private void fireRevalidated() {
        for (IAxisListener listener : this.listeners) {
            listener.axisRevalidated(this);
        }
    }

    private void fireAxisRangeChanged(Range old_range, Range new_range) {
        for (IAxisListener listener : this.listeners) {
            listener.axisRangeChanged(this, old_range, new_range);
        }
    }

    @Override
    public void setRange(double lower, double upper) {
        Range old_range = this.getRange();
        super.setRange(lower, upper);
        this.fireAxisRangeChanged(old_range, this.getRange());
    }

    @Override
    protected void layout() {
        super.layout();
        this.fireRevalidated();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.revalidate();
    }

    @Override
    public void setForegroundColor(Color color) {
        Color oldColor = this.getForegroundColor();
        super.setForegroundColor(color);
        this.colorRGB = color.getRGB();
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
        this.fireAxisForegroundColorChanged(oldColor, color);
    }

    @Override
    public void setMinorTicksVisible(boolean minorTicksVisible) {
        if (GraphicsUtil.isRAP()) {
            super.setMinorTicksVisible(false);
        } else {
            super.setMinorTicksVisible(minorTicksVisible);
        }
    }

    public RGB getForegroundColorRGB() {
        return this.colorRGB;
    }

    private void fireAxisForegroundColorChanged(Color oldColor, Color newColor) {
        for (IAxisListener listener : this.listeners) {
            listener.axisForegroundColorChanged(this, oldColor, newColor);
        }
    }

    public void setBackgroundColor(Color bg) {
        RGB backRGB = bg.getRGB();
        this.revertBackColor = XYGraphMediaFactory.getInstance().getColor(255 - backRGB.red, 255 - backRGB.green, 255 - backRGB.blue);
        super.setBackgroundColor(bg);
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = super.getPreferredSize(wHint, hHint);
        if (this.isVisible()) {
            if (this.isHorizontal()) {
                d.height += FigureUtilities.getTextExtents((String)this.title, (Font)this.titleFont).height;
            } else {
                d.width += FigureUtilities.getTextExtents((String)this.title, (Font)this.titleFont).height;
            }
        } else if (this.isHorizontal()) {
            d.height = 0;
        } else {
            d.width = 0;
        }
        return d;
    }

    protected void paintClientArea(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        super.paintClientArea(graphics);
        graphics.setFont(this.titleFont);
        Dimension titleSize = FigureUtilities.getTextExtents((String)this.title, (Font)this.titleFont);
        if (this.isHorizontal()) {
            if (this.getTickLablesSide() == AbstractScale.LabelSide.Primary) {
                graphics.drawText(this.title, this.bounds.x + this.bounds.width / 2 - titleSize.width / 2, this.bounds.y + this.bounds.height - titleSize.height);
            } else {
                graphics.drawText(this.title, this.bounds.x + this.bounds.width / 2 - titleSize.width / 2, this.bounds.y);
            }
        } else {
            int w = titleSize.height;
            int h = titleSize.width + 1;
            if (this.getTickLablesSide() == AbstractScale.LabelSide.Primary) {
                GraphicsUtil.drawVerticalText(graphics, this.title, this.bounds.x, this.bounds.y + this.bounds.height / 2 - h / 2, false);
            } else {
                GraphicsUtil.drawVerticalText(graphics, this.title, this.bounds.x + this.bounds.width - w, this.bounds.y + this.bounds.height / 2 - h / 2, true);
            }
        }
        if (this.armed && this.end != null && this.start != null) {
            switch (this.zoomType) {
                case RUBBERBAND_ZOOM: 
                case HORIZONTAL_ZOOM: 
                case VERTICAL_ZOOM: {
                    graphics.setLineStyle(3);
                    graphics.setLineWidth(1);
                    graphics.setForegroundColor(this.revertBackColor);
                    graphics.drawRectangle(this.start.x, this.start.y, this.end.x - this.start.x - 1, this.end.y - this.start.y - 1);
                    break;
                }
            }
        }
    }

    public Range getTraceDataRange() {
        double low = Double.POSITIVE_INFINITY;
        double high = Double.NEGATIVE_INFINITY;
        for (Trace trace : this.traceList) {
            Range range;
            if (trace.getDataProvider() == null || !trace.isVisible() || (range = this.isHorizontal() ? trace.getDataProvider().getXDataMinMax() : trace.getDataProvider().getYDataMinMax()) == null || Double.isInfinite(range.getLower()) || Double.isInfinite(range.getUpper()) || Double.isNaN(range.getLower()) || Double.isNaN(range.getUpper())) continue;
            if (low > range.getLower()) {
                low = range.getLower();
            }
            if (!(high < range.getUpper())) continue;
            high = range.getUpper();
        }
        if (Double.isInfinite(low) || Double.isInfinite(high)) {
            return null;
        }
        return new Range(low, high);
    }

    public boolean performAutoScale(boolean force) {
        if (this.traceList.size() <= 0 || !force && !this.autoScale) {
            return false;
        }
        Range range = this.getTraceDataRange();
        if (range == null) {
            return false;
        }
        double tempMin = range.getLower();
        double tempMax = range.getUpper();
        double max = this.getRange().getUpper();
        double min = this.getRange().getLower();
        if (this.isLogScaleEnabled()) {
            tempMin = Log10.log10(tempMin);
            tempMax = Log10.log10(tempMax);
            max = Log10.log10(max);
            min = Log10.log10(min);
        }
        double thr = (max - min) * this.autoScaleThreshold;
        if (tempMin - min >= 0.0 && tempMin - min < thr && max - tempMax >= 0.0 && max - tempMax < thr) {
            return false;
        }
        if (tempMin - min < 0.0) {
            tempMin -= thr;
        }
        if (tempMax - max > 0.0) {
            tempMax += thr;
        }
        if (Double.doubleToLongBits(tempMin) == Double.doubleToLongBits(min) && Double.doubleToLongBits(tempMax) == Double.doubleToLongBits(max) || Double.isInfinite(tempMin) || Double.isInfinite(tempMax) || Double.isNaN(tempMin) || Double.isNaN(tempMax)) {
            return false;
        }
        if (this.isLogScaleEnabled()) {
            tempMin = Log10.pow10(tempMin);
            tempMax = Log10.pow10(tempMax);
        }
        this.setRange(tempMin, tempMax, true);
        this.repaint();
        return true;
    }

    public void addTrace(Trace trace) {
        if (this.traceList.contains(trace)) {
            return;
        }
        this.traceList.add(trace);
        this.performAutoScale(false);
    }

    public boolean removeTrace(Trace trace) {
        boolean r = this.traceList.remove(trace);
        this.performAutoScale(false);
        return r;
    }

    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
        this.fireAxisTitleChanged(oldTitle, title);
    }

    private void fireAxisTitleChanged(String oldTitle, String newTitle) {
        for (IAxisListener listener : this.listeners) {
            listener.axisTitleChanged(this, oldTitle, newTitle);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        boolean oldAutoScale = this.autoScale;
        this.autoScale = autoScale;
        this.performAutoScale(false);
        this.fireAxisAutoScaleChanged(oldAutoScale, this.autoScale);
    }

    private void fireAxisAutoScaleChanged(boolean oldAutoScale, boolean newAutoScale) {
        for (IAxisListener listener : this.listeners) {
            listener.axisAutoScaleChanged(this, oldAutoScale, newAutoScale);
        }
    }

    public boolean isShowMajorGrid() {
        return this.showMajorGrid;
    }

    public void setShowMajorGrid(boolean showMajorGrid) {
        this.showMajorGrid = showMajorGrid;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public boolean isShowMinorGrid() {
        return this.showMinorGrid;
    }

    public void setShowMinorGrid(boolean showMinorGrid) {
        this.showMinorGrid = showMinorGrid;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public Color getMajorGridColor() {
        if (this.majorGridColor == null) {
            this.majorGridColor = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GRAY);
        }
        return this.majorGridColor;
    }

    public void setMajorGridColor(Color majorGridColor) {
        this.majorGridColor = majorGridColor;
        this.majorGridColorRGB = majorGridColor.getRGB();
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public RGB getMajorGridColorRGB() {
        return this.majorGridColorRGB;
    }

    public Color getMinorGridColor() {
        if (this.minorGridColor == null) {
            this.minorGridColor = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GRAY);
        }
        return this.minorGridColor;
    }

    public void setMinorGridColor(Color minorGridColor) {
        this.minorGridColor = minorGridColor;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
        this.titleFontData = titleFont.getFontData()[0];
        this.repaint();
    }

    public boolean isDashGridLine() {
        return this.dashGridLine;
    }

    public void setDashGridLine(boolean dashGridLine) {
        this.dashGridLine = dashGridLine;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public void setXyGraph(XYGraph xyGraph) {
        this.xyGraph = xyGraph;
    }

    public String toString() {
        return this.title;
    }

    public void dataChanged(IDataProvider dataProvider) {
        if (this.autoScale) {
            this.performAutoScale(false);
        }
    }

    public void setAutoScaleThreshold(double autoScaleThreshold) {
        if (autoScaleThreshold > 1.0 || autoScaleThreshold < 0.0) {
            throw new RuntimeException("The autoScaleThreshold must be a value in range [0,1]!");
        }
        this.autoScaleThreshold = autoScaleThreshold;
    }

    private boolean isValidZoomType(ZoomType zoom) {
        return zoom == ZoomType.PANNING || zoom == ZoomType.RUBBERBAND_ZOOM || zoom == ZoomType.ZOOM_IN || zoom == ZoomType.ZOOM_OUT || this.isHorizontal() && (zoom == ZoomType.HORIZONTAL_ZOOM || zoom == ZoomType.ZOOM_IN_HORIZONTALLY || zoom == ZoomType.ZOOM_OUT_HORIZONTALLY) || !this.isHorizontal() && (zoom == ZoomType.VERTICAL_ZOOM || zoom == ZoomType.ZOOM_OUT_VERTICALLY || zoom == ZoomType.ZOOM_IN_VERTICALLY);
    }

    public void setZoomType(ZoomType zoomType) {
        this.zoomType = zoomType;
        if (this.isValidZoomType(zoomType)) {
            this.setCursor(zoomType.getCursor());
        } else {
            this.setCursor(ZoomType.NONE.getCursor());
        }
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public double getAutoScaleThreshold() {
        return this.autoScaleThreshold;
    }

    public void setYAxis(boolean isYAxis) {
        if (this.xyGraph != null) {
            this.xyGraph.removeAxis(this);
        }
        this.setOrientation(isYAxis ? LinearScale.Orientation.VERTICAL : LinearScale.Orientation.HORIZONTAL);
        if (this.xyGraph != null) {
            this.xyGraph.addAxis(this);
        }
    }

    public void setPrimarySide(boolean onPrimarySide) {
        this.setTickLableSide(onPrimarySide ? AbstractScale.LabelSide.Primary : AbstractScale.LabelSide.Secondary);
    }

    public boolean isYAxis() {
        return !this.isHorizontal();
    }

    public boolean isOnPrimarySide() {
        return this.getTickLablesSide() == AbstractScale.LabelSide.Primary;
    }

    private void pan() {
        if (this.isHorizontal()) {
            this.pan(this.startRange, this.getPositionValue(this.start.x, false), this.getPositionValue(this.end.x, false));
        } else {
            this.pan(this.startRange, this.getPositionValue(this.start.y, false), this.getPositionValue(this.end.y, false));
        }
    }

    void pan(Range temp, double t1, double t2) {
        if (this.isLogScaleEnabled()) {
            double m = Math.log10(t2) - Math.log10(t1);
            t1 = Math.pow(10.0, Math.log10(temp.getLower()) - m);
            t2 = Math.pow(10.0, Math.log10(temp.getUpper()) - m);
        } else {
            double m = t2 - t1;
            t1 = temp.getLower() - m;
            t2 = temp.getUpper() - m;
        }
        this.setRange(t1, t2);
    }

    void zoomInOut(double center, double factor) {
        double t2;
        double t1;
        if (this.isLogScaleEnabled()) {
            double l = Math.log10(this.getRange().getUpper()) - Math.log10(this.getRange().getLower());
            double r1 = (Math.log10(center) - Math.log10(this.getRange().getLower())) / l;
            double r2 = (Math.log10(this.getRange().getUpper()) - Math.log10(center)) / l;
            t1 = Math.pow(10.0, Math.log10(this.getRange().getLower()) + r1 * factor * l);
            t2 = Math.pow(10.0, Math.log10(this.getRange().getUpper()) - r2 * factor * l);
        } else {
            double l = this.getRange().getUpper() - this.getRange().getLower();
            double r1 = (center - this.getRange().getLower()) / l;
            double r2 = (this.getRange().getUpper() - center) / l;
            t1 = this.getRange().getLower() + r1 * factor * l;
            t2 = this.getRange().getUpper() - r2 * factor * l;
        }
        this.setRange(t1, t2, true);
    }

    public void setGrid(Grid grid) {
        this.grid = grid;
    }

    public Grid getGrid() {
        return this.grid;
    }

    @Override
    public void setLogScale(boolean enabled) throws IllegalStateException {
        boolean old = this.isLogScaleEnabled();
        super.setLogScale(enabled);
        this.fireAxisLogScaleChanged(old, this.logScaleEnabled);
    }

    private void fireAxisLogScaleChanged(boolean old, boolean logScale) {
        if (old == logScale) {
            return;
        }
        for (IAxisListener listener : this.listeners) {
            listener.axisLogScaleChanged(this, old, logScale);
        }
    }

    class AxisMouseListener
    extends MouseMotionListener.Stub
    implements MouseListener {
        private SaveStateCommand command;

        AxisMouseListener() {
        }

        public void mousePressed(MouseEvent me) {
            if (me.button != 1 || !Axis.this.isValidZoomType(Axis.this.zoomType)) {
                return;
            }
            Axis.this.armed = true;
            switch (Axis.this.zoomType) {
                case RUBBERBAND_ZOOM: {
                    if (Axis.this.isHorizontal()) {
                        Axis.this.start = new Point(me.getLocation().x, ((Axis)Axis.this).bounds.y);
                    } else {
                        Axis.this.start = new Point(((Axis)Axis.this).bounds.x, me.getLocation().y);
                    }
                    Axis.this.end = null;
                    break;
                }
                case HORIZONTAL_ZOOM: {
                    Axis.this.start = new Point(me.getLocation().x, ((Axis)Axis.this).bounds.y);
                    Axis.this.end = null;
                    break;
                }
                case VERTICAL_ZOOM: {
                    Axis.this.start = new Point(((Axis)Axis.this).bounds.x, me.getLocation().y);
                    Axis.this.end = null;
                    break;
                }
                case PANNING: {
                    Axis.this.setCursor(Axis.this.grabbing);
                    Axis.this.start = me.getLocation();
                    Axis.this.end = null;
                    Axis.this.startRange = Axis.this.getRange();
                    break;
                }
                case ZOOM_IN: 
                case ZOOM_OUT: 
                case ZOOM_IN_HORIZONTALLY: 
                case ZOOM_OUT_HORIZONTALLY: 
                case ZOOM_IN_VERTICALLY: 
                case ZOOM_OUT_VERTICALLY: {
                    Axis.this.start = me.getLocation();
                    Axis.this.end = new Point();
                    Display.getCurrent().timerExec(200, new Runnable(){

                        @Override
                        public void run() {
                            if (!Axis.this.armed) {
                                return;
                            }
                            AxisMouseListener.this.performInOutZoom();
                            Display.getCurrent().timerExec(200, (Runnable)this);
                        }
                    });
                    break;
                }
            }
            this.command = new AxisPanOrZoomCommand(Axis.this.zoomType.getDescription(), Axis.this);
            me.consume();
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent me) {
            if (!Axis.this.armed) {
                return;
            }
            switch (Axis.this.zoomType) {
                case RUBBERBAND_ZOOM: {
                    if (Axis.this.isHorizontal()) {
                        Axis.this.end = new Point(me.getLocation().x, ((Axis)Axis.this).bounds.y + ((Axis)Axis.this).bounds.height);
                        break;
                    }
                    Axis.this.end = new Point(((Axis)Axis.this).bounds.x + ((Axis)Axis.this).bounds.width, me.getLocation().y);
                    break;
                }
                case HORIZONTAL_ZOOM: {
                    Axis.this.end = new Point(me.getLocation().x, ((Axis)Axis.this).bounds.y + ((Axis)Axis.this).bounds.height);
                    break;
                }
                case VERTICAL_ZOOM: {
                    Axis.this.end = new Point(((Axis)Axis.this).bounds.x + ((Axis)Axis.this).bounds.width, me.getLocation().y);
                    break;
                }
                case PANNING: {
                    Axis.this.end = me.getLocation();
                    Axis.this.pan();
                    break;
                }
            }
            Axis.this.repaint();
        }

        public void mouseExited(MouseEvent me) {
            switch (Axis.this.zoomType) {
                case ZOOM_IN: 
                case ZOOM_OUT: 
                case ZOOM_IN_HORIZONTALLY: 
                case ZOOM_OUT_HORIZONTALLY: 
                case ZOOM_IN_VERTICALLY: 
                case ZOOM_OUT_VERTICALLY: {
                    this.mouseReleased(me);
                }
            }
        }

        public void mouseReleased(MouseEvent me) {
            if (!Axis.this.armed) {
                return;
            }
            Axis.this.armed = false;
            if (Axis.this.zoomType == ZoomType.PANNING) {
                Axis.this.setCursor(Axis.this.zoomType.getCursor());
            }
            if (Axis.this.end == null || Axis.this.start == null || this.command == null) {
                return;
            }
            switch (Axis.this.zoomType) {
                case RUBBERBAND_ZOOM: 
                case HORIZONTAL_ZOOM: 
                case VERTICAL_ZOOM: {
                    this.performStartEndZoom();
                    break;
                }
                case PANNING: {
                    Axis.this.pan();
                    break;
                }
                case ZOOM_IN: 
                case ZOOM_OUT: 
                case ZOOM_IN_HORIZONTALLY: 
                case ZOOM_OUT_HORIZONTALLY: 
                case ZOOM_IN_VERTICALLY: 
                case ZOOM_OUT_VERTICALLY: {
                    this.performInOutZoom();
                    break;
                }
            }
            this.command.saveState();
            Axis.this.xyGraph.getOperationsManager().addCommand(this.command);
            this.command = null;
            Axis.this.start = null;
            Axis.this.end = null;
        }

        private void performStartEndZoom() {
            double t1 = Axis.this.getPositionValue(Axis.this.isHorizontal() ? ((Axis)Axis.this).start.x : ((Axis)Axis.this).start.y, false);
            double t2 = Axis.this.getPositionValue(Axis.this.isHorizontal() ? ((Axis)Axis.this).end.x : ((Axis)Axis.this).end.y, false);
            Axis.this.setRange(t1, t2, true);
        }

        private void performInOutZoom() {
            int pixel_pos = Axis.this.isHorizontal() ? ((Axis)Axis.this).start.x : ((Axis)Axis.this).start.y;
            double center = Axis.this.getPositionValue(pixel_pos, false);
            switch (Axis.this.zoomType) {
                case ZOOM_IN: {
                    Axis.this.zoomInOut(center, 0.1);
                    break;
                }
                case ZOOM_IN_HORIZONTALLY: {
                    Axis.this.zoomInOut(center, 0.1);
                    break;
                }
                case ZOOM_IN_VERTICALLY: {
                    Axis.this.zoomInOut(center, 0.1);
                    break;
                }
                case ZOOM_OUT: {
                    Axis.this.zoomInOut(center, -0.1);
                    break;
                }
                case ZOOM_OUT_HORIZONTALLY: {
                    Axis.this.zoomInOut(center, -0.1);
                    break;
                }
                case ZOOM_OUT_VERTICALLY: {
                    Axis.this.zoomInOut(center, -0.1);
                }
            }
        }
    }
}

