/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal.factory;

import de.rcenvironment.supplemental.cmdows.importer.api.SchemaParsingException;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockComponent;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockComponentImpl;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockImpl;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockType;
import java.util.HashMap;
import java.util.Map;

public class ExecutableBlockFactory {
    private final Map<String, ExecutableBlock> execBlockPool = new HashMap<String, ExecutableBlock>();

    public ExecutableBlockImpl getOrCreateExecutableBlockImpl(String uid, ExecutableBlockType type) throws SchemaParsingException {
        ExecutableBlock impl = null;
        if (this.execBlockPool.containsKey(uid = uid.trim())) {
            impl = this.execBlockPool.get(uid);
            if (!ExecutableBlockImpl.class.equals(((Object)((Object)type)).getClass()) || !(impl instanceof ExecutableBlockImpl)) {
                throw new SchemaParsingException("Tried to create executable block with wrong type.");
            }
        } else {
            impl = new ExecutableBlockImpl(uid, type);
            this.execBlockPool.put(uid, impl);
        }
        return (ExecutableBlockImpl)impl;
    }

    public ExecutableBlockComponentImpl getOrCreateExecutableBlockComponentImpl(String uid, ExecutableBlockType type) throws SchemaParsingException {
        ExecutableBlock impl = null;
        if (this.execBlockPool.containsKey(uid = uid.trim())) {
            impl = this.execBlockPool.get(uid);
            if (!ExecutableBlockComponent.class.equals(type.getType()) || !(impl instanceof ExecutableBlockComponentImpl)) {
                throw new SchemaParsingException("Tried to create executable block with wrong type.");
            }
        } else {
            impl = new ExecutableBlockComponentImpl(uid, type);
            this.execBlockPool.put(uid, impl);
        }
        return (ExecutableBlockComponentImpl)impl;
    }

    public ExecutableBlock getExecutableBlock(String uid) {
        return this.execBlockPool.get(uid);
    }

    public boolean isExecBlockUIDExistent(String uid) {
        return this.execBlockPool.containsKey(uid);
    }

    public void clear() {
        this.execBlockPool.clear();
    }
}

