/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.model.graph;

import de.rcenvironment.supplemental.cmdows.importer.internal.utils.CMDOWSGraphLoop;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ProcessGraphNode
implements SchemaGraphNode<ExecutableBlock> {
    private final String uid;
    private final List<SchemaGraphNode<ExecutableBlock>> nodeList;
    private final List<SchemaGraphNode<ExecutableBlock>> parentNodeList;
    private Integer pos;
    private Integer processStepNumber;
    private Integer convergerStepNumber;
    private CMDOWSGraphLoop loop;
    private ExecutableBlock content;

    public ProcessGraphNode(String uid, ExecutableBlock content) {
        this.uid = uid;
        this.content = content;
        this.nodeList = new ArrayList<SchemaGraphNode<ExecutableBlock>>();
        this.parentNodeList = new ArrayList<SchemaGraphNode<ExecutableBlock>>();
    }

    public void setLoop(CMDOWSGraphLoop loop) {
        this.loop = loop;
    }

    public CMDOWSGraphLoop getLoop() {
        return this.loop;
    }

    public void setConvergerStepNumber(Integer convergerStepNumber) {
        this.convergerStepNumber = convergerStepNumber;
    }

    public Integer getConvergerStepNumber() {
        return this.convergerStepNumber;
    }

    public void setProcessStepNumber(Integer stepNumber) {
        this.processStepNumber = stepNumber;
    }

    public Integer getStepNumber() {
        return this.processStepNumber;
    }

    public void setDiagonalPosition(int p) {
        this.pos = p;
    }

    @Override
    public ExecutableBlock getNodeContent() {
        return this.content;
    }

    @Override
    public List<SchemaGraphNode<ExecutableBlock>> getAdjacencyList() {
        return this.nodeList;
    }

    public boolean addAdjacencyToNode(SchemaGraphNode<ExecutableBlock> nodeToAdd) {
        if (!this.nodeList.contains(nodeToAdd)) {
            return this.nodeList.add(nodeToAdd);
        }
        return false;
    }

    public Integer getPosition() {
        return this.pos;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uid).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProcessGraphNode) {
            ProcessGraphNode other = (ProcessGraphNode)obj;
            return new EqualsBuilder().append((Object)this.uid, (Object)other.uid).isEquals();
        }
        return false;
    }

    @Override
    public List<SchemaGraphNode<ExecutableBlock>> getParentNodeList() {
        return this.parentNodeList;
    }

    public void addParentAdjacencyToNode(ProcessGraphNode fromNode) {
        this.parentNodeList.add(fromNode);
    }
}

