/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal.utils;

import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentSize;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.commands.CommandStack;

public final class CMDOWSWorkflowCreationUtils {
    private CMDOWSWorkflowCreationUtils() {
    }

    public static WorkflowNode createWorkflowNode(ComponentInstallation compInstallation, String name) {
        ComponentDescription description = new ComponentDescription(compInstallation);
        WorkflowNode node = new WorkflowNode(description);
        node.setName(name);
        node.getConfigurationDescription().setConfigurationValue("storeComponentHistoryData", Boolean.toString(true));
        return node;
    }

    public static void executeEndpointAddCommand(WorkflowNode node, WorkflowNodeCommand command) {
        command.setWorkflowNode(node);
        CommandStack fakeStack = new CommandStack();
        command.setCommandStack(fakeStack);
        command.execute();
        fakeStack.dispose();
    }

    public static void addForwardingCPACSEndpoints(WorkflowNode driverComponent, String endSuffix) {
        HashMap metaData = new HashMap();
        driverComponent.getInputDescriptionsManager().addDynamicEndpointDescription("startToForward", "CPACS_start", DataType.FileReference, new HashMap(), "startValues", false);
        driverComponent.getInputDescriptionsManager().addDynamicEndpointDescription("toForward", "CPACS", DataType.FileReference, new HashMap());
        driverComponent.getOutputDescriptionsManager().addDynamicEndpointDescription("toForward", "CPACS", DataType.FileReference, metaData);
        if (endSuffix != null) {
            driverComponent.getOutputDescriptionsManager().addDynamicEndpointDescription("finalToForward", "CPACS" + endSuffix, DataType.FileReference, metaData);
        }
    }

    public static void addDynamicXMLEndpointsToComponent(EndpointDescriptionsManager endpointDescriptionsManager, String xmlPath, String endpointName) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("variable.xpath", xmlPath);
        endpointDescriptionsManager.addDynamicEndpointDescription("default", endpointName, DataType.Float, metadata, false);
    }

    public static String removeForbiddenCharacters(String name) {
        return name.replaceAll("\\^", "_");
    }

    public static void addWorkflowConnection(WorkflowNode fromNode, String outputName, WorkflowNode toNode, String inputName, WorkflowDescription wfDesc) {
        Connection connection = new Connection(fromNode, fromNode.getOutputDescriptionsManager().getEndpointDescription(outputName), toNode, toNode.getInputDescriptionsManager().getEndpointDescription(inputName));
        wfDesc.addConnection(connection);
    }

    public static void addWorkflowConnectionWithBendpoint(WorkflowNode fromNode, String outputName, WorkflowNode toNode, String inputName, WorkflowDescription wfDesc) {
        Connection connection = new Connection(fromNode, fromNode.getOutputDescriptionsManager().getEndpointDescription(outputName), toNode, toNode.getInputDescriptionsManager().getEndpointDescription(inputName));
        int xOffset = 0;
        int yOffset = 0;
        ComponentSize fromSize = fromNode.getComponentDescription().getComponentInstallation().getComponentRevision().getComponentInterface().getSize();
        ComponentSize toSize = toNode.getComponentDescription().getComponentInstallation().getComponentRevision().getComponentInterface().getSize();
        if (fromSize == ComponentSize.SMALL) {
            if (toSize == ComponentSize.SMALL) {
                xOffset = 40;
                xOffset = yOffset = xOffset / 2;
            } else {
                xOffset = 40;
                yOffset = 20;
            }
        } else if (toSize == ComponentSize.SMALL) {
            yOffset = 40;
            xOffset = yOffset / 2;
        } else {
            yOffset = xOffset = 40;
        }
        if (!fromNode.equals((Object)toNode)) {
            connection.addBendpoint(0, toNode.getX() + xOffset, fromNode.getY() + yOffset, false);
        }
        wfDesc.addConnection(connection);
    }

    public static WorkflowNode createMergerNodeWithMergingScript(String nameSuffix, Map<String, ComponentInstallation> installations, List<String> pathsToIntegrate) {
        HashMap<String, String> clonedPaths = new HashMap<String, String>();
        for (String path : pathsToIntegrate) {
            clonedPaths.put(path, path);
        }
        return CMDOWSWorkflowCreationUtils.createMergerNodeWithMergingScript(nameSuffix, installations, clonedPaths);
    }

    public static WorkflowNode createMergerNodeWithMergingScript(String nameSuffix, Map<String, ComponentInstallation> installations, Map<String, String> pathsToIntegrate) {
        WorkflowNode node = CMDOWSWorkflowCreationUtils.createWorkflowNode(installations.get("de.rcenvironment.xmlmerger"), nameSuffix);
        node.setName("Merger_" + nameSuffix);
        ConfigurationDescription configurationDescription = node.getConfigurationDescription();
        configurationDescription.setConfigurationValue("mappingType", "Classic");
        configurationDescription.setConfigurationValue("mappingFileDeployment", "loaded");
        StringBuilder script = new StringBuilder().append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<map:mappings xmlns:map=\"http://www.rcenvironment.de/2015/mapping\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n");
        for (Map.Entry<String, String> parameter : pathsToIntegrate.entrySet()) {
            script.append(StringUtils.format((String)"\t<map:mapping mode=\"delete\">\n\t\t<map:source>%s</map:source>\n\t\t<map:target>%s</map:target>\n", (Object[])new Object[]{parameter.getKey(), parameter.getValue()}));
            script.append("\t</map:mapping>\n");
        }
        script.append("</map:mappings>\n");
        node.getConfigurationDescription().setConfigurationValue("xmlContent", script.toString());
        return node;
    }

    public static WorkflowNode addMergerNodeWithDefaultScript(String nameSuffix, Map<String, ComponentInstallation> installations) {
        WorkflowNode node = CMDOWSWorkflowCreationUtils.createMergerNodeWithMergingScript(nameSuffix, installations, Collections.emptyMap());
        node.getConfigurationDescription().setConfigurationValue("mappingType", "XSLT");
        StringBuilder script = new StringBuilder().append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsl:stylesheet version=\"1.0\"\n    xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" exclude-result-prefixes=\"xsi\">\n    <xsl:output method=\"xml\" version=\"1.0\" encoding=\"UTF-8\" indent=\"yes\"/>\n    <xsl:template match=\"@* | node()\">\n        <xsl:copy>\n            <xsl:apply-templates select=\"@* | node()\"/>\n        </xsl:copy>\n    </xsl:template>\n</xsl:stylesheet>\n");
        node.getConfigurationDescription().setConfigurationValue("xmlContent", script.toString());
        return node;
    }
}

