/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal;

import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.xml.XMLException;
import de.rcenvironment.core.utils.common.xml.api.XMLSupportService;
import de.rcenvironment.supplemental.cmdows.importer.api.CMDOWSNodeType;
import de.rcenvironment.supplemental.cmdows.importer.api.CMDOWSParsingState;
import de.rcenvironment.supplemental.cmdows.importer.api.SchemaParsingException;
import de.rcenvironment.supplemental.cmdows.importer.api.SchemaToWorkflowDescriptionParsingService;
import de.rcenvironment.supplemental.cmdows.importer.api.WorkflowDescriptionTranslatorService;
import de.rcenvironment.supplemental.cmdows.importer.internal.factory.ExecutableBlockFactory;
import de.rcenvironment.supplemental.cmdows.importer.internal.factory.SchemaGraphNodeFactory;
import de.rcenvironment.supplemental.cmdows.importer.internal.factory.SchemaParameterFactory;
import de.rcenvironment.supplemental.cmdows.importer.internal.utils.CMDOWSGraphLoop;
import de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks.MathematicalFunctionType;
import de.rcenvironment.supplemental.cmdows.importer.model.CMDOWSDataModel;
import de.rcenvironment.supplemental.cmdows.importer.model.CMDOWSProblemFormulation;
import de.rcenvironment.supplemental.cmdows.importer.model.DOESettings;
import de.rcenvironment.supplemental.cmdows.importer.model.SchemaHeader;
import de.rcenvironment.supplemental.cmdows.importer.model.WorkflowSchemaModel;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockComponentImpl;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockType;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.DataGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.ProcessGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameter;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameterType;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaParameter;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaParameterImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMDOWSParsingServiceImpl
implements SchemaToWorkflowDescriptionParsingService {
    private static final int NUM_EXPERIMENTS_UNINITIALIZED_MARKER = -1;
    private static final String NODE_NAME_CANNOT_BE_NULL_MSG = "Node name cannot be null!";
    private static XMLSupportService xmlSupportService;
    private WorkflowDescriptionPersistenceHandler wfPersistenceHandler = new WorkflowDescriptionPersistenceHandler();
    private SchemaHeader.SchemaHeaderBuilder schemaHeaderBuilder;
    private CMDOWSProblemFormulation.CMDOWSProblemFormulationBuilder problemFormulationBuilder;
    private DOESettings.DOESettingsBuilder doeSettingsBuilder;
    private ExecutableBlockFactory execBlockFactory;
    private SchemaParameterFactory parameterFactory;
    private SchemaGraphNodeFactory graphNodeFactory;
    private WorkflowSchemaModel modelForTest;

    protected void bindXMLSupportService(XMLSupportService instance) {
        xmlSupportService = instance;
    }

    protected void unbindXMLSupportService(XMLSupportService instance) {
        xmlSupportService = null;
    }

    protected WorkflowSchemaModel getWorkflowModel() {
        return this.modelForTest;
    }

    @Override
    public void parseSchemaToWorkflowFile(File schema, WorkflowDescriptionTranslatorService translator, String outputPath, String fileName, String cpacsFilePath) throws SchemaParsingException {
        this.parseSchemaToWorkflowFile(schema, translator, outputPath, fileName, cpacsFilePath, null);
    }

    @Override
    public void parseSchemaToWorkflowFile(File schema, WorkflowDescriptionTranslatorService translator, String outputPath, String fileName, String cpacsFilepath, String[] mailInformation) throws SchemaParsingException {
        if (!outputPath.isEmpty() && !new File(outputPath).isDirectory()) {
            throw new SchemaParsingException(StringUtils.format((String)"Given output path \"%s\" is not a directoy.", (Object[])new Object[]{outputPath}));
        }
        CMDOWSDataModel model = null;
        this.schemaHeaderBuilder = new SchemaHeader.SchemaHeaderBuilder();
        this.problemFormulationBuilder = new CMDOWSProblemFormulation.CMDOWSProblemFormulationBuilder();
        this.doeSettingsBuilder = new DOESettings.DOESettingsBuilder();
        this.execBlockFactory = new ExecutableBlockFactory();
        this.parameterFactory = new SchemaParameterFactory();
        this.graphNodeFactory = new SchemaGraphNodeFactory();
        try {
            Document document = xmlSupportService.readXMLFromFile(schema);
            model = new CMDOWSDataModel();
            if (document == null) {
                throw new SchemaParsingException("XML document cannot be null.");
            }
            ArrayList<Element> postProcessingElements = new ArrayList<Element>();
            this.readTree(document.getDocumentElement(), model, new CMDOWSParsingState(null), true, postProcessingElements);
            this.postWorkflowGraphsProcess(postProcessingElements, model);
            this.postProcessesSchemaModel(model);
            this.modelForTest = model;
        }
        catch (XMLException e) {
            throw new SchemaParsingException("Failed to read CMDOWS file. Aborted with message: " + e.getMessage());
        }
        WorkflowDescription wd = translator.parseSchemaModelToWorkflowDescription(model, cpacsFilepath, mailInformation);
        try {
            ByteArrayOutputStream stream = this.wfPersistenceHandler.writeWorkflowDescriptionToStream(wd);
            String workflowFileName = wd.getFileName();
            if (!fileName.isEmpty() && !(workflowFileName = fileName).endsWith(".wf")) {
                workflowFileName = String.valueOf(workflowFileName) + ".wf";
            }
            if (outputPath.isEmpty()) {
                File rootDirOfCmdowsFile = schema.getParentFile();
                FileUtils.writeByteArrayToFile((File)new File(rootDirOfCmdowsFile, workflowFileName), (byte[])stream.toByteArray());
            } else {
                File outputDir = new File(outputPath);
                FileUtils.writeByteArrayToFile((File)new File(outputDir, workflowFileName), (byte[])stream.toByteArray());
            }
        }
        catch (IOException iOException) {
            throw new SchemaParsingException("Failed to persist workflow description.");
        }
    }

    private void postWorkflowGraphsProcess(List<Element> postProcessingElements, CMDOWSDataModel model) throws SchemaParsingException {
        for (Element elt : postProcessingElements) {
            if (elt.getNodeName().equals("dataGraph")) {
                this.processGraphElements(elt, model, true, DataGraphNode.class);
                continue;
            }
            if (!elt.getNodeName().equals("processGraph")) continue;
            this.processProcessGraphElements(elt, model);
        }
    }

    private void postProcessesSchemaModel(CMDOWSDataModel model) throws SchemaParsingException {
        this.setOutputsForConsistencyConstraintFunctions(model);
        model.setHeader(this.schemaHeaderBuilder.build());
        model.setProblemFormulation(this.problemFormulationBuilder.doeSettings(this.doeSettingsBuilder.build()).build());
        model.setParamPool(this.parameterFactory.getTypedParamMap());
        this.problemFormulationBuilder = null;
        this.doeSettingsBuilder = null;
        this.schemaHeaderBuilder = null;
        this.graphNodeFactory.clear();
        this.execBlockFactory.clear();
        this.parameterFactory.clear();
    }

    private void setOutputsForConsistencyConstraintFunctions(CMDOWSDataModel model) throws SchemaParsingException {
        for (SchemaGraphNode<ExecutableBlock> node : model.getProcessGraph().values()) {
            ExecutableBlock executableBlock = node.getNodeContent();
            if (!ExecutableBlockType.CONSITENCY_CONSTRAINT_FUNCTION.equals((Object)executableBlock.getExecutableBlockType())) continue;
            SchemaGraphNode<Object> object = model.getDataGraph().get(executableBlock.getBlockName());
            List<SchemaGraphNode<Object>> nodeList = object.getAdjacencyList();
            for (SchemaGraphNode<Object> dataGraphNode : nodeList) {
                SchemaDesignParameter consistancyConstraintVariable = (SchemaDesignParameter)dataGraphNode.getNodeContent();
                ((ExecutableBlockComponentImpl)executableBlock).addExecutableBlockComponentOutput(consistancyConstraintVariable);
            }
        }
    }

    private void readTree(Element elt, CMDOWSDataModel model, CMDOWSParsingState state, boolean continueRecursion, List<Element> postProcessingElements) throws SchemaParsingException {
        CMDOWSNodeType type = CMDOWSNodeType.getTypeByNodeName(elt.getNodeName());
        if (state.getCMDOWSNodeType() == null) {
            state.setCMDOWSNodeType(CMDOWSNodeType.getTypeByNodeName(elt.getNodeName()));
        }
        if (state.getCMDOWSNodeType() != null && type != null && !type.getNodeName().equals(state.getCMDOWSNodeType().getNodeName())) {
            state.resetState();
            state.setCMDOWSNodeType(type);
        }
        if (elt.hasChildNodes()) {
            NodeList children = elt.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Element child;
                if (children.item(i).getNodeType() == 1 && (continueRecursion = this.doParsingStep(elt, model, state, child = (Element)children.item(i), postProcessingElements))) {
                    this.readTree(child, model, state, continueRecursion, postProcessingElements);
                }
                ++i;
            }
        }
    }

    private boolean doParsingStep(Element elt, CMDOWSDataModel model, CMDOWSParsingState state, Element child, List<Element> postProcessingElements) throws SchemaParsingException {
        boolean continueWithRecursion = true;
        if (state.getCMDOWSNodeType() == null) {
            return true;
        }
        switch (state.getCMDOWSNodeType()) {
            case DESIGN_COMPETENCE: {
                this.addNodeUIDToStatesAdditionalInformation(state, elt, "designCompetence");
                this.createDesignCompetenceOrMathematicalFunction(child, state, ExecutableBlockType.DESIGN_COMPETENCE);
                break;
            }
            case HEADER: {
                this.createHeader(child);
                break;
            }
            case PARAMETER: {
                this.addNodeUIDToStatesAdditionalInformation(state, elt, "parameter");
                this.createParameters(child, state);
                break;
            }
            case PROBLEM_FORMULATION: {
                this.addNodeUIDToStatesAdditionalInformation(state, elt, "problemForumlation");
                this.createProblemFormulation(child);
                break;
            }
            case PROBLEM_ROLES: {
                this.addNodeUIDToStatesAdditionalInformation(state, elt, "problemRoles");
                continueWithRecursion = this.createProblemRoleParameters(child);
                break;
            }
            case WORKFLOW: {
                this.addNodeUIDToStatesAdditionalInformation(state, elt, "workflow");
                this.createWorkflow(elt, model, postProcessingElements);
                continueWithRecursion = false;
                break;
            }
            case ARCHITECTURE_ELEMENTS: {
                this.addNodeUIDToStatesAdditionalInformation(state, elt, "architectureElements");
                continueWithRecursion = this.createArchitectureElements(child, state);
                break;
            }
            case MATHEMATICAL_FUNCTION: {
                this.addNodeUIDToStatesAdditionalInformation(state, elt, "mathematicalFunction");
                this.createDesignCompetenceOrMathematicalFunction(child, state, ExecutableBlockType.MATHEMATICAL_FUNCTION);
                break;
            }
        }
        if (!continueWithRecursion) {
            state.resetState();
        }
        return continueWithRecursion;
    }

    private boolean createProblemRoleParameters(Element elt) throws SchemaParsingException {
        if (elt.hasChildNodes()) {
            NodeList children = elt.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Element childElement;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (childElement = (Element)child).getParentNode().getNodeName().equals("parameters")) {
                    this.createProblemRoleParameter(childElement, null);
                }
                ++i;
            }
        }
        return true;
    }

    private void createProblemRoleParameter(Element elt, String uid) throws SchemaParsingException {
        if (elt.hasChildNodes()) {
            NodeList children = elt.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element childElement = (Element)child;
                    if (childElement.hasAttribute("uID")) {
                        uid = childElement.getAttribute("uID").trim();
                        this.parameterFactory.getOrCreateSchemaParameterImpl(uid, SchemaDesignParameterType.DEFAULT);
                    } else if (childElement.getNodeName().equals("parameterUID")) {
                        this.parameterFactory.getOrCreateSchemaParameterImpl(uid, SchemaDesignParameterType.DEFAULT).setRelatedParameter(this.parameterFactory.getOrCreateSchemaParameterImpl(childElement.getTextContent(), SchemaDesignParameterType.DEFAULT));
                    } else if (childElement.getNodeName().equals("validRanges")) {
                        SchemaParameterImpl param = (SchemaParameterImpl)this.parameterFactory.getOrCreateSchemaParameterImpl(uid, SchemaDesignParameterType.DEFAULT).getRelatedParameter();
                        this.parseValidRanges(param, childElement);
                    } else {
                        this.parameterFactory.getOrCreateSchemaParameterImpl(uid, SchemaDesignParameterType.DEFAULT).addAdditionalInformationElement(childElement.getNodeName(), childElement.getTextContent());
                    }
                    this.createProblemRoleParameter(childElement, uid);
                }
                ++i;
            }
        }
    }

    private void parseValidRanges(SchemaParameterImpl schemaParameterImpl, Element validRanges) throws SchemaParsingException {
        Element limitRange = this.getChildOrNullByTagName(validRanges, "limitRange");
        if (limitRange != null) {
            Element minimum;
            Element maximum = this.getChildOrNullByTagName(limitRange, "maximum");
            if (maximum != null) {
                schemaParameterImpl.addAdditionalInformationElement("maximum", maximum.getTextContent());
            }
            if ((minimum = this.getChildOrNullByTagName(limitRange, "minimum")) != null) {
                schemaParameterImpl.addAdditionalInformationElement("minimum", minimum.getTextContent());
            }
        }
    }

    private boolean createArchitectureElements(Element elt, CMDOWSParsingState state) throws SchemaParsingException {
        switch (elt.getNodeName()) {
            case "parameters": {
                state.addAdditionalInformation("childParsingScope", elt.getNodeName());
                break;
            }
            case "executableBlocks": {
                state.addAdditionalInformation("childParsingScope", elt.getNodeName());
                break;
            }
        }
        if (state.getAdditionalStateInformation("childParsingScope") == null) {
            return true;
        }
        if (state.getAdditionalStateInformation("childParsingScope").equals("parameters")) {
            this.createArchitectureElementsParam(elt, state);
        } else if (state.getAdditionalStateInformation("childParsingScope").equals("executableBlocks")) {
            this.createArchtiectureElementsExecBlock(elt);
        }
        return true;
    }

    private void createArchitectureElementsParam(Element elt, CMDOWSParsingState state) throws SchemaParsingException {
        SchemaParameterImpl param;
        String uid;
        if (elt.hasAttribute("uID")) {
            uid = elt.getAttribute("uID");
            SchemaDesignParameterType type = null;
            try {
                type = SchemaDesignParameterType.valueOf(elt.getNodeName());
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("No enum constant")) {
                    LogFactory.getLog(CMDOWSParsingServiceImpl.class).error((Object)StringUtils.format((String)"Could not read design parameter %s because type %s does not exist", (Object[])new Object[]{uid, elt.getNodeName()}));
                    type = SchemaDesignParameterType.DEFAULT;
                }
                throw e;
            }
            if (type != null) {
                this.parameterFactory.getOrCreateSchemaParameterImpl(uid, type);
                state.addAdditionalInformation("uID", uid);
            }
        }
        if (elt.getNodeName().equals("relatedParameterUID")) {
            uid = this.extractArchitectureElementUIDString(elt, state);
            param = this.parameterFactory.getOrCreateSchemaParameterImpl(uid, SchemaDesignParameterType.DEFAULT);
            param.setRelatedParameter(this.parameterFactory.getOrCreateSchemaParameterImpl(elt.getTextContent(), SchemaDesignParameterType.DEFAULT));
        } else if (elt.getNodeName().equals("label")) {
            uid = this.extractArchitectureElementUIDString(elt, state);
            param = this.parameterFactory.getOrCreateSchemaParameterImpl(uid, SchemaDesignParameterType.DEFAULT);
            param.setName(elt.getTextContent());
        }
    }

    private String extractArchitectureElementUIDString(Element elt, CMDOWSParsingState state) throws SchemaParsingException {
        Object uidObject = state.getAdditionalStateInformation("uID");
        String uid = null;
        if (!(uidObject instanceof String)) {
            throw new SchemaParsingException("UID is not an instance of the class String.");
        }
        uid = (String)uidObject;
        return uid;
    }

    private void createArchtiectureElementsExecBlock(Element elt) throws SchemaParsingException {
        String name;
        switch (name = elt.getNodeName()) {
            case "optimizer": {
                this.createExecutableBlockComponent(elt, ExecutableBlockType.OPTIMIZER);
                break;
            }
            case "converger": {
                this.createExecutableBlockComponent(elt, ExecutableBlockType.CONVERGER);
                break;
            }
            case "consistencyConstraintFunction": {
                this.createExecutableBlockComponent(elt, ExecutableBlockType.CONSITENCY_CONSTRAINT_FUNCTION);
                break;
            }
            case "doe": {
                this.createExecutableBlockComponent(elt, ExecutableBlockType.DOE);
                break;
            }
            case "coordinator": {
                this.createExecutableBlockComponent(elt, ExecutableBlockType.COORDINATOR);
                break;
            }
        }
    }

    private void createExecutableBlockComponent(Element elt, ExecutableBlockType type) throws SchemaParsingException {
        ExecutableBlockComponentImpl component = null;
        if (elt.hasAttribute("uID")) {
            component = this.execBlockFactory.getOrCreateExecutableBlockComponentImpl(elt.getAttribute("uID"), type);
        }
        if (component != null) {
            this.createExecutableBlockComponentContent(elt, component);
        }
    }

    private void createExecutableBlockComponentContent(Element elt, ExecutableBlockComponentImpl component) throws SchemaParsingException {
        block16: {
            if (!elt.hasChildNodes()) break block16;
            NodeList children = elt.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                block17: {
                    Node node = children.item(i);
                    if (node.getNodeType() != 1) break block17;
                    Element childElement = (Element)node;
                    block4 : switch (childElement.getNodeName()) {
                        case "label": {
                            component.setName(childElement.getTextContent());
                            break;
                        }
                        case "settings": {
                            switch (component.getExecutableBlockType()) {
                                case DOE: {
                                    this.createOptionalExecutableBlockComponentContent(childElement, component);
                                    break block4;
                                }
                                case CONVERGER: {
                                    this.parseConvergerSettings(childElement, component);
                                    break block4;
                                }
                                case OPTIMIZER: {
                                    this.parseOptimizerSettings(childElement, component);
                                }
                            }
                            component.addMetaDatum("settings", childElement.getTextContent());
                            break;
                        }
                        default: {
                            this.createOptionalExecutableBlockComponentContent(childElement, component);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void createOptionalExecutableBlockComponentContent(Element elt, ExecutableBlockComponentImpl component) throws SchemaParsingException {
        ExecutableBlockType type = component.getExecutableBlockType();
        NodeList children = elt.getChildNodes();
        switch (type) {
            case OPTIMIZER: {
                int i = 0;
                while (i < children.getLength()) {
                    Node node = children.item(i);
                    if (node.getNodeType() == 1) {
                        Element childElement = (Element)node;
                        if (childElement.getNodeName().equals(SchemaDesignParameterType.DESIGN_VARIABLE.getName())) {
                            SchemaParameterImpl newSchemaParameter = this.parameterFactory.getOrCreateSchemaParameterImpl(childElement.getTextContent(), SchemaDesignParameterType.valueOf(childElement.getNodeName()));
                            component.addExecutableBlockComponentOutput(newSchemaParameter);
                        } else if (childElement.getNodeName().equals(SchemaDesignParameterType.OBJECTIVE_VARIABLE.getName()) || childElement.getNodeName().equals(SchemaDesignParameterType.CONSTRAINT_VARIABLE.getName())) {
                            String hackedParameter = childElement.getTextContent().trim();
                            if (hackedParameter.contains(SchemaDesignParameterType.CONSISTENCY_CONSTRAINT_VARIABLE.getName())) {
                                hackedParameter = hackedParameter.substring(hackedParameter.indexOf(47));
                            }
                            SchemaParameterImpl newSchemaParameter = this.parameterFactory.getOrCreateSchemaParameterImpl(hackedParameter, SchemaDesignParameterType.valueOf(childElement.getNodeName()));
                            component.addExecutableBlockComponentInput(newSchemaParameter);
                        }
                    }
                    ++i;
                }
                break;
            }
            case DOE: {
                if (elt.getNodeName().equals("settings")) {
                    HashMap<String, String> doeSettings = new HashMap<String, String>();
                    int i = 0;
                    while (i < children.getLength()) {
                        Node node = children.item(i);
                        if (node.getNodeType() == 1) {
                            Element childElement = (Element)node;
                            if ("doeTable".equals(childElement.getNodeName())) {
                                doeSettings.put("table", this.parseDoeTable(childElement));
                            } else {
                                doeSettings.put(childElement.getNodeName(), childElement.getTextContent());
                            }
                        }
                        ++i;
                    }
                    component.addMetaDatum("settings", doeSettings);
                    break;
                }
                component.addExecutableBlockComponentOutput(this.parameterFactory.getOrCreateSchemaParameterImpl(elt.getTextContent(), SchemaDesignParameterType.DEFAULT));
                break;
            }
        }
    }

    private void parseOptimizerSettings(Element settings, ExecutableBlockComponentImpl component) throws SchemaParsingException {
        Element convergenceTolerance;
        Element constraintTolerance;
        Element maximumFunctionEvaluations;
        Element applyScaling;
        Element algorithm;
        Element maximumIterations = this.getChildOrNullByTagName(settings, "maximumIterations");
        if (maximumIterations != null) {
            component.addMetaDatum("maximum_iterations", maximumIterations.getTextContent());
        }
        if ((algorithm = this.getChildOrNullByTagName(settings, "algorithm")) != null) {
            component.addMetaDatum("algorithm", algorithm.getTextContent());
        }
        if ((applyScaling = this.getChildOrNullByTagName(settings, "applyScaling")) != null) {
            component.addMetaDatum("apply_scaling", applyScaling.getTextContent());
        }
        if ((maximumFunctionEvaluations = this.getChildOrNullByTagName(settings, "maximumFunctionEvaluations")) != null) {
            component.addMetaDatum("maximum_function_evaluations", maximumFunctionEvaluations.getTextContent());
        }
        if ((constraintTolerance = this.getChildOrNullByTagName(settings, "constraintTolerance")) != null) {
            component.addMetaDatum("constraint_tolerance", constraintTolerance.getTextContent());
        }
        if ((convergenceTolerance = this.getChildOrNullByTagName(settings, "convergenceTolerance")) != null) {
            component.addMetaDatum("convergence_tolerance", convergenceTolerance.getTextContent());
        }
    }

    private void parseConvergerSettings(Element settings, ExecutableBlockComponentImpl component) throws SchemaParsingException {
        Element convergenceToleranceAbsolute;
        Element convergenceToleranceRelative;
        Element maximumIterations;
        Element lastIterationsToConsider = this.getChildOrNullByTagName(settings, "lastIterationsToConsider");
        if (lastIterationsToConsider != null) {
            component.addMetaDatum("lastIterationsToConsider", lastIterationsToConsider.getTextContent());
        }
        if ((maximumIterations = this.getChildOrNullByTagName(settings, "maximumIterations")) != null) {
            component.addMetaDatum("maximumIterations", maximumIterations.getTextContent());
        }
        if ((convergenceToleranceRelative = this.getChildOrNullByTagName(settings, "convergenceToleranceRelative")) != null) {
            component.addMetaDatum("convergenceToleranceRelative", convergenceToleranceRelative.getTextContent());
        }
        if ((convergenceToleranceAbsolute = this.getChildOrNullByTagName(settings, "convergenceToleranceAbsolute")) != null) {
            component.addMetaDatum("convergenceToleranceAbsolute", convergenceToleranceAbsolute.getTextContent());
        }
    }

    private String parseDoeTable(Element doeElement) throws SchemaParsingException {
        HashMap<Object, Double[]> doeTable = new HashMap<Object, Double[]>();
        List<Element> tableRows = this.getChildrenByTagName(doeElement, "tableRow");
        for (Element tableRow : tableRows) {
            String relatedParameterUID = tableRow.getAttribute("relatedParameterUID");
            List<Element> tableElements = this.getChildrenByTagName(tableRow, "tableElement");
            Double[] values = new Double[tableElements.size()];
            for (Element tableElement : tableElements) {
                int index = Integer.parseInt(tableElement.getAttribute("experimentID"));
                if (index >= 0 && index < tableElements.size()) {
                    values[index] = Double.parseDouble(tableElement.getTextContent());
                    continue;
                }
                throw new SchemaParsingException("The DoE custom table contains an invalid experimentID.");
            }
            Double[] doubleArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Double value = doubleArray[n2];
                if (value == null) {
                    throw new SchemaParsingException(StringUtils.format((String)"The DoE custom table is missing values for paramter %s.", (Object[])new Object[]{relatedParameterUID}));
                }
                ++n2;
            }
            doeTable.put(relatedParameterUID, values);
        }
        int numExperiments = -1;
        for (Double[] values : doeTable.values()) {
            if (numExperiments == -1) {
                numExperiments = values.length;
                continue;
            }
            if (numExperiments == values.length) continue;
            throw new SchemaParsingException("The DoE custom table defines not the same number of experiments for each parameter!");
        }
        ArrayList sortedTableValues = new ArrayList(numExperiments);
        LinkedList parametersSorted = new LinkedList(doeTable.keySet());
        parametersSorted.sort(null);
        int i = 0;
        while (i < numExperiments) {
            ArrayList<Double> experimentValues = new ArrayList<Double>(parametersSorted.size());
            for (String parameter : parametersSorted) {
                experimentValues.add(((Double[])doeTable.get(parameter))[i]);
            }
            sortedTableValues.add(experimentValues);
            ++i;
        }
        try {
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            String jsonizedDoeTable = mapper.writeValueAsString(sortedTableValues);
            return jsonizedDoeTable;
        }
        catch (IOException iOException) {
            throw new SchemaParsingException("Unable to transform the DoE custom table into the necessary format.");
        }
    }

    private void createProblemFormulation(Element elt) {
        String content = elt.getTextContent();
        switch (elt.getNodeName()) {
            case "mdaoArchitecture": {
                this.problemFormulationBuilder = this.problemFormulationBuilder.mdaoArchitecture(content);
                break;
            }
            case "convergerType": {
                this.problemFormulationBuilder = this.problemFormulationBuilder.convergerType(content);
                break;
            }
            case "executableBlocksOrder": {
                String[] tempBlockOrder = content.split(",");
                String[] blockOrder = new String[tempBlockOrder.length];
                int i = 0;
                String[] stringArray = tempBlockOrder;
                int n = tempBlockOrder.length;
                int n2 = 0;
                while (n2 < n) {
                    String newBlock;
                    String block = stringArray[n2];
                    blockOrder[i] = newBlock = block.replace("'", "").replace("[", "").replace("]", "").trim();
                    ++i;
                    ++n2;
                }
                this.problemFormulationBuilder = this.problemFormulationBuilder.executableBlocksOrder(blockOrder);
                break;
            }
            case "allowUnconvergedCouplings": {
                this.problemFormulationBuilder = this.problemFormulationBuilder.allowUnconvergedCouplings(Boolean.parseBoolean(content));
                break;
            }
            case "doeMethod": {
                this.doeSettingsBuilder = this.doeSettingsBuilder.doeMethod(content);
                break;
            }
            case "doeRuns": {
                this.doeSettingsBuilder = this.doeSettingsBuilder.doeRuns(content);
                break;
            }
            case "doeSeed": {
                this.doeSettingsBuilder = this.doeSettingsBuilder.doeSeed(content);
                break;
            }
        }
    }

    private void createWorkflow(Element elt, CMDOWSDataModel model, List<Element> postProcessList) throws SchemaParsingException {
        this.processGraphElements(elt, model, postProcessList);
    }

    private void processGraphElements(Element elt, CMDOWSDataModel model, List<Element> postProcessList) throws SchemaParsingException {
        block15: {
            boolean doPostProcessing = false;
            if (!elt.hasChildNodes()) break block15;
            NodeList children = elt.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                block16: {
                    Node childNode = children.item(i);
                    if (childNode.getNodeType() != 1) break block16;
                    Element childElement = (Element)childNode;
                    switch (childElement.getNodeName()) {
                        case "dataGraph": {
                            doPostProcessing = !this.processGraphElements(childElement, model, true, DataGraphNode.class);
                            break;
                        }
                        case "processGraph": {
                            doPostProcessing = !this.processProcessGraphElements(childElement, model);
                            break;
                        }
                        case "problemDefinitionUID": {
                            model.setWorkflowName(String.valueOf(childElement.getTextContent()) + ".wf");
                            break;
                        }
                    }
                    if (doPostProcessing) {
                        postProcessList.add(childElement);
                    }
                }
                ++i;
            }
        }
    }

    private boolean processProcessGraphElements(Element elt, CMDOWSDataModel model) throws SchemaParsingException {
        boolean processingCompleted;
        block14: {
            processingCompleted = true;
            if (!elt.hasChildNodes()) break block14;
            NodeList children = elt.getChildNodes();
            int numChildren = children.getLength();
            int i = 0;
            while (i < numChildren) {
                block15: {
                    Node childNode = children.item(i);
                    if (childNode.getNodeType() != 1) break block15;
                    Element childElt = (Element)childNode;
                    switch (childElt.getNodeName()) {
                        case "edges": {
                            this.processGraphElements(childElt, model, true, ProcessGraphNode.class);
                            break;
                        }
                        case "nodes": {
                            if (!childElt.hasChildNodes()) break;
                            HashMap<String, Integer[]> posMap = new HashMap<String, Integer[]>();
                            this.extractDiagonalPosition(childElt, posMap);
                            processingCompleted = this.processPosNodes(posMap);
                            break;
                        }
                        case "metadata": {
                            if (!processingCompleted) break;
                            this.parseMetaData(childElt, model);
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        return processingCompleted;
    }

    private List<Element> getChildrenByTagName(Element parent, String tag) {
        LinkedList<Element> result = new LinkedList<Element>();
        NodeList childNodes = parent.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            if (child.getNodeType() == 1 && child.getNodeName() == tag) {
                result.add((Element)child);
            }
            ++i;
        }
        return result;
    }

    private Element getChildByTagName(Element parent, String tag) throws SchemaParsingException {
        List<Element> childNodes = this.getChildrenByTagName(parent, tag);
        if (childNodes.size() != 1) {
            throw new SchemaParsingException(StringUtils.format((String)"Expected a single child with tag %s for parent %s", (Object[])new Object[]{tag, parent.getNodeName()}));
        }
        return childNodes.get(0);
    }

    private Element getChildOrNullByTagName(Element parent, String tag) throws SchemaParsingException {
        List<Element> childNodes = this.getChildrenByTagName(parent, tag);
        if (childNodes.size() > 1) {
            throw new SchemaParsingException(StringUtils.format((String)"Expected a single child with tag %s for parent %s", (Object[])new Object[]{tag, parent.getNodeName()}));
        }
        if (childNodes.size() == 0) {
            return null;
        }
        return childNodes.get(0);
    }

    private void parseMetaData(Element metaDataNode, CMDOWSDataModel model) throws SchemaParsingException {
        Element loopNestingElement = this.getChildByTagName(metaDataNode, "loopNesting");
        Element loopElementsElement = this.getChildByTagName(loopNestingElement, "loopElements");
        this.parseLoopElements(loopElementsElement, 1, model);
    }

    private void setLoopForNodeAndAdaptLoop(ProcessGraphNode node, CMDOWSGraphLoop loop) {
        node.setLoop(loop);
        if (loop.getHighestBlockPosition() < node.getPosition()) {
            loop.setHighestBlockPosition(node.getPosition());
        }
    }

    private void parseLoopElements(Element loopElements, int loopLevel, CMDOWSDataModel model) throws SchemaParsingException {
        List<Element> loopElementList = this.getChildrenByTagName(loopElements, "loopElement");
        for (Element loopElement : loopElementList) {
            Element nestedLoopElements;
            String loopDriverNode = loopElement.getAttribute("relatedUID");
            ProcessGraphNode driverNode = this.graphNodeFactory.getOrCreateProcessGraphNode(loopDriverNode, null);
            int stepNo = driverNode.getStepNumber();
            int convNo = driverNode.getConvergerStepNumber();
            CMDOWSGraphLoop loop = new CMDOWSGraphLoop(stepNo, convNo, loopDriverNode);
            this.setLoopForNodeAndAdaptLoop(driverNode, loop);
            loop.setLoopLevel(loopLevel);
            model.addLoop(loop);
            Element functionElements = this.getChildOrNullByTagName(loopElement, "functionElements");
            if (functionElements != null) {
                List<Element> functionElementList = this.getChildrenByTagName(functionElements, "functionElement");
                for (Element functionElement : functionElementList) {
                    String nodeId = functionElement.getTextContent();
                    ProcessGraphNode node = this.graphNodeFactory.getOrCreateProcessGraphNode(nodeId, null);
                    this.setLoopForNodeAndAdaptLoop(node, loop);
                }
            }
            if ((nestedLoopElements = this.getChildOrNullByTagName(loopElement, "loopElements")) == null) continue;
            this.parseLoopElements(nestedLoopElements, loopLevel + 1, model);
        }
    }

    private boolean processPosNodes(Map<String, Integer[]> posMap) throws SchemaParsingException {
        for (Map.Entry<String, Integer[]> entry : posMap.entrySet()) {
            ProcessGraphNode node = this.graphNodeFactory.getOrCreateProcessGraphNode(entry.getKey(), null);
            if (node == null) {
                return false;
            }
            node.setDiagonalPosition(entry.getValue()[0]);
            node.setProcessStepNumber(entry.getValue()[1]);
            node.setConvergerStepNumber(entry.getValue()[2]);
        }
        return true;
    }

    private void extractDiagonalPosition(Element elt, Map<String, Integer[]> posMap) {
        String referenceUID = null;
        Integer pos = null;
        Integer procStep = null;
        Integer convStep = 0;
        int z = 0;
        while (z < elt.getChildNodes().getLength()) {
            Node c = elt.getChildNodes().item(z);
            if (c.getNodeType() == 1) {
                Element celt = (Element)c;
                if (celt.getNodeName().equals("diagonalPosition")) {
                    if (NumberUtils.isNumber((String)celt.getTextContent())) {
                        pos = Integer.parseInt(celt.getTextContent());
                    }
                } else if (celt.getNodeName().equals("processStepNumber")) {
                    if (NumberUtils.isNumber((String)celt.getTextContent())) {
                        procStep = Integer.parseInt(celt.getTextContent());
                    }
                } else if (celt.getNodeName().equals("convergerStepNumber")) {
                    if (NumberUtils.isNumber((String)celt.getTextContent())) {
                        convStep = Integer.parseInt(celt.getTextContent());
                    }
                } else if (celt.getNodeName().equals("referenceUID")) {
                    referenceUID = celt.getTextContent();
                } else {
                    this.extractDiagonalPosition(celt, posMap);
                }
            }
            ++z;
        }
        if (referenceUID != null && pos != null) {
            posMap.put(referenceUID, new Integer[]{pos, procStep, convStep});
        }
    }

    private boolean processGraphElements(Element elt, CMDOWSDataModel model, boolean continueWithRecursion, Class<? extends SchemaGraphNode<?>> clazz) throws SchemaParsingException {
        block34: {
            if (!continueWithRecursion) {
                return false;
            }
            if (!elt.hasChildNodes()) break block34;
            NodeList children = elt.getChildNodes();
            String fromUID = null;
            String toUID = null;
            int i = 0;
            while (i < children.getLength()) {
                block35: {
                    Node childNode = children.item(i);
                    if (childNode.getNodeType() != 1) break block35;
                    Element childElement = (Element)childNode;
                    String nodeName = childElement.getNodeName();
                    String content = childElement.getTextContent();
                    switch (nodeName) {
                        case "fromParameterUID": 
                        case "fromExecutableBlockUID": {
                            fromUID = content.trim();
                            break;
                        }
                        case "toExecutableBlockUID": 
                        case "toParameterUID": {
                            toUID = content.trim();
                            break;
                        }
                        default: {
                            continueWithRecursion = this.processGraphElements(childElement, model, continueWithRecursion, clazz);
                        }
                    }
                }
                ++i;
            }
            if (fromUID != null && toUID != null) {
                SchemaGraphNode<Object> fromNode;
                Object fromNodeContent = null;
                if (this.parameterFactory.isParameterUIDExistent(fromUID)) {
                    fromNodeContent = this.parameterFactory.getOrCreateSchemaParameterImpl(fromUID, SchemaDesignParameterType.DEFAULT);
                } else if (this.execBlockFactory.isExecBlockUIDExistent(fromUID)) {
                    fromNodeContent = this.execBlockFactory.getExecutableBlock(fromUID);
                }
                if (fromNodeContent == null) {
                    continueWithRecursion = false;
                    return continueWithRecursion;
                }
                if (clazz.equals(DataGraphNode.class)) {
                    model.addNodeToDataGraph(fromUID, this.graphNodeFactory.getOrCreateDataGraphNode(fromUID, fromNodeContent));
                } else if (clazz.equals(ProcessGraphNode.class)) {
                    ExecutableBlock block = null;
                    if (!(fromNodeContent instanceof ExecutableBlock)) {
                        throw new SchemaParsingException("Tried to add malicious node to process graph.");
                    }
                    block = (ExecutableBlock)fromNodeContent;
                    model.addNodeToProcessGraph(fromUID, this.graphNodeFactory.getOrCreateProcessGraphNode(fromUID, block));
                }
                Object toNodeContent = null;
                if (this.parameterFactory.isParameterUIDExistent(toUID)) {
                    toNodeContent = this.parameterFactory.getOrCreateSchemaParameterImpl(toUID, SchemaDesignParameterType.DEFAULT);
                } else if (this.execBlockFactory.isExecBlockUIDExistent(toUID)) {
                    toNodeContent = this.execBlockFactory.getExecutableBlock(toUID);
                }
                if (toNodeContent == null) {
                    continueWithRecursion = false;
                    return continueWithRecursion;
                }
                if (clazz.equals(DataGraphNode.class)) {
                    fromNode = this.graphNodeFactory.getOrCreateDataGraphNode(fromUID, fromNodeContent);
                    ((DataGraphNode)fromNode).addAdjacencyToNode(this.graphNodeFactory.getOrCreateDataGraphNode(toUID, toNodeContent));
                    this.graphNodeFactory.getOrCreateDataGraphNode(toUID, toNodeContent).addParentAdjacencyToNode((DataGraphNode)fromNode);
                } else if (clazz.equals(ProcessGraphNode.class)) {
                    fromNode = this.graphNodeFactory.getOrCreateProcessGraphNode(fromUID, (ExecutableBlock)fromNodeContent);
                    if (!(toNodeContent instanceof ExecutableBlock)) {
                        throw new SchemaParsingException("Tried to add malicious node to process graph.");
                    }
                    ((ProcessGraphNode)fromNode).addAdjacencyToNode(this.graphNodeFactory.getOrCreateProcessGraphNode(toUID, (ExecutableBlock)toNodeContent));
                    this.graphNodeFactory.getOrCreateProcessGraphNode(toUID, (ExecutableBlock)toNodeContent).addParentAdjacencyToNode((ProcessGraphNode)fromNode);
                } else {
                    throw new SchemaParsingException("Inconsisten graph schema.");
                }
                continueWithRecursion = true;
            }
        }
        return continueWithRecursion;
    }

    private void addNodeUIDToStatesAdditionalInformation(CMDOWSParsingState state, Element elt, String toplevelNode) {
        if (elt.getNodeName().equals(toplevelNode)) {
            state.addAdditionalInformation("uID", elt.getAttribute("uID"));
        }
    }

    private void createDesignCompetenceOrMathematicalFunction(Element root, CMDOWSParsingState state, ExecutableBlockType type) throws SchemaParsingException {
        String content = root.getTextContent().trim();
        String nodeName = root.getNodeName().trim();
        String uid = this.getUIDAttribute(root, state);
        ExecutableBlockComponentImpl execBlock = this.execBlockFactory.getOrCreateExecutableBlockComponentImpl(uid, type);
        switch (nodeName) {
            case "label": {
                execBlock.setName(content);
                break;
            }
            case "input": {
                SchemaParameter parameter = null;
                String equotationLabel = null;
                int i = 0;
                while (i < root.getChildNodes().getLength()) {
                    Node child = root.getChildNodes().item(i);
                    if (child.getNodeType() == 1) {
                        Element childElement = (Element)child;
                        if (childElement.getNodeName().trim().equals("parameterUID")) {
                            parameter = this.parameterFactory.getOrCreateSchemaParameterImpl(childElement.getTextContent().trim(), SchemaDesignParameterType.DEFAULT);
                        } else if (childElement.getNodeName().trim().equals("equationLabel")) {
                            equotationLabel = childElement.getTextContent().trim();
                        }
                    }
                    ++i;
                }
                execBlock.addExecutableBlockComponentInput((SchemaDesignParameter)parameter);
                if (parameter == null || equotationLabel == null) break;
                HashMap<String, String> equationLabel = (HashMap<String, String>)execBlock.getMetaData().get("equationLabel");
                if (equationLabel == null) {
                    equationLabel = new HashMap<String, String>();
                    execBlock.addMetaDatum("equationLabel", equationLabel);
                }
                equationLabel.put(parameter.getUID(), equotationLabel);
                break;
            }
            case "output": {
                SchemaParameterImpl outputParameter = null;
                HashMap<String, String> equationMap = new HashMap<String, String>();
                int i = 0;
                while (i < root.getChildNodes().getLength()) {
                    Node rootChild = root.getChildNodes().item(i);
                    if (rootChild.getNodeType() == 1 && ((Element)rootChild).getNodeName().equals("equationsUID")) {
                        equationMap.put("uID", rootChild.getFirstChild().getNodeValue());
                    }
                    if (rootChild.getNodeType() == 1 && ((Element)rootChild).getNodeName().equals("equations")) {
                        equationMap.put("uID", rootChild.getAttributes().getNamedItem("uID").getNodeValue());
                        int j = 0;
                        while (j < rootChild.getChildNodes().getLength()) {
                            Element childElement;
                            Node child = rootChild.getChildNodes().item(j);
                            if (child.getNodeType() == 1 && (childElement = (Element)child).getNodeName().equals("equation") && childElement.getAttribute("language") != null) {
                                equationMap.put(childElement.getAttribute("language"), childElement.getTextContent());
                            }
                            ++j;
                        }
                    } else if (rootChild.getNodeName().trim().equals("parameterUID")) {
                        outputParameter = this.parameterFactory.getOrCreateSchemaParameterImpl(rootChild.getTextContent().trim(), SchemaDesignParameterType.DEFAULT);
                    }
                    ++i;
                }
                if (outputParameter == null) break;
                outputParameter.addAdditionalInformationElement("equations", equationMap);
                execBlock.addExecutableBlockComponentOutput(outputParameter);
                break;
            }
            case "metadata": {
                this.createTopLevelMetaData(root, execBlock);
                break;
            }
            case "ID": {
                execBlock.setID(content);
                break;
            }
            case "version": {
                execBlock.setVersion(content);
                break;
            }
            case "functionType": {
                execBlock.addMetaDatum("functionType", (Object)MathematicalFunctionType.getEnum(content));
                break;
            }
        }
    }

    private void createTopLevelMetaData(Element root, ExecutableBlockComponentImpl competence) throws SchemaParsingException {
        if (root.hasChildNodes()) {
            NodeList children = root.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element childElement = (Element)child;
                    competence.addMetaDatum(childElement.getNodeName(), this.createMetaData(childElement));
                }
                ++i;
            }
        }
    }

    private Object createMetaData(Element root) throws SchemaParsingException {
        if (root.hasChildNodes()) {
            NodeList children = root.getChildNodes();
            HashMap<String, Object> map = new HashMap<String, Object>();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element childElement = (Element)child;
                    Object obj = this.createMetaData(childElement);
                    if (child.hasAttributes() && child.getAttributes().getNamedItem("uID") != null) {
                        map.put(child.getAttributes().getNamedItem("uID").getTextContent(), obj);
                    } else {
                        map.put(childElement.getNodeName(), obj);
                    }
                } else if (children.getLength() == 1) {
                    return child.getTextContent().trim();
                }
                ++i;
            }
            return map;
        }
        return null;
    }

    private void createParameters(Element root, CMDOWSParsingState state) throws SchemaParsingException {
        String content = root.getTextContent();
        String uid = this.getUIDAttribute(root, state);
        String nodeName = root.getNodeName();
        SchemaParameterImpl param = this.parameterFactory.getOrCreateSchemaParameterImpl(uid, SchemaDesignParameterType.DEFAULT);
        if (nodeName.equals("label") || nodeName.equals("name")) {
            param.setName(content);
        } else if (nodeName.equals("note")) {
            param.setNote(content);
        } else if (nodeName.equals("description")) {
            param.setDescription(content);
        }
    }

    private String getUIDAttribute(Element elt, CMDOWSParsingState state) throws SchemaParsingException {
        String nodeName = elt.getNodeName().trim();
        if (nodeName == null) {
            throw new SchemaParsingException(NODE_NAME_CANNOT_BE_NULL_MSG);
        }
        return (String)state.getAdditionalStateInformation("uID");
    }

    private void createHeader(Element root) throws SchemaParsingException {
        String content = root.getTextContent();
        switch (root.getNodeName()) {
            case "creator": {
                this.schemaHeaderBuilder = this.schemaHeaderBuilder.creator(content);
                break;
            }
            case "description": {
                this.schemaHeaderBuilder = this.schemaHeaderBuilder.description(content);
                break;
            }
            case "timestamp": {
                this.schemaHeaderBuilder = this.schemaHeaderBuilder.timestamp(content);
                break;
            }
            case "fileVersion": {
                this.schemaHeaderBuilder = this.schemaHeaderBuilder.fileVersion(this.getDoubleValueOfString(content));
                break;
            }
            case "cmdowsVersion": {
                this.schemaHeaderBuilder = this.schemaHeaderBuilder.schemaVersion(this.getDoubleValueOfString(content));
                break;
            }
            case "organization": {
                this.schemaHeaderBuilder = this.schemaHeaderBuilder.readOrganizations(root.getChildNodes());
                break;
            }
        }
    }

    private Double getDoubleValueOfString(String content) throws SchemaParsingException {
        if (NumberUtils.isNumber((String)content)) {
            return Double.parseDouble(content);
        }
        throw new SchemaParsingException("File version of the cmdows file is not a numeric value!");
    }
}

