/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.api;

import java.util.HashMap;
import java.util.Map;

public enum CMDOWSNodeType {
    DESIGN_COMPETENCE("designCompetence"),
    HEADER("header"),
    PARAMETER("parameter"),
    WORKFLOW("workflow"),
    ARCHITECTURE_ELEMENTS("architectureElements"),
    PROBLEM_ROLES("problemRoles"),
    PROBLEM_FORMULATION("problemFormulation"),
    MATHEMATICAL_FUNCTION("mathematicalFunction");

    private static final Map<String, CMDOWSNodeType> LOOK_UP_MAP;
    private final String name;

    static {
        LOOK_UP_MAP = new HashMap<String, CMDOWSNodeType>();
        CMDOWSNodeType[] cMDOWSNodeTypeArray = CMDOWSNodeType.values();
        int n = cMDOWSNodeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMDOWSNodeType type = cMDOWSNodeTypeArray[n2];
            LOOK_UP_MAP.put(type.getNodeName(), type);
            ++n2;
        }
    }

    private CMDOWSNodeType(String name) {
        this.name = name;
    }

    public String getNodeName() {
        return this.name;
    }

    public static CMDOWSNodeType getTypeByNodeName(String name) {
        return LOOK_UP_MAP.get(name);
    }
}

