/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.gui.wizard;

import de.rcenvironment.core.gui.workflow.editor.ProjectUsages;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.supplemental.cmdows.importer.api.SchemaParsingException;
import de.rcenvironment.supplemental.cmdows.importer.api.SchemaToWorkflowDescriptionParsingService;
import de.rcenvironment.supplemental.cmdows.importer.api.WorkflowDescriptionTranslatorService;
import de.rcenvironment.supplemental.cmdows.importer.gui.wizard.CMDOWSFileAndProjectSelectionPage;
import de.rcenvironment.supplemental.cmdows.importer.gui.wizard.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewCMDOWSImportWizard
extends Wizard {
    private static final String WF_EDITOR_ID = "de.rcenvironment.rce.gui.workflow.editor.WorkflowEditor";
    private static IStructuredSelection workbenchSelection;
    private CMDOWSFileAndProjectSelectionPage projectPage;
    private IFile newWorkflowFile;
    private String projectNameToSet;
    private String workspaceToFile = "";

    public NewCMDOWSImportWizard(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            NewCMDOWSImportWizard.setWorkbenchSelection((IStructuredSelection)selection);
        }
        this.setWindowTitle(Messages.wizardTitle);
        TrayDialog.setDialogHelpAvailable((boolean)true);
    }

    public boolean performFinish() {
        final String cmdowsFileLocation = this.projectPage.getCmdowsFileLocation();
        final String cpacsFileLocation = this.projectPage.getCPACSFileLocation();
        final String workflowName = this.projectPage.getWorkflowName();
        final ProjectUsages usage = this.projectPage.getUsage();
        final String projectName = this.projectPage.getProjectName();
        final String[] mailInformation = this.projectPage.getMailInformation();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewCMDOWSImportWizard.this.doFinish(cmdowsFileLocation, cpacsFileLocation, workflowName, projectName, usage, mailInformation, monitor);
                    }
                    catch (SchemaParsingException | CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            realException.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        this.openCreatedWorkflow();
        return true;
    }

    protected void doFinish(String cmdowsFileLocation, String cpacsFileLocation, String workflowName, String projectName, ProjectUsages projectUsage, String[] mailInformation, IProgressMonitor monitor) throws SchemaParsingException, CoreException {
        this.projectNameToSet = null;
        if ((NewCMDOWSImportWizard.getWorkbenchSelection() instanceof TreeSelection || NewCMDOWSImportWizard.getWorkbenchSelection() instanceof StructuredSelection) && NewCMDOWSImportWizard.getWorkbenchSelection() != null && !projectUsage.equals((Object)ProjectUsages.NEW)) {
            Object file;
            if (NewCMDOWSImportWizard.getWorkbenchSelection().getFirstElement() instanceof IProject) {
                this.projectNameToSet = ((IProject)NewCMDOWSImportWizard.getWorkbenchSelection().getFirstElement()).getName();
            } else if (NewCMDOWSImportWizard.getWorkbenchSelection().getFirstElement() instanceof IFile) {
                file = (IFile)NewCMDOWSImportWizard.getWorkbenchSelection().getFirstElement();
                this.projectNameToSet = file.getProject().getName();
            } else if (NewCMDOWSImportWizard.getWorkbenchSelection().getFirstElement() instanceof IFolder) {
                IFolder folder = (IFolder)NewCMDOWSImportWizard.getWorkbenchSelection().getFirstElement();
                this.projectNameToSet = folder.getProject().getName();
                this.workspaceToFile = String.valueOf(folder.getFullPath().toOSString().substring(this.projectNameToSet.length() + 2)) + File.separator;
            } else if (NewCMDOWSImportWizard.getWorkbenchSelection().getFirstElement() instanceof File) {
                file = (File)NewCMDOWSImportWizard.getWorkbenchSelection().getFirstElement();
                this.handleFileSelection((File)file);
            } else if (NewCMDOWSImportWizard.getWorkbenchSelection().getFirstElement() instanceof TreeSelection) {
                TreeSelection treeSelection = (TreeSelection)NewCMDOWSImportWizard.getWorkbenchSelection().getFirstElement();
                if (treeSelection.getFirstElement() instanceof File) {
                    File file2 = (File)treeSelection.getFirstElement();
                    this.handleFileSelection(file2);
                } else if (treeSelection.getFirstElement() instanceof IProject) {
                    this.projectNameToSet = ((IProject)treeSelection.getFirstElement()).getName();
                }
            }
        } else if (!projectName.isEmpty()) {
            this.projectNameToSet = projectName;
        }
        if (this.projectNameToSet == null) {
            projectUsage = ProjectUsages.NEW;
            this.projectNameToSet = projectName;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectNameToSet);
        if (projectUsage.equals((Object)ProjectUsages.NEW)) {
            project.create(monitor);
            project.open(monitor);
            monitor.worked(1);
        }
        SchemaToWorkflowDescriptionParsingService service = (SchemaToWorkflowDescriptionParsingService)ServiceRegistry.createAccessFor((Object)((Object)this)).getService(SchemaToWorkflowDescriptionParsingService.class);
        WorkflowDescriptionTranslatorService translatorService = (WorkflowDescriptionTranslatorService)ServiceRegistry.createAccessFor((Object)((Object)this)).getService(WorkflowDescriptionTranslatorService.class);
        String projectPath = new File(project.getLocationURI()).getAbsolutePath();
        service.parseSchemaToWorkflowFile(new File(cmdowsFileLocation), translatorService, String.valueOf(projectPath) + File.separator + this.workspaceToFile, workflowName, cpacsFileLocation, mailInformation);
        this.newWorkflowFile = workflowName.endsWith(".wf") ? project.getFile(String.valueOf(this.workspaceToFile) + File.separator + workflowName) : project.getFile(String.valueOf(this.workspaceToFile) + File.separator + workflowName + ".wf");
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    private void handleFileSelection(File file) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)file.getAbsolutePath());
        IFile ifile = workspace.getRoot().getFileForLocation(location);
        if (ifile != null) {
            this.projectNameToSet = ifile.getProject().getName();
            this.workspaceToFile = String.valueOf(ifile.getProjectRelativePath().toOSString()) + File.separator;
        }
    }

    public void addPages() {
        this.projectPage = new CMDOWSFileAndProjectSelectionPage(this, NewCMDOWSImportWizard.getWorkbenchSelection());
        this.addPage((IWizardPage)this.projectPage);
    }

    private void openCreatedWorkflow() {
        FileEditorInput editorInput = new FileEditorInput(this.newWorkflowFile);
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor(WF_EDITOR_ID);
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        try {
            activePage.openEditor((IEditorInput)editorInput, desc.getId());
        }
        catch (PartInitException e) {
            throw new RuntimeException(e);
        }
        IViewPart view = activePage.findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (view != null) {
            ((ISetSelectionTarget)view).selectReveal((ISelection)new StructuredSelection((Object)this.newWorkflowFile));
        }
    }

    public static void setWorkbenchSelection(IStructuredSelection workbenchSelection) {
        NewCMDOWSImportWizard.workbenchSelection = workbenchSelection;
    }

    public static IStructuredSelection getWorkbenchSelection() {
        return workbenchSelection;
    }
}

