/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.brics.execution.facade.impl;

import de.rcenvironment.components.brics.execution.call.impl.BricsCaller;
import de.rcenvironment.components.brics.execution.facade.impl.BricsDownloadUploadFacade;
import de.rcenvironment.components.brics.execution.facade.impl.BricsMultiTaskFacade;
import de.rcenvironment.components.brics.execution.facade.impl.BricsSingleTaskFacade;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class BricsFacadeImpl
implements BricsSingleTaskFacade,
BricsMultiTaskFacade,
BricsDownloadUploadFacade {
    private final BricsCaller bricsCaller;

    public BricsFacadeImpl(Map<String, String> env, ComponentLog log) {
        this.bricsCaller = this.createBricsCaller(env, log);
    }

    protected BricsCaller createBricsCaller(Map<String, String> env, ComponentLog log) {
        return new BricsCaller(env, log);
    }

    @Override
    public void execute(String jobName, String emailAddress, String emailMessage, File inputFilesDir, File resultFilesDir) throws IOException {
        String taskId = this.bricsCaller.callNew(jobName, emailAddress, emailMessage, inputFilesDir);
        if (taskId != null) {
            this.bricsCaller.callWait(taskId);
            this.bricsCaller.callEnd(taskId, resultFilesDir);
        }
    }

    @Override
    public void downloadInputFiles(String taskId, File inputFilesDir) throws IOException {
        this.bricsCaller.callDownloadfileAndUnzip(taskId, inputFilesDir);
    }

    @Override
    public void uploadResultFiles(String taskId, File resultFilesDir) throws IOException {
        this.bricsCaller.callZipAndUploadfile(taskId, resultFilesDir);
    }

    @Override
    public String init(String jobName, String emailAddress, String emailMessage) throws IOException {
        return this.bricsCaller.callMstart(jobName, emailAddress, emailMessage);
    }

    @Override
    public void execute(String taskId, File inputFilesDir, File resultFilesDir) throws IOException {
        this.bricsCaller.callMnext(taskId, inputFilesDir, resultFilesDir);
    }

    @Override
    public void end(String taskId) throws IOException {
        this.bricsCaller.callMend(taskId);
    }

    @Override
    public boolean downloadInputFiles(String taskId, int count, File inputFilesDir) throws IOException {
        return this.bricsCaller.callDownloadfileAndUnzip(taskId, count, inputFilesDir);
    }

    @Override
    public void wait(String taskId, int count) throws IOException {
        this.bricsCaller.callWait(taskId, count);
    }

    @Override
    public void uploadResultFiles(String taskId, int count, File resultFilesDir) throws IOException {
        this.bricsCaller.callZipAndUploadfile(taskId, count, resultFilesDir);
    }
}

