/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks;

import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.endpoint.api.ComponentEndpointModelFactory;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowBlockInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowEndpointInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.utils.CMDOWSWorkflowCreationUtils;
import de.rcenvironment.supplemental.cmdows.importer.model.CMDOWSContact;
import de.rcenvironment.supplemental.cmdows.importer.model.WorkflowSchemaModel;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockComponent;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.ProcessGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DesignCompetenceBlock
extends WorkflowBlockInformation {
    private static final Log LOGGER = LogFactory.getLog(DesignCompetenceBlock.class);
    private boolean remoteTool;

    public DesignCompetenceBlock(String nodeUID, boolean remotetool) {
        super(nodeUID);
        this.remoteTool = remotetool;
    }

    public static WorkflowBlockInformation createBlock(Map<String, ComponentInstallation> installations, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode, WorkflowSchemaModel model, String[] mailInformation) {
        Map<String, Object> executionInfo = DesignCompetenceBlock.getMetadataMap("executionInfo", processGraphNode);
        String version = ((ExecutableBlockComponent)processGraphNode.getValue().getNodeContent()).getVersion();
        if (version == null) {
            version = "1.0";
        }
        ComponentInstallation compInstallation = null;
        boolean remoteTool = false;
        compInstallation = installations.get("de.rcenvironment.integration.cpacs." + ((ExecutableBlockComponent)processGraphNode.getValue().getNodeContent()).getID());
        Map bricsInformation = null;
        if (executionInfo != null) {
            bricsInformation = (Map)executionInfo.get("remoteComponentInfo");
            if (compInstallation == null && bricsInformation != null && !bricsInformation.isEmpty()) {
                compInstallation = installations.get("de.rcenvironment.bricstask");
                version = "1.0";
                remoteTool = true;
            } else if (compInstallation == null) {
                LOGGER.error((Object)("Design Competence does not have all required information: " + processGraphNode.getKey()));
            }
        }
        DesignCompetenceBlock wbInfo = new DesignCompetenceBlock(processGraphNode.getKey(), remoteTool);
        WorkflowNode newDesignCompetence = null;
        if (compInstallation != null) {
            newDesignCompetence = CMDOWSWorkflowCreationUtils.createWorkflowNode(compInstallation, processGraphNode.getKey());
            wbInfo.extractBricsInformation(processGraphNode, bricsInformation, remoteTool, newDesignCompetence, mailInformation, model);
        } else {
            ComponentInstallation fakeInstallation = ComponentUtils.createPlaceholderComponentInstallation((String)("de.rcenvironment.integration.cpacs." + processGraphNode.getValue().getNodeContent().getBlockName()), (String)version, (String)processGraphNode.getKey(), null);
            newDesignCompetence = CMDOWSWorkflowCreationUtils.createWorkflowNode(fakeInstallation, processGraphNode.getKey());
            DesignCompetenceBlock.addStaticFileEndpoint("cpacs_in", DataType.FileReference, newDesignCompetence.getComponentDescription().getInputDescriptionsManager());
            DesignCompetenceBlock.addStaticFileEndpoint("cpacs_out", DataType.FileReference, newDesignCompetence.getComponentDescription().getOutputDescriptionsManager());
        }
        wbInfo.addWorkflowNode(newDesignCompetence);
        wbInfo.setMainNodeId(newDesignCompetence.getIdentifier());
        return wbInfo;
    }

    private static Map<String, Object> getMetadataMap(String name, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode) {
        Object infoRaw = ((ExecutableBlockComponent)processGraphNode.getValue().getNodeContent()).getMetaDatum(name);
        Map information = null;
        if (infoRaw instanceof Map) {
            information = (Map)infoRaw;
        }
        return information;
    }

    private void extractBricsInformation(Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode, Map<String, Object> bricsInfo, boolean bricsTool, WorkflowNode newDesignCompetence, String[] mailInformation, WorkflowSchemaModel model) {
        if (bricsTool) {
            try {
                newDesignCompetence.getConfigurationDescription().setConfigurationValue("select_brics_root_at_wf_start", String.valueOf("true"));
                Map bricsJobInfo = (Map)bricsInfo.get("jobSettings");
                newDesignCompetence.getConfigurationDescription().setConfigurationValue("task_mode_single", String.valueOf(((String)bricsJobInfo.get("singleOrMultiExecution")).equals("Single")));
                newDesignCompetence.getConfigurationDescription().setConfigurationValue("task_mode_multi", String.valueOf(((String)bricsJobInfo.get("singleOrMultiExecution")).equals("Multiple")));
                newDesignCompetence.getConfigurationDescription().setConfigurationValue("task_name_id", (String)bricsJobInfo.get("jobName"));
                newDesignCompetence.getConfigurationDescription().setConfigurationValue("teamsite_folder", (String)((Map)bricsInfo.get("dataExchangeSettings")).get("folder"));
                String remoteEngineerID = (String)((Map)bricsJobInfo.get("remoteEngineer")).get("contactUID");
                CMDOWSContact remoteEngineerContact = model.getSchemaHeader().getContacts().get(remoteEngineerID);
                newDesignCompetence.getConfigurationDescription().setConfigurationValue("mail_to", remoteEngineerContact.getEmail());
                newDesignCompetence.getConfigurationDescription().setConfigurationValue("mail_message", (String)bricsJobInfo.get("notificationMessage"));
                if (mailInformation != null) {
                    newDesignCompetence.getConfigurationDescription().setConfigurationValue("mail_sender", mailInformation[0]);
                    newDesignCompetence.getConfigurationDescription().setConfigurationValue("mail_smtp", mailInformation[1]);
                    newDesignCompetence.getConfigurationDescription().setConfigurationValue("mail_smtp_port", mailInformation[2]);
                }
            }
            catch (NullPointerException nullPointerException) {
                LOGGER.error((Object)StringUtils.format((String)"Brics Block %s could not be configured due to lack of information.", (Object[])new Object[]{processGraphNode.getKey()}));
            }
        }
    }

    @Override
    public void addMergerNodes(WorkflowSchemaModel schema, WorkflowBlockInformation blockInfo, Map<String, ComponentInstallation> installations) {
        ProcessGraphNode processGraphNode = (ProcessGraphNode)schema.getProcessGraph().get(blockInfo.getNodeUID());
        LinkedList<String> mainNodeEndpoints = new LinkedList<String>();
        List<SchemaGraphNode<ExecutableBlock>> parentNodeList = this.getParentsWithData(processGraphNode, schema);
        Set inputs = this.getWorkflowNode(this.mainNodeId).getInputDescriptionsManager().getEndpointDescriptions();
        if (parentNodeList.size() > 1) {
            this.mergerLinks = new String[parentNodeList.size() - 1];
            mainNodeEndpoints.add("CPACS");
        } else if (parentNodeList.size() == 1) {
            if (!inputs.isEmpty()) {
                mainNodeEndpoints.add(((EndpointDescription)inputs.iterator().next()).getName());
            }
        } else {
            HashSet<SchemaGraphNode<ExecutableBlock>> parentNodeSet;
            if (!inputs.isEmpty()) {
                mainNodeEndpoints.add(((EndpointDescription)inputs.iterator().next()).getName());
            }
            if ((parentNodeList = new LinkedList<SchemaGraphNode<ExecutableBlock>>(parentNodeSet = new HashSet<SchemaGraphNode<ExecutableBlock>>(processGraphNode.getParentNodeList()))).size() > 1) {
                this.mergerLinks = new String[parentNodeList.size() - 1];
            }
        }
        this.addInputMerger(installations, processGraphNode, parentNodeList, this.mergerLinks, this.getWorkflowNode(this.mainNodeId), mainNodeEndpoints);
    }

    @Override
    public void linkInternalNodes(WorkflowDescription wfDescription, WorkflowSchemaModel schema) {
        Set inputs = this.getWorkflowNode(this.mainNodeId).getInputDescriptionsManager().getEndpointDescriptions();
        LinkedList<String> endpoints = new LinkedList<String>();
        if (!inputs.isEmpty()) {
            endpoints.add(((EndpointDescription)inputs.iterator().next()).getName());
        }
        this.linkInternalMerger(this.mergerLinks, this.getWorkflowNode(this.getMainNodeId()), endpoints, wfDescription);
    }

    @Override
    public WorkflowEndpointInformation getCPACSOutputInformation(EndpointCharacter type) {
        Set outputs = this.getWorkflowNode(this.mainNodeId).getOutputDescriptionsManager().getEndpointDescriptions();
        if (!outputs.isEmpty()) {
            return new WorkflowEndpointInformation(this.getWorkflowNode(this.mainNodeId), ((EndpointDescription)outputs.iterator().next()).getName());
        }
        return null;
    }

    private static void addStaticFileEndpoint(String name, DataType dataType, EndpointDescriptionsManager manager) {
        HashMap<String, Object> description = new HashMap<String, Object>();
        description.put("name", name);
        description.put("defaultDataType", dataType.name());
        LinkedList<String> dataTypes = new LinkedList<String>();
        dataTypes.add(dataType.name());
        description.put("dataTypes", dataTypes);
        if (manager.getManagedEndpointType() == EndpointType.INPUT) {
            String[] inputHandlings = new String[]{EndpointDefinition.InputDatumHandling.Single.name()};
            description.put("defaultInputHandling", inputHandlings[0]);
            description.put("inputHandlingOptions", Arrays.asList(inputHandlings));
            String[] inputExecutionConstraints = new String[]{EndpointDefinition.InputExecutionContraint.Required.name()};
            description.put("defaultInputExecutionConstraint", inputExecutionConstraints[0]);
            description.put("inputExecutionConstraintOptions", Arrays.asList(inputExecutionConstraints));
            HashMap metaData = new HashMap();
            description.put("metaData", metaData);
        }
        EndpointDefinition endpointDef = ComponentEndpointModelFactory.createEndpointDefinition(description, (EndpointType)manager.getManagedEndpointType());
        EndpointDescription desc = new EndpointDescription(endpointDef, UUID.randomUUID().toString());
        manager.addStaticEndpointDescription(desc);
    }

    @Override
    public int[] getLabelColor() {
        if (this.remoteTool) {
            return new int[]{195, 226, 191};
        }
        return new int[]{170, 224, 250};
    }
}

