/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal.factory;

import de.rcenvironment.supplemental.cmdows.importer.api.SchemaParsingException;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.DataGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.ProcessGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import java.util.HashMap;
import java.util.Map;

public class SchemaGraphNodeFactory {
    private final Map<String, SchemaGraphNode<ExecutableBlock>> processGraphPool = new HashMap<String, SchemaGraphNode<ExecutableBlock>>();
    private final Map<String, SchemaGraphNode<Object>> dataGraphPool = new HashMap<String, SchemaGraphNode<Object>>();

    public DataGraphNode getOrCreateDataGraphNode(String uid, Object content) throws SchemaParsingException {
        DataGraphNode dataGraphNode = this.dataGraphPool.get(uid);
        uid = uid.trim();
        if (dataGraphNode == null) {
            if (content != null) {
                dataGraphNode = new DataGraphNode(uid, content);
                this.dataGraphPool.put(uid, dataGraphNode);
            } else {
                return null;
            }
        }
        return dataGraphNode;
    }

    public ProcessGraphNode getOrCreateProcessGraphNode(String uid, ExecutableBlock content) throws SchemaParsingException {
        ProcessGraphNode processGraphNode = this.processGraphPool.get(uid);
        uid = uid.trim();
        if (processGraphNode == null) {
            if (content == null) {
                return null;
            }
            processGraphNode = new ProcessGraphNode(uid, content);
            this.processGraphPool.put(uid, processGraphNode);
        }
        return processGraphNode;
    }

    public void clear() {
        this.processGraphPool.clear();
    }
}

