/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal;

import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowEndpointInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.utils.CMDOWSGraphLoop;
import de.rcenvironment.supplemental.cmdows.importer.internal.utils.CMDOWSWorkflowCreationUtils;
import de.rcenvironment.supplemental.cmdows.importer.model.WorkflowSchemaModel;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockComponent;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.ProcessGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameter;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WorkflowBlockInformation {
    protected Map<String, WorkflowEndpointInformation> endpointInputInformation = new HashMap<String, WorkflowEndpointInformation>();
    protected String nodeUID;
    protected boolean driver;
    protected Map<String, WorkflowNode> wfNodes = new HashMap<String, WorkflowNode>();
    protected String mainNodeId = null;
    protected CMDOWSGraphLoop loop;
    protected String[] mergerLinks = null;
    private List<SchemaGraphNode<ExecutableBlock>> parentsWithData;

    public WorkflowBlockInformation(String nodeUID) {
        this.nodeUID = nodeUID;
    }

    public void linkInternalNodes(WorkflowDescription wfDescription, WorkflowSchemaModel schema) {
    }

    public WorkflowEndpointInformation getCPACSOutputInformation(EndpointCharacter character) {
        return null;
    }

    public void addInputInformation(SchemaGraphNode<ExecutableBlock> schemaGraphNode, WorkflowNode node, String endpointName) {
        LinkedList<String> names = new LinkedList<String>();
        names.add(endpointName);
        this.addInputInformation(schemaGraphNode, node, names);
    }

    public void addInputInformation(SchemaGraphNode<ExecutableBlock> schemaGraphNode, WorkflowNode node, List<String> endpointNames) {
        if (schemaGraphNode != null) {
            this.endpointInputInformation.put(schemaGraphNode.getUID(), new WorkflowEndpointInformation(node, new LinkedList<String>(endpointNames)));
        } else {
            this.endpointInputInformation.put("uuidNotDefined", new WorkflowEndpointInformation(node, new LinkedList<String>(endpointNames)));
        }
    }

    public WorkflowEndpointInformation getCPACSInputInformation(String fromUID) {
        return this.endpointInputInformation.get(fromUID);
    }

    public void addMergerNodes(WorkflowSchemaModel schema, WorkflowBlockInformation blockInfo, Map<String, ComponentInstallation> installations) {
    }

    public WorkflowNode getWorkflowNode(String nodeID) {
        return this.wfNodes.get(nodeID);
    }

    public int setNodePositions(int absoluteStartPosition) {
        int mainNodePosition = absoluteStartPosition;
        if (this.mergerLinks != null) {
            this.positionLinkingMerger(mainNodePosition += 40, this.mergerLinks, -60);
        }
        this.wfNodes.get(this.mainNodeId).setLocation(mainNodePosition, mainNodePosition);
        return mainNodePosition + 81 + 54;
    }

    public int[] getLabelColor() {
        return new int[]{Color.GREEN.getRed(), Color.GREEN.getGreen(), Color.GREEN.getBlue()};
    }

    protected List<SchemaGraphNode<ExecutableBlock>> getParentsWithData(ProcessGraphNode processGraphNode, WorkflowSchemaModel schema) {
        if (this.parentsWithData == null) {
            List<SchemaGraphNode<ExecutableBlock>> completeParentNodeList = processGraphNode.getParentNodeList();
            HashSet<SchemaGraphNode<ExecutableBlock>> parentNodeList = new HashSet<SchemaGraphNode<ExecutableBlock>>();
            for (SchemaGraphNode<ExecutableBlock> parent : completeParentNodeList) {
                List<String> connectingParameter = this.getConnectingParameter(processGraphNode, schema.getProcessGraph().get(parent.getUID()), schema);
                if (connectingParameter.isEmpty() && ((ProcessGraphNode)parent).getConvergerStepNumber() == 0) continue;
                parentNodeList.add(parent);
            }
            this.parentsWithData = new LinkedList<SchemaGraphNode<ExecutableBlock>>(parentNodeList);
        }
        return this.parentsWithData;
    }

    protected void addInputMerger(Map<String, ComponentInstallation> installations, ProcessGraphNode processGraphNode, List<SchemaGraphNode<ExecutableBlock>> parents, String[] connectionMergerLinks, WorkflowNode mainInputNode, List<String> mainNodeEndpoints) {
        if (parents.size() > 1) {
            int i = 1;
            while (i < parents.size()) {
                String nameSuffix = String.valueOf(processGraphNode.getUID()) + "_" + parents.get(i).getUID();
                List<String> parameter = this.getDataOutputsToMerge(parents.get(i));
                WorkflowNode merger = CMDOWSWorkflowCreationUtils.createMergerNodeWithMergingScript(nameSuffix, installations, parameter);
                this.addWorkflowNode(merger);
                this.addInputInformation(parents.get(i), merger, "XML to integrate");
                connectionMergerLinks[i - 1] = merger.getIdentifier();
                ++i;
            }
            this.addInputInformation(parents.get(0), this.getWorkflowNode(connectionMergerLinks[0]), "XML");
        } else if (parents.size() == 1) {
            this.addInputInformation(parents.get(0), mainInputNode, mainNodeEndpoints);
        } else if (parents.isEmpty()) {
            this.addInputInformation(null, mainInputNode, mainNodeEndpoints);
        }
    }

    protected List<String> getDataOutputsToMerge(SchemaGraphNode<ExecutableBlock> fromNode) {
        LinkedList<String> result = new LinkedList<String>();
        Iterator<SchemaDesignParameter> iterator = ((ExecutableBlockComponent)fromNode.getNodeContent()).getExecutableBlockComponentOutputs().iterator();
        while (iterator.hasNext()) {
            SchemaDesignParameter parameter;
            SchemaDesignParameter parameterToAdd = parameter = iterator.next();
            while (parameterToAdd.getRelatedParameter() != null) {
                parameterToAdd = parameterToAdd.getRelatedParameter();
            }
            if (result.contains(parameterToAdd.getUID())) continue;
            result.add(parameterToAdd.getUID());
        }
        return result;
    }

    protected List<String> getConnectingParameter(ProcessGraphNode processGraphNode, SchemaGraphNode<ExecutableBlock> fromNode, WorkflowSchemaModel schema) {
        LinkedList<String> result = new LinkedList<String>();
        List<SchemaGraphNode<Object>> parameterList = schema.getDataGraph().get(processGraphNode.getUID()).getParentNodeList();
        for (SchemaGraphNode<Object> parameter : parameterList) {
            for (SchemaGraphNode<Object> parameterParent : parameter.getParentNodeList()) {
                if (!parameterParent.getUID().equals(fromNode.getUID())) continue;
                SchemaDesignParameter para = (SchemaDesignParameter)parameter.getNodeContent();
                result.add(para.getUID());
            }
        }
        return result;
    }

    protected void linkInternalMerger(String[] connectionMergerLinks, WorkflowNode firstInternalPoint, List<String> firstInternalNodeEndpoints, WorkflowDescription wfDescription) {
        if (connectionMergerLinks != null) {
            int i = 0;
            while (i < connectionMergerLinks.length - 1) {
                WorkflowNode fromNode = this.getWorkflowNode(connectionMergerLinks[i]);
                WorkflowNode toNode = this.getWorkflowNode(connectionMergerLinks[i + 1]);
                wfDescription.addConnection(new Connection(fromNode, fromNode.getOutputDescriptionsManager().getEndpointDescription("XML"), toNode, toNode.getInputDescriptionsManager().getEndpointDescription("XML")));
                ++i;
            }
            WorkflowNode fromLastMerger = this.getWorkflowNode(connectionMergerLinks[connectionMergerLinks.length - 1]);
            WorkflowNode toMainNode = firstInternalPoint;
            for (String endpoint : firstInternalNodeEndpoints) {
                wfDescription.addConnection(new Connection(fromLastMerger, fromLastMerger.getOutputDescriptionsManager().getEndpointDescription("XML"), toMainNode, toMainNode.getInputDescriptionsManager().getEndpointDescription(endpoint)));
            }
        }
    }

    protected void positionLinkingMerger(int mainNodePosition, String[] links, int yOffset) {
        int range = links.length * 81 * 3 / 4 - 20;
        int startPoint = mainNodePosition + 40 - range / 2;
        int i = 0;
        while (i < links.length) {
            this.getWorkflowNode(links[i]).setLocation(startPoint + i * 81 * 3 / 4, mainNodePosition + yOffset);
            ++i;
        }
    }

    public void addWorkflowNode(WorkflowNode newNode) {
        this.wfNodes.put(newNode.getIdentifier(), newNode);
    }

    public Collection<WorkflowNode> getWorkflowNodes() {
        return this.wfNodes.values();
    }

    public void setLoop(CMDOWSGraphLoop loop) {
        this.loop = loop;
    }

    public CMDOWSGraphLoop getLoop() {
        return this.loop;
    }

    public void setDriver(boolean b) {
        this.driver = b;
    }

    public boolean isDriver() {
        return this.driver;
    }

    public String getMainNodeId() {
        return this.mainNodeId;
    }

    public void setMainNodeId(String mainNodeId) {
        this.mainNodeId = mainNodeId;
    }

    public String getNodeUID() {
        return this.nodeUID;
    }
}

