/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.brics.gui.impl;

import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractBricsSection
extends ValidatingWorkflowNodePropertySection {
    protected Text smtpPortText;
    protected Text hostText;
    protected Button useSSLButton;
    protected Button dontUseSMTPButton;
    private Text installDirPathText;
    private Button selectInstallDirButton;
    private Button selectAtWfStartButton;

    protected void setWorkflowNode(WorkflowNode workflowNode) {
        super.setWorkflowNode(workflowNode);
        Boolean selectAtWfStart = Boolean.valueOf(this.getConfiguration().getConfigurationDescription().getConfigurationValue("select_brics_root_at_wf_start"));
        this.enableWidgets(selectAtWfStart == false);
        if (this.dontUseSMTPButton != null) {
            if (this.getProperty("mail_smtp") == null) {
                this.dontUseSMTPButton.setSelection(false);
            } else {
                this.dontUseSMTPButton.setSelection(this.getProperty("mail_smtp").equals("no") && this.getProperty("mail_smtp_port").equals("0"));
            }
            this.hostText.setEnabled(!this.dontUseSMTPButton.getSelection());
            this.smtpPortText.setEnabled(!this.dontUseSMTPButton.getSelection());
        }
    }

    protected void createTaskSection(Composite parent, TabbedPropertySheetPage propSheetPage, boolean withTaskText) {
        Composite sectionComposite = this.createSectionComposite(parent, propSheetPage);
        Section taskSection = propSheetPage.getWidgetFactory().createSection(sectionComposite, 256);
        taskSection.setLayout((Layout)new GridLayout());
        taskSection.setLayoutData((Object)new GridData(772));
        taskSection.setText("Task");
        Composite taskComposite = propSheetPage.getWidgetFactory().createComposite(sectionComposite);
        taskComposite.setLayout((Layout)new GridLayout(2, false));
        taskComposite.setLayoutData((Object)new GridData(772));
        Button singleTaskButton = new Button(taskComposite, 16);
        singleTaskButton.setBackground(Display.getDefault().getSystemColor(1));
        singleTaskButton.setText("Single-task");
        singleTaskButton.setData("property.control", (Object)"task_mode_single");
        Button multiTaskButton = new Button(taskComposite, 16);
        multiTaskButton.setBackground(Display.getDefault().getSystemColor(1));
        multiTaskButton.setText("Multi-task");
        multiTaskButton.setData("property.control", (Object)"task_mode_multi");
        this.linkRadioButtons(singleTaskButton, multiTaskButton);
        this.linkRadioButtons(multiTaskButton, singleTaskButton);
        Composite taskNameComposite = propSheetPage.getWidgetFactory().createComposite(sectionComposite);
        taskNameComposite.setLayout((Layout)new GridLayout(2, false));
        taskNameComposite.setLayoutData((Object)new GridData(772));
        if (withTaskText) {
            this.createLabelAndText("Task name", "task_name_id", taskNameComposite);
        }
    }

    protected void createTeamsiteSection(Composite parent, TabbedPropertySheetPage propSheetPage) {
        Composite sectionComposite = this.createSectionComposite(parent, propSheetPage);
        Section teamsiteSection = propSheetPage.getWidgetFactory().createSection(sectionComposite, 256);
        teamsiteSection.setLayout((Layout)new GridLayout());
        teamsiteSection.setLayoutData((Object)new GridData(772));
        teamsiteSection.setText("SharePoint Team Site");
        Composite teamsiteComposite = propSheetPage.getWidgetFactory().createComposite(sectionComposite);
        teamsiteComposite.setLayout((Layout)new GridLayout(2, false));
        teamsiteComposite.setLayoutData((Object)new GridData(772));
        this.createLabelAndText("Address", "teamsite_url", teamsiteComposite);
        this.createLabelAndText("Folder", "teamsite_folder", teamsiteComposite);
    }

    protected void createMailSection(Composite parent, TabbedPropertySheetPage propSheetPage) {
        Composite sectionComposite = this.createSectionComposite(parent, propSheetPage);
        Section mailSection = propSheetPage.getWidgetFactory().createSection(sectionComposite, 256);
        mailSection.setLayout((Layout)new GridLayout());
        mailSection.setLayoutData((Object)new GridData(772));
        mailSection.setText("Email");
        Composite mailComposite = propSheetPage.getWidgetFactory().createComposite(sectionComposite);
        mailComposite.setLayout((Layout)new GridLayout(2, false));
        mailComposite.setLayoutData((Object)new GridData(772));
        this.createLabelAndText("To", "mail_to", mailComposite);
        Text messageText = this.createLabelAndText("Message", "mail_message", mailComposite);
        ((GridData)messageText.getLayoutData()).widthHint = 200;
        this.createLabelAndText("Sender", "mail_sender", mailComposite);
        new Label(mailComposite, 0);
        new Label(mailComposite, 0);
        this.hostText = this.createLabelAndText("SMTP host", "mail_smtp", mailComposite);
        this.smtpPortText = this.createLabelAndText("SMTP port", "mail_smtp_port", mailComposite);
        this.smtpPortText.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(this.smtpPortText, 18));
        this.useSSLButton = new Button(mailComposite, 32);
        GridData ssldata = new GridData();
        ssldata.horizontalSpan = 2;
        this.useSSLButton.setLayoutData((Object)ssldata);
        this.useSSLButton.setText("Use SSL");
        this.useSSLButton.setBackground(Display.getCurrent().getSystemColor(1));
        this.useSSLButton.setData("property.control", (Object)"use_ssl_for_mail");
        this.dontUseSMTPButton = new Button(mailComposite, 32);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.dontUseSMTPButton.setLayoutData((Object)data);
        this.dontUseSMTPButton.setText("Upload email as file to data server");
        this.dontUseSMTPButton.setBackground(Display.getCurrent().getSystemColor(1));
        this.dontUseSMTPButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                AbstractBricsSection.this.hostText.setEnabled(!AbstractBricsSection.this.dontUseSMTPButton.getSelection());
                AbstractBricsSection.this.smtpPortText.setEnabled(!AbstractBricsSection.this.dontUseSMTPButton.getSelection());
                AbstractBricsSection.this.useSSLButton.setEnabled(!AbstractBricsSection.this.dontUseSMTPButton.getSelection());
                if (AbstractBricsSection.this.dontUseSMTPButton.getSelection()) {
                    AbstractBricsSection.this.setProperty("mail_smtp", "no");
                    AbstractBricsSection.this.setProperty("mail_smtp_port", "0");
                    AbstractBricsSection.this.setProperty("mail_username", "");
                    AbstractBricsSection.this.setProperty("mail_passwd", "");
                } else {
                    AbstractBricsSection.this.setProperty("mail_smtp", "");
                    AbstractBricsSection.this.setProperty("mail_smtp_port", "");
                    AbstractBricsSection.this.setProperty("mail_username", "${mail_username}");
                    AbstractBricsSection.this.setProperty("mail_passwd", "${*.mail_passwd}");
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    protected void createInstallDirSection(final Composite parent, TabbedPropertySheetPage propSheetPage) {
        Composite sectionComposite = this.createSectionComposite(parent, propSheetPage);
        Section installDirSection = propSheetPage.getWidgetFactory().createSection(sectionComposite, 256);
        installDirSection.setLayout((Layout)new GridLayout());
        installDirSection.setLayoutData((Object)new GridData(772));
        installDirSection.setText("Installation Root Directory");
        Composite installDirComposite = propSheetPage.getWidgetFactory().createComposite(sectionComposite);
        installDirComposite.setLayout((Layout)new GridLayout(2, false));
        installDirComposite.setLayoutData((Object)new GridData(772));
        this.selectAtWfStartButton = new Button(installDirComposite, 32);
        this.selectAtWfStartButton.setText("Select at workflow start");
        this.selectAtWfStartButton.setBackground(installDirComposite.getDisplay().getSystemColor(1));
        this.selectAtWfStartButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractBricsSection.this.enableWidgets(!AbstractBricsSection.this.selectAtWfStartButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.selectAtWfStartButton.setData("property.control", (Object)"select_brics_root_at_wf_start");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.selectAtWfStartButton.setLayoutData((Object)gridData);
        this.installDirPathText = new Text(installDirComposite, 2116);
        this.installDirPathText.setData("property.control", (Object)"brics_root");
        this.installDirPathText.setLayoutData((Object)new GridData(768));
        this.selectInstallDirButton = new Button(installDirComposite, 8);
        this.selectInstallDirButton.setText("...");
        this.selectInstallDirButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 4096);
                dialog.setFilterPath(AbstractBricsSection.this.installDirPathText.getText().toString());
                String path = dialog.open();
                if (path != null) {
                    AbstractBricsSection.this.installDirPathText.setText(path);
                }
            }
        });
    }

    private void linkRadioButtons(final Button button1, final Button button2) {
        button1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                button2.setSelection(!button1.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
    }

    private Text createLabelAndText(String labelText, String propKey, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setBackground(Display.getDefault().getSystemColor(1));
        Text text = new Text(parent, 2116);
        GridData data = new GridData(768);
        text.setLayoutData((Object)data);
        text.setData("property.control", (Object)propKey);
        return text;
    }

    private void enableWidgets(boolean enabled) {
        this.installDirPathText.setEnabled(enabled);
        this.selectInstallDirButton.setEnabled(enabled);
    }

    private Composite createSectionComposite(Composite parent, TabbedPropertySheetPage propSheetPage) {
        Composite sectionComposite = propSheetPage.getWidgetFactory().createComposite(parent);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        sectionComposite.setLayout((Layout)gridLayout);
        sectionComposite.setLayoutData((Object)new GridData(1808));
        return sectionComposite;
    }
}

