/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.model;

import de.rcenvironment.supplemental.cmdows.importer.model.CMDOWSContact;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SchemaHeader {
    private String creator;
    private String description;
    private String timestamp;
    private Double fileVersion;
    private Double schemaVersion;
    private Map<String, CMDOWSContact> contacts;

    private SchemaHeader(SchemaHeaderBuilder builder) {
        this.creator = builder.creator;
        this.description = builder.description;
        this.timestamp = builder.timestamp;
        this.fileVersion = builder.fileVersion;
        this.schemaVersion = builder.schemaVersion;
        this.contacts = builder.contacts;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Double getFileVersion() {
        return this.fileVersion;
    }

    public Double getCmdowsVersion() {
        return this.schemaVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Creator: ");
        sb.append(this.creator);
        sb.append("\n");
        sb.append("Description: ");
        sb.append(this.description);
        sb.append("\n");
        sb.append("Timestamp: ");
        sb.append(this.timestamp);
        sb.append("\n");
        sb.append("File version: ");
        sb.append(this.fileVersion);
        sb.append("\n");
        sb.append("CMDOWS version: ");
        sb.append(this.schemaVersion);
        sb.append("\n");
        return sb.toString();
    }

    public Map<String, CMDOWSContact> getContacts() {
        return this.contacts;
    }

    /* synthetic */ SchemaHeader(SchemaHeaderBuilder schemaHeaderBuilder, SchemaHeader schemaHeader) {
        this(schemaHeaderBuilder);
    }

    public static class SchemaHeaderBuilder {
        private String creator;
        private String description;
        private String timestamp;
        private Double fileVersion;
        private Double schemaVersion;
        private Map<String, CMDOWSContact> contacts = new HashMap<String, CMDOWSContact>();

        public SchemaHeaderBuilder creator(String c) {
            this.creator = c;
            return this;
        }

        public SchemaHeaderBuilder description(String d) {
            this.description = d;
            return this;
        }

        public SchemaHeaderBuilder timestamp(String t) {
            this.timestamp = t;
            return this;
        }

        public SchemaHeaderBuilder fileVersion(Double v) {
            this.fileVersion = v;
            return this;
        }

        public SchemaHeaderBuilder schemaVersion(Double v) {
            this.schemaVersion = v;
            return this;
        }

        public SchemaHeader build() {
            return new SchemaHeader(this, null);
        }

        public SchemaHeaderBuilder readOrganizations(NodeList childNodes) {
            this.readChildren(childNodes);
            return this;
        }

        private void readChildren(NodeList childNodes) {
            int i = 0;
            while (i < childNodes.getLength()) {
                Node child = childNodes.item(i);
                if (child.getNodeName().equals("contacts")) {
                    this.readChildren(child.getChildNodes());
                }
                if (child.getNodeName().equals("contact")) {
                    this.readContact(child.getChildNodes(), child.getAttributes().getNamedItem("uID").getTextContent());
                }
                ++i;
            }
        }

        private void readContact(NodeList childNodes, String uID) {
            String email = "";
            String company = "";
            String name = "";
            int i = 0;
            while (i < childNodes.getLength()) {
                Node child = childNodes.item(i);
                if (child.getNodeName().equals("email")) {
                    email = child.getTextContent();
                }
                if (child.getNodeName().equals("company")) {
                    company = child.getTextContent();
                }
                if (child.getNodeName().equals("name")) {
                    name = child.getTextContent();
                }
                ++i;
            }
            CMDOWSContact newContact = new CMDOWSContact(uID, email, company, name);
            this.contacts.put(uID, newContact);
        }
    }
}

