/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks;

import de.rcenvironment.components.doe.gui.properties.DOEAddDynamicEndpointCommand;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowBlockInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowEndpointInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.utils.CMDOWSWorkflowCreationUtils;
import de.rcenvironment.supplemental.cmdows.importer.model.WorkflowSchemaModel;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockComponent;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.ProcessGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameter;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameterType;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;

public class DOEBlock
extends WorkflowBlockInformation {
    private static final Log LOGGER = LogFactory.getLog(DOEBlock.class);
    private WorkflowNode doeNode = null;
    private WorkflowNode selfLoopOutputMerger;
    private String[] outerLoopMergerLinks;
    private String[] selfLoopMergerLinks;

    public DOEBlock(String nodeUID) {
        super(nodeUID);
    }

    public static WorkflowBlockInformation createBlock(Map<String, ComponentInstallation> installations, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode, WorkflowSchemaModel model) {
        DOEBlock blockInfo = new DOEBlock(processGraphNode.getKey());
        WorkflowNode newDOE = CMDOWSWorkflowCreationUtils.createWorkflowNode(installations.get("de.rcenvironment.doe.v2"), processGraphNode.getKey());
        blockInfo.addWorkflowNode(newDOE);
        blockInfo.setMainNodeId(newDOE.getIdentifier());
        blockInfo.doeNode = newDOE;
        blockInfo.createInternalMerger(installations, processGraphNode);
        List<SchemaGraphNode<Object>> allOutputs = model.getDataGraph().get(processGraphNode.getKey()).getAdjacencyList();
        for (SchemaGraphNode<Object> output : allOutputs) {
            SchemaDesignParameter schemaDesignParameter = (SchemaDesignParameter)output.getNodeContent();
            SchemaDesignParameterType schemaDesignParameterType = schemaDesignParameter.getSchemaDesignParameterType();
            switch (schemaDesignParameterType) {
                case DEFAULT: {
                    DOEBlock.addDesignVariableToDOE((String)schemaDesignParameter.getAdditionalInformation().get("minimum"), (String)schemaDesignParameter.getAdditionalInformation().get("maximum"), newDOE, (SchemaDesignParameter)output.getNodeContent());
                    CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(blockInfo.selfLoopOutputMerger.getInputDescriptionsManager(), output.getUID(), schemaDesignParameter.getUID());
                    break;
                }
            }
        }
        DOEBlock.readDOETableValues(processGraphNode, newDOE);
        CMDOWSWorkflowCreationUtils.addForwardingCPACSEndpoints(newDOE, null);
        return blockInfo;
    }

    private static void readDOETableValues(Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode, WorkflowNode newDOE) {
        String runs;
        Map settings = (Map)((ExecutableBlockComponent)processGraphNode.getValue().getNodeContent()).getMetaDatum("settings");
        String method = (String)settings.get("doeMethod");
        ConfigurationDescription configurationDescription = newDOE.getComponentDescription().getConfigurationDescription();
        if ("Custom design table".equals(method)) {
            configurationDescription.setConfigurationValue("method", "Custom design table");
            String table = (String)settings.get("doeTable");
            String tableOrder = (String)settings.get("doeTableOrder");
            if (table != null && !table.isEmpty() && tableOrder != null && !tableOrder.isEmpty()) {
                try {
                    ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
                    List tableValues = (List)mapper.readValue(table, new ArrayList().getClass());
                    tableOrder = tableOrder.replaceAll("'", "\"");
                    List unsortedTableOrderList = (List)mapper.readValue(tableOrder, new ArrayList().getClass());
                    ArrayList sortedTableOrderList = new ArrayList(unsortedTableOrderList);
                    Collections.sort(sortedTableOrderList);
                    int[] indices = new int[sortedTableOrderList.size()];
                    int i = 0;
                    while (i < indices.length) {
                        indices[i] = DOEBlock.getPosition((String)sortedTableOrderList.get(i), unsortedTableOrderList);
                        ++i;
                    }
                    Double[][] sortedTableValues = new Double[tableValues.size()][((List)tableValues.get(0)).size()];
                    int row = 0;
                    while (row < tableValues.size()) {
                        int i2 = 0;
                        while (i2 < indices.length) {
                            sortedTableValues[row][i2] = (Double)((List)tableValues.get(row)).get(indices[i2]);
                            ++i2;
                        }
                        ++row;
                    }
                    configurationDescription.setConfigurationValue("table", mapper.writeValueAsString((Object)sortedTableValues));
                    configurationDescription.setConfigurationValue("endSample", String.valueOf(tableValues.size() - 1));
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Could not configure DOE properly: " + e.getMessage()));
                }
            } else {
                LOGGER.error((Object)"Could not configure DOE properly: Table or ordering missing.");
            }
        } else if ("Latin hypercube design".equals(method)) {
            configurationDescription.setConfigurationValue("method", "Latin hypercube design");
        }
        String seed = (String)settings.get("doeSeed");
        if (seed != null) {
            configurationDescription.setConfigurationValue("seedNumber", seed);
        }
        if ((runs = (String)settings.get("doeRuns")) != null) {
            configurationDescription.setConfigurationValue("runNumber", runs);
        }
    }

    private static int getPosition(String toSearch, List<String> unsortedTableOrderList) {
        int i = 0;
        while (i < unsortedTableOrderList.size()) {
            if (unsortedTableOrderList.get(i).equals(toSearch)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void createInternalMerger(Map<String, ComponentInstallation> installations, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode) {
        this.selfLoopOutputMerger = CMDOWSWorkflowCreationUtils.addMergerNodeWithDefaultScript(String.valueOf(processGraphNode.getKey()) + "_Self_Output", installations);
        this.addWorkflowNode(this.selfLoopOutputMerger);
    }

    @Override
    public void addMergerNodes(WorkflowSchemaModel schema, WorkflowBlockInformation blockInfo, Map<String, ComponentInstallation> installations) {
        ProcessGraphNode processGraphNode = (ProcessGraphNode)schema.getProcessGraph().get(blockInfo.getNodeUID());
        List<SchemaGraphNode<ExecutableBlock>> parentNodeList = processGraphNode.getParentNodeList();
        LinkedList<SchemaGraphNode<ExecutableBlock>> outerParents = new LinkedList<SchemaGraphNode<ExecutableBlock>>();
        LinkedList<SchemaGraphNode<ExecutableBlock>> selfParents = new LinkedList<SchemaGraphNode<ExecutableBlock>>();
        for (SchemaGraphNode<ExecutableBlock> parentNode : parentNodeList) {
            int parentProcessNumber = ((ProcessGraphNode)parentNode).getStepNumber();
            if (blockInfo.getLoop().getLoopStartProcessNumber() > parentProcessNumber) {
                outerParents.add(parentNode);
                continue;
            }
            selfParents.add(parentNode);
        }
        if (outerParents.size() > 1) {
            this.outerLoopMergerLinks = new String[outerParents.size() - 1];
        }
        if (selfParents.size() > 1) {
            this.selfLoopMergerLinks = new String[selfParents.size() - 1];
        }
        LinkedList<String> endpoints = new LinkedList<String>();
        endpoints.add("CPACS_start");
        this.addInputMerger(installations, processGraphNode, outerParents, this.outerLoopMergerLinks, this.doeNode, endpoints, schema);
        endpoints.clear();
        endpoints.add("CPACS");
        this.addInputMerger(installations, processGraphNode, selfParents, this.selfLoopMergerLinks, this.doeNode, endpoints, schema);
    }

    @Override
    public void linkInternalNodes(WorkflowDescription wfDescription, WorkflowSchemaModel schema) {
        CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.doeNode, "CPACS", this.selfLoopOutputMerger, "XML", wfDescription);
        CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.doeNode, "CPACS", this.selfLoopOutputMerger, "XML to integrate", wfDescription);
        for (EndpointDescription desc : this.selfLoopOutputMerger.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
            String name = desc.getName();
            if (this.doeNode.getOutputDescriptionsManager().getEndpointDescription(name) == null) continue;
            CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.doeNode, name, this.selfLoopOutputMerger, name, wfDescription);
            if (!name.contains("^c")) continue;
            String varName = name.substring(0, name.indexOf("^c"));
            CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.doeNode, name, this.selfLoopOutputMerger, varName, wfDescription);
        }
        LinkedList<String> endpointsOuter = new LinkedList<String>();
        endpointsOuter.add("CPACS_start");
        this.linkInternalMerger(this.outerLoopMergerLinks, this.doeNode, endpointsOuter, wfDescription);
        LinkedList<String> endpointsSelf = new LinkedList<String>();
        endpointsSelf.add("CPACS");
        this.linkInternalMerger(this.selfLoopMergerLinks, this.doeNode, endpointsSelf, wfDescription);
    }

    @Override
    public WorkflowEndpointInformation getCPACSOutputInformation(EndpointCharacter type) {
        if (type == EndpointCharacter.OUTER_LOOP) {
            return new WorkflowEndpointInformation(this.doeNode, "CPACS");
        }
        return new WorkflowEndpointInformation(this.selfLoopOutputMerger, "XML");
    }

    @Override
    public int setNodePositions(int absoluteStartPosition) {
        int doePosition = absoluteStartPosition;
        if (this.outerLoopMergerLinks != null) {
            doePosition += 40;
        }
        if (this.outerLoopMergerLinks != null) {
            this.positionLinkingMerger(doePosition, this.outerLoopMergerLinks, -162);
        }
        this.getWorkflowNode(this.mainNodeId).setLocation(doePosition, doePosition);
        this.selfLoopOutputMerger.setLocation(doePosition + 101, doePosition + 20);
        if (this.selfLoopMergerLinks != null) {
            this.positionLinkingMerger(doePosition, this.selfLoopMergerLinks, 101);
        }
        doePosition += 81;
        return doePosition += 94;
    }

    @Override
    public int[] getLabelColor() {
        return new int[]{Color.YELLOW.getRed(), Color.YELLOW.getGreen(), Color.YELLOW.getBlue()};
    }

    private static void addDesignVariableToDOE(String lower, String upper, WorkflowNode newDOE, SchemaDesignParameter output) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("hasStartValue", Boolean.toString(false));
        metaData.put("startValue", "-");
        metaData.put("lower", lower);
        metaData.put("upper", upper);
        DOEAddDynamicEndpointCommand command = new DOEAddDynamicEndpointCommand(EndpointType.OUTPUT, "default", output.getUID(), DataType.Float, metaData, new EndpointSelectionPane[0]);
        CMDOWSWorkflowCreationUtils.executeEndpointAddCommand(newDOE, (WorkflowNodeCommand)command);
    }
}

