/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal.factory;

import de.rcenvironment.supplemental.cmdows.importer.api.SchemaParsingException;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameter;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameterType;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaParameter;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaParameterImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SchemaParameterFactory {
    private final Map<String, SchemaParameter> pool = new HashMap<String, SchemaParameter>();
    private final Map<SchemaDesignParameterType, Set<SchemaDesignParameter>> typedPool = new HashMap<SchemaDesignParameterType, Set<SchemaDesignParameter>>();

    public SchemaParameterImpl getOrCreateSchemaParameterImpl(String uid, SchemaDesignParameterType type) throws SchemaParsingException {
        SchemaParameterImpl param = null;
        if (this.pool.containsKey(uid = uid.trim())) {
            param = (SchemaParameterImpl)this.pool.get(uid);
            if (!type.equals((Object)param.getSchemaDesignParameterType()) && param.getSchemaDesignParameterType().equals((Object)SchemaDesignParameterType.DEFAULT)) {
                param.setType(type);
                if (this.typedPool.containsKey((Object)type)) {
                    this.typedPool.get((Object)type).add(param);
                } else {
                    HashSet<SchemaParameterImpl> list = new HashSet<SchemaParameterImpl>();
                    list.add(param);
                    this.typedPool.put(type, list);
                }
            }
        } else {
            param = new SchemaParameterImpl(uid, type);
            this.pool.put(uid, param);
            if (!type.equals((Object)SchemaDesignParameterType.DEFAULT)) {
                if (this.typedPool.containsKey((Object)type)) {
                    this.typedPool.get((Object)type).add(param);
                } else {
                    HashSet<SchemaParameterImpl> list = new HashSet<SchemaParameterImpl>();
                    list.add(param);
                    this.typedPool.put(type, list);
                }
            }
        }
        return param;
    }

    public boolean isParameterUIDExistent(String uid) {
        return this.pool.containsKey(uid);
    }

    public Map<SchemaDesignParameterType, Set<SchemaDesignParameter>> getTypedParamMap() {
        return this.typedPool;
    }

    public void clear() {
        this.pool.clear();
    }
}

