/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.model.executableblock;

import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ExecutableBlockImpl
implements ExecutableBlock {
    private final String uid;
    private final ExecutableBlockType type;
    private final Map<String, Object> metaData;
    private final Map<String, Object> platformSpecifics;
    private String name;
    private Object settings;

    public ExecutableBlockImpl(String uid, ExecutableBlockType type) {
        this.uid = uid;
        this.type = type;
        this.metaData = new HashMap<String, Object>();
        this.platformSpecifics = new HashMap<String, Object>();
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getBlockName() {
        return this.name;
    }

    @Override
    public ExecutableBlockType getExecutableBlockType() {
        return this.type;
    }

    public void addMetaDatum(String key, Object metaDatum) {
        this.metaData.put(key, metaDatum);
    }

    public void addPlatformSpecific(String key, Object platformSpecific) {
        this.platformSpecifics.put(key, platformSpecific);
    }

    @Override
    public Object getPlatformSpecifics(String key) {
        return this.platformSpecifics.get(key);
    }

    @Override
    public Object getMetaDatum(String elementName) {
        return this.metaData.get(elementName);
    }

    public void setSettings(Object settings) {
        this.settings = settings;
    }

    @Override
    public Object getSettings() {
        return this.settings;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uid).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExecutableBlockImpl) {
            ExecutableBlockImpl other = (ExecutableBlockImpl)obj;
            return new EqualsBuilder().append((Object)this.uid, (Object)other.uid).isEquals();
        }
        return false;
    }

    @Override
    public Map<String, Object> getMetaData() {
        return new HashMap<String, Object>(this.metaData);
    }

    @Override
    public Map<String, Object> getPlatformSpecifics() {
        return new HashMap<String, Object>(this.platformSpecifics);
    }
}

