/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.brics.execution.call.impl;

import de.rcenvironment.core.component.execution.api.ComponentContext;
import java.util.HashMap;
import java.util.Map;

public final class BricsEnvironment {
    public static final Map<String, String> ENV = new HashMap<String, String>();
    public static final String VAR_BRICS_ROOT = "BRICS_ROOT";
    public static final String VAR_BRICS_JAR = "BRICS_JAR";
    public static final String VAR_BRICS_MAIN_CLASS = "BRICS_SCRIPTINTF";
    public static final String VAR_BRICS_LICENSE = "LICENSEFILEPATH";
    public static final String VAR_LOCAL_SCRATCH_DIR = "LOCALSCRATCHDIR";
    public static final String VAR_TEAMSITE_USERNAME = "UN";
    public static final String VAR_TEAMSITE_PASSWD = "PW";
    public static final String VAR_TEAMSITE_URL = "URLSITE";
    public static final String VAR_TEAMSITE_FOLDER = "FOLDER";
    public static final String VAR_MAIL_USERNAME = "SMTP_USERNAME";
    public static final String VAR_MAIL_PASSWD = "SMTP_PASSWORD";
    public static final String VAR_MAIL_SMTP = "SMTP";
    public static final String VAR_MAIL_SENDER = "SENDER";
    public static final String VAR_MAIL_FOLDER = "MAILFOLDER";
    public static final String VAR_MAIL_FOLDER_VALUE = "Shared%20Documents/bricsMail";

    static {
        ENV.put(VAR_BRICS_MAIN_CLASS, "nl/nlr/brics/scriptintf/ScriptIntf");
        ENV.put("BRICS_TEST_PERFORMER", "");
        ENV.put("POLLINGTIME", "5");
        ENV.put("SHAREDFILEPOLICY", "cleanup");
        ENV.put("SERVERMUTEX", "false");
        ENV.put("WEBSAUTHTYPE", "NTLM");
        ENV.put("DATASERVER", "SHPT4");
        ENV.put("CONTEXT", "AGILE");
        ENV.put(VAR_MAIL_FOLDER, VAR_MAIL_FOLDER_VALUE);
        String javaHome = String.valueOf(System.getProperties().getProperty("java.home")) + "/bin";
        ENV.put("JAVAPATH", javaHome);
        ENV.put("PATH", javaHome);
    }

    private BricsEnvironment() {
    }

    public static Map<String, String> createTaskEnvironment(ComponentContext compContext, String tempDir) {
        Map<String, String> env = BricsEnvironment.createBasicEnvironment(compContext, tempDir);
        String smtpHost = compContext.getConfigurationValue("mail_smtp");
        String smtpPort = compContext.getConfigurationValue("mail_smtp_port");
        if (smtpHost.equals("no") && smtpPort.equals("0")) {
            env.put(VAR_MAIL_SMTP, smtpHost);
            env.put(VAR_MAIL_FOLDER, VAR_MAIL_FOLDER_VALUE);
            env.remove(VAR_MAIL_USERNAME);
            env.remove(VAR_MAIL_PASSWD);
        } else {
            env.put(VAR_MAIL_SMTP, String.valueOf(smtpHost) + ":" + smtpPort);
            env.put(VAR_MAIL_USERNAME, compContext.getConfigurationValue("mail_username"));
            env.put(VAR_MAIL_PASSWD, compContext.getConfigurationValue("mail_passwd"));
        }
        env.put(VAR_MAIL_SENDER, compContext.getConfigurationValue("mail_sender"));
        return env;
    }

    public static Map<String, String> createDownloadUploadEnvironment(ComponentContext compContext, String tempDir) {
        return BricsEnvironment.createBasicEnvironment(compContext, tempDir);
    }

    private static Map<String, String> createBasicEnvironment(ComponentContext compContext, String tempDir) {
        HashMap<String, String> env = new HashMap<String, String>(ENV);
        String bricsRoot = BricsEnvironment.getBricsRoot(compContext);
        env.put(VAR_BRICS_ROOT, bricsRoot);
        env.put(VAR_BRICS_JAR, String.valueOf(bricsRoot) + "/dist/Brics.jar");
        env.put(VAR_BRICS_LICENSE, String.valueOf(bricsRoot) + "/dist");
        env.put(VAR_LOCAL_SCRATCH_DIR, tempDir);
        env.put(VAR_TEAMSITE_URL, compContext.getConfigurationValue("teamsite_url"));
        env.put(VAR_TEAMSITE_FOLDER, "Shared%20Documents/" + compContext.getConfigurationValue("teamsite_folder"));
        env.put(VAR_TEAMSITE_USERNAME, compContext.getConfigurationValue("teamsite_username"));
        env.put(VAR_TEAMSITE_PASSWD, compContext.getConfigurationValue("teamsite_passwd"));
        env.put(VAR_MAIL_SMTP, "");
        env.put(VAR_MAIL_USERNAME, "");
        env.put(VAR_MAIL_PASSWD, "");
        env.put(VAR_MAIL_SENDER, "");
        return env;
    }

    private static String getBricsRoot(ComponentContext compContext) {
        if (Boolean.valueOf(compContext.getConfigurationValue("select_brics_root_at_wf_start")).booleanValue()) {
            return compContext.getConfigurationValue("brics_root_wf_start");
        }
        return compContext.getConfigurationValue("brics_root");
    }
}

