/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.brics.execution.call.impl;

import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.executor.LocalApacheCommandLineExecutor;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BricsCaller {
    private static final String BACKSLASH_N = "\\n";
    private static final String EMPTY_STRING = "";
    private static final Log LOG = LogFactory.getLog(BricsCaller.class);
    private static TempFileService tempFileService = TempFileServiceAccess.getInstance();
    private final Map<String, String> env;
    private final ComponentLog compLog;
    private final String bricsBaseCommand;

    public BricsCaller(Map<String, String> env, ComponentLog compLog) {
        this.env = env;
        this.compLog = compLog;
        this.bricsBaseCommand = StringUtils.format((String)"java -cp \"%s\" %s", (Object[])new Object[]{env.get("BRICS_JAR"), env.get("BRICS_SCRIPTINTF")});
    }

    public String callNew(String jobName, String emailAddress, String emailMessage, File inputFilesDir) throws IOException {
        if (!inputFilesDir.exists() || !inputFilesDir.isDirectory()) {
            throw new IOException(StringUtils.format((String)"'%s' doesn't exist or is no directory", (Object[])new Object[]{inputFilesDir}));
        }
        LocalApacheCommandLineExecutor commandLineExecutor = this.createCommandLineExecutor();
        try {
            StringBuilder commandBuilder = new StringBuilder();
            commandBuilder.append(this.bricsBaseCommand);
            commandBuilder.append(StringUtils.format((String)" new -j\"%s\" -e\"%s\" -m\"%s\" ", (Object[])new Object[]{jobName, emailAddress, emailMessage}));
            File[] fileArray = inputFilesDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    LOG.warn((Object)StringUtils.format((String)"'%s' ignored for BRICS upload as it is a directory", (Object[])new Object[]{file}));
                } else {
                    FileUtils.copyFileToDirectory((File)file, (File)commandLineExecutor.getWorkDir());
                    commandBuilder.append(file.getName());
                    commandBuilder.append(" ");
                }
                ++n2;
            }
            String taskId = null;
            String stdOut = this.callBrics(commandLineExecutor, commandBuilder.toString());
            if (stdOut != null) {
                taskId = stdOut.replaceAll(System.lineSeparator(), EMPTY_STRING).replaceAll(BACKSLASH_N, EMPTY_STRING);
            }
            String string = taskId;
            return string;
        }
        finally {
            FileUtils.deleteQuietly((File)commandLineExecutor.getWorkDir());
        }
    }

    public void callEnd(String taskId, File resultFilesDir) throws IOException {
        LocalApacheCommandLineExecutor commandLineExecutor = this.createCommandLineExecutor();
        try {
            StringBuilder commandBuilder = new StringBuilder();
            commandBuilder.append(this.bricsBaseCommand);
            commandBuilder.append(StringUtils.format((String)" end \"%s\"", (Object[])new Object[]{taskId}));
            this.callBrics(commandLineExecutor, commandBuilder.toString());
            File[] fileArray = commandLineExecutor.getWorkDir().listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileUtils.copyFileToDirectory((File)file, (File)resultFilesDir);
                ++n2;
            }
        }
        finally {
            FileUtils.deleteQuietly((File)commandLineExecutor.getWorkDir());
        }
    }

    public void callDownloadfileAndUnzip(String taskId, File inputFilesDir) throws IOException {
        String zipFilename = StringUtils.format((String)"%s_inputs.zip", (Object[])new Object[]{taskId});
        this.callDownloadfileAndUnzipGivenFile(zipFilename, inputFilesDir);
    }

    public void callWait(String taskId) throws IOException {
        LocalApacheCommandLineExecutor commandLineExecutor = this.createCommandLineExecutor();
        try {
            StringBuilder commandBuilder = new StringBuilder();
            commandBuilder.append(this.bricsBaseCommand);
            commandBuilder.append(StringUtils.format((String)" wait \"%s\"", (Object[])new Object[]{taskId}));
            this.callBrics(commandLineExecutor, commandBuilder.toString());
        }
        finally {
            FileUtils.deleteQuietly((File)commandLineExecutor.getWorkDir());
        }
    }

    public void callZipAndUploadfile(String taskId, File resultFilesDir) throws IOException {
        String zipFilename = StringUtils.format((String)"%s_outputs.zip", (Object[])new Object[]{taskId});
        this.callZipAndUploadfileUnderGivenFile(zipFilename, resultFilesDir);
    }

    public String callMstart(String jobName, String emailAddress, String emailMessage) throws IOException {
        LocalApacheCommandLineExecutor commandLineExecutor = this.createCommandLineExecutor();
        try {
            StringBuilder commandBuilder = new StringBuilder();
            commandBuilder.append(this.bricsBaseCommand);
            commandBuilder.append(StringUtils.format((String)" mstart -j\"%s\" -e\"%s\" -m\"%s\" ", (Object[])new Object[]{jobName, emailAddress, emailMessage}));
            String taskId = null;
            String stdOut = this.callBrics(commandLineExecutor, commandBuilder.toString());
            if (stdOut != null) {
                taskId = stdOut.replaceAll(System.lineSeparator(), EMPTY_STRING).replaceAll(BACKSLASH_N, EMPTY_STRING);
            }
            String string = taskId;
            return string;
        }
        finally {
            FileUtils.deleteQuietly((File)commandLineExecutor.getWorkDir());
        }
    }

    public void callMnext(String taskId, File inputFilesDir, File resultFilesDir) throws IOException {
        LocalApacheCommandLineExecutor commandLineExecutor = this.createCommandLineExecutor();
        try {
            StringBuilder commandBuilder = new StringBuilder();
            commandBuilder.append(this.bricsBaseCommand);
            commandBuilder.append(StringUtils.format((String)" mnext -j\"%s\" ", (Object[])new Object[]{taskId}));
            File[] fileArray = inputFilesDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    LOG.warn((Object)StringUtils.format((String)"'%s' ignored for BRICS upload as it is a directory", (Object[])new Object[]{file}));
                } else {
                    FileUtils.copyFileToDirectory((File)file, (File)commandLineExecutor.getWorkDir());
                    commandBuilder.append(file.getName());
                    commandBuilder.append(" ");
                }
                ++n2;
            }
            String stdOut = this.callBrics(commandLineExecutor, commandBuilder.toString());
            if (stdOut != null) {
                String resultFileList = stdOut.trim().replaceAll(System.lineSeparator(), EMPTY_STRING).replaceAll(BACKSLASH_N, EMPTY_STRING);
                String[] stringArray = resultFileList.split(" ");
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray[n4];
                    FileUtils.copyFileToDirectory((File)new File(commandLineExecutor.getWorkDir(), fileName), (File)resultFilesDir);
                    ++n4;
                }
            }
        }
        finally {
            FileUtils.deleteQuietly((File)commandLineExecutor.getWorkDir());
        }
    }

    public void callMend(String taskId) throws IOException {
        LocalApacheCommandLineExecutor commandLineExecutor = this.createCommandLineExecutor();
        try {
            StringBuilder commandBuilder = new StringBuilder();
            commandBuilder.append(this.bricsBaseCommand);
            commandBuilder.append(StringUtils.format((String)" mend -j\"%s\"", (Object[])new Object[]{taskId}));
            this.callBrics(commandLineExecutor, commandBuilder.toString());
        }
        finally {
            FileUtils.deleteQuietly((File)commandLineExecutor.getWorkDir());
        }
    }

    public boolean callDownloadfileAndUnzip(String taskId, int count, File inputFilesDir) throws IOException {
        String zipFilename = StringUtils.format((String)"%s_%d_inputs.zip", (Object[])new Object[]{taskId, count});
        return this.callDownloadfileAndUnzipGivenFile(zipFilename, inputFilesDir);
    }

    public void callWait(String taskId, int count) throws IOException {
        LocalApacheCommandLineExecutor commandLineExecutor = this.createCommandLineExecutor();
        try {
            StringBuilder commandBuilder = new StringBuilder();
            commandBuilder.append(this.bricsBaseCommand);
            commandBuilder.append(StringUtils.format((String)" wait -f%s_%d_inputs.zip", (Object[])new Object[]{taskId, count}));
            this.callBrics(commandLineExecutor, commandBuilder.toString());
        }
        finally {
            FileUtils.deleteQuietly((File)commandLineExecutor.getWorkDir());
        }
    }

    public void callZipAndUploadfile(String taskId, int count, File resultFilesDir) throws IOException {
        String zipFilename = StringUtils.format((String)"%s_%d_outputs.zip", (Object[])new Object[]{taskId, count});
        this.callZipAndUploadfileUnderGivenFile(zipFilename, resultFilesDir);
    }

    private void callZipAndUploadfileUnderGivenFile(String zipFilename, File resultFilesDir) throws IOException {
        if (!resultFilesDir.exists() || !resultFilesDir.isDirectory()) {
            throw new IOException(StringUtils.format((String)"'%s' doesn't exist or is no directory", (Object[])new Object[]{resultFilesDir}));
        }
        LocalApacheCommandLineExecutor commandLineExecutor = this.createCommandLineExecutor();
        try {
            File zipFile = new File(commandLineExecutor.getWorkDir(), zipFilename);
            this.callZip(resultFilesDir, zipFile);
            StringBuilder commandBuilder = new StringBuilder();
            commandBuilder.append(this.bricsBaseCommand);
            commandBuilder.append(StringUtils.format((String)" uploadfile \"%s\"", (Object[])new Object[]{zipFile.getName()}));
            this.callBrics(commandLineExecutor, commandBuilder.toString());
        }
        finally {
            FileUtils.deleteQuietly((File)commandLineExecutor.getWorkDir());
        }
    }

    private boolean callDownloadfileAndUnzipGivenFile(String zipFilename, File inputFilesDir) throws IOException {
        LocalApacheCommandLineExecutor commandLineExecutor = this.createCommandLineExecutor();
        try {
            StringBuilder commandBuilder = new StringBuilder();
            commandBuilder.append(this.bricsBaseCommand);
            commandBuilder.append(StringUtils.format((String)" downloadfile \"%s\"", (Object[])new Object[]{zipFilename}));
            this.callBrics(commandLineExecutor, commandBuilder.toString());
            File zipFile = new File(commandLineExecutor.getWorkDir(), zipFilename);
            if (!zipFile.exists()) {
                throw new IOException(StringUtils.format((String)"Failed to download '%s' with BRICS", (Object[])new Object[]{zipFilename}));
            }
            if (FileUtils.sizeOf((File)zipFile) == 0L) {
                return false;
            }
            this.callUnzip(zipFile, inputFilesDir);
            return true;
        }
        finally {
            FileUtils.deleteQuietly((File)commandLineExecutor.getWorkDir());
        }
    }

    private void callZip(File sourceDir, File targetZipFile) throws IOException {
        String zipFilename = "new.zip";
        LocalApacheCommandLineExecutor commandLineExecutor = this.createCommandLineExecutor();
        try {
            StringBuilder commandBuilder = new StringBuilder();
            commandBuilder.append(this.bricsBaseCommand);
            commandBuilder.append(StringUtils.format((String)" -noconnect zip -f%s ", (Object[])new Object[]{zipFilename}));
            File[] fileArray = sourceDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    LOG.warn((Object)StringUtils.format((String)"'%s' ignored for BRICS zipping as it is a directory", (Object[])new Object[]{file}));
                } else {
                    FileUtils.copyFileToDirectory((File)file, (File)commandLineExecutor.getWorkDir());
                    commandBuilder.append(file.getName());
                    commandBuilder.append(" ");
                }
                ++n2;
            }
            this.callBrics(commandLineExecutor, commandBuilder.toString());
            File zipFile = new File(commandLineExecutor.getWorkDir(), zipFilename);
            if (!zipFile.exists()) {
                throw new IOException(StringUtils.format((String)"Failed to zip '%s' with BRICS", (Object[])new Object[]{sourceDir}));
            }
            FileUtils.copyFile((File)zipFile, (File)targetZipFile);
        }
        finally {
            FileUtils.deleteQuietly((File)commandLineExecutor.getWorkDir());
        }
    }

    private void callUnzip(File zipFile, File targetDir) throws IOException {
        LocalApacheCommandLineExecutor commandLineExecutor = this.createCommandLineExecutor();
        try {
            StringBuilder commandBuilder = new StringBuilder();
            commandBuilder.append(this.bricsBaseCommand);
            commandBuilder.append(StringUtils.format((String)" -noconnect unzip %s", (Object[])new Object[]{zipFile.getAbsolutePath()}));
            this.callBrics(commandLineExecutor, commandBuilder.toString());
            File[] fileArray = commandLineExecutor.getWorkDir().listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isDirectory()) {
                    FileUtils.copyFileToDirectory((File)file, (File)targetDir);
                }
                ++n2;
            }
        }
        finally {
            FileUtils.deleteQuietly((File)commandLineExecutor.getWorkDir());
        }
    }

    /*
     * Exception decompiling
     */
    private String callBrics(LocalApacheCommandLineExecutor commandLineExecutor, String command) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private LocalApacheCommandLineExecutor createCommandLineExecutor() throws IOException {
        LocalApacheCommandLineExecutor commandLineExecutor = new LocalApacheCommandLineExecutor(tempFileService.createManagedTempDir());
        for (Map.Entry<String, String> envEntry : this.env.entrySet()) {
            commandLineExecutor.setEnv(envEntry.getKey(), envEntry.getValue());
        }
        return commandLineExecutor;
    }
}

