/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.brics.gui.impl;

import de.rcenvironment.components.brics.common.api.BricsComponentHistoryDataItem;
import de.rcenvironment.core.component.datamanagement.api.DefaultComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.gui.datamanagement.browser.spi.CommonHistoryDataItemSubtreeBuilderUtils;
import de.rcenvironment.core.gui.datamanagement.browser.spi.ComponentHistoryDataItemSubtreeBuilder;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public abstract class AbstractBricsHistoryDataItemSubtreeBuilder
implements ComponentHistoryDataItemSubtreeBuilder {
    public Serializable deserializeHistoryDataItem(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        return (Serializable)ois.readObject();
    }

    public void buildInitialHistoryDataItemSubtree(Serializable historyDataItem, DMBrowserNode parentNode) {
        ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)this);
        TypedDatumSerializer serializer = ((TypedDatumService)registryAccess.getService(TypedDatumService.class)).getSerializer();
        if (historyDataItem instanceof String) {
            BricsComponentHistoryDataItem historyData;
            try {
                historyData = BricsComponentHistoryDataItem.fromString((String)((String)((Object)historyDataItem)), (TypedDatumSerializer)serializer, (String)"de.rcenvironment.bricstask");
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            CommonHistoryDataItemSubtreeBuilderUtils.buildDefaultHistoryDataItemSubtrees((DefaultComponentHistoryDataItem)historyData, (DMBrowserNode)parentNode);
            DMBrowserNode bricsNode = DMBrowserNode.addNewChildNode((String)"BRICS", (DMBrowserNodeType)DMBrowserNodeType.CommonText, (DMBrowserNode)parentNode);
            DMBrowserNode.addNewLeafNode((String)("Mode: " + this.getText(historyData.getTaskMode())), (DMBrowserNodeType)DMBrowserNodeType.CommonText, (DMBrowserNode)bricsNode);
            DMBrowserNode.addNewLeafNode((String)("Task: " + this.getText(historyData.getTaskNameId())), (DMBrowserNodeType)DMBrowserNodeType.CommonText, (DMBrowserNode)bricsNode);
            DMBrowserNode.addNewLeafNode((String)("Folder: " + this.getText(historyData.getTeamsiteFolder())), (DMBrowserNodeType)DMBrowserNodeType.CommonText, (DMBrowserNode)bricsNode);
            if (historyData.getRecipient() != null) {
                DMBrowserNode.addNewLeafNode((String)("To: " + this.getText(historyData.getRecipient())), (DMBrowserNodeType)DMBrowserNodeType.CommonText, (DMBrowserNode)bricsNode);
            }
        } else {
            String exceptionInformationText = historyDataItem != null ? StringUtils.format((String)"Parsing history data point failed: Expected type %s, but was of type %s", (Object[])new Object[]{String.class.getCanonicalName(), historyDataItem.getClass().getCanonicalName()}) : StringUtils.format((String)"Parsing history data point failed: Expected type %s, actual type not available.", (Object[])new Object[]{String.class.getCanonicalName()});
            throw new IllegalArgumentException(exceptionInformationText);
        }
    }

    private String getText(String text) {
        if (text == null) {
            return "-";
        }
        return text;
    }
}

