/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.gui.wizard;

import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.workflow.editor.ProjectSelectionPage;
import de.rcenvironment.core.gui.workflow.editor.ProjectUsages;
import de.rcenvironment.supplemental.cmdows.importer.gui.wizard.Messages;
import de.rcenvironment.supplemental.cmdows.importer.gui.wizard.NewCMDOWSImportWizard;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class CMDOWSFileAndProjectSelectionPage
extends ProjectSelectionPage {
    private static final String HELP_CONTEXT_ID = "de.rcenvironment.supplemental.cmdows.importer.gui.import_help";
    protected Text cmdowsFileLocation;
    protected Text cpacsFileLocation;
    protected Text workflowNameText;
    protected Button cpacsFileChooserButton;
    protected Button chooseCPACSButton;
    protected Button cmdowsFileChooserButton;
    protected Text senderText;
    protected Text smtpHostText;
    protected Text smtpPortText;
    protected Button provideMailConfigButton;

    public CMDOWSFileAndProjectSelectionPage(Wizard parentWizard, IStructuredSelection selection) {
        super(parentWizard, selection);
        this.setTitle(Messages.title);
        this.setDescription(Messages.description);
        this.workflowName = "";
    }

    public void createControl(Composite parent) {
        Composite cmdowsComp = new Composite(parent, 0);
        cmdowsComp.setLayout((Layout)new GridLayout(2, false));
        Label cmdowFileLabel = new Label(cmdowsComp, 0);
        cmdowFileLabel.setText(Messages.importText);
        GridData labelData = new GridData();
        labelData.horizontalSpan = 2;
        cmdowFileLabel.setLayoutData((Object)labelData);
        this.cmdowsFileLocation = new Text(cmdowsComp, 2048);
        this.cmdowsFileLocation.setLayoutData((Object)new GridData(768));
        this.cmdowsFileLocation.setEditable(false);
        this.cmdowsFileChooserButton = new Button(cmdowsComp, 8);
        this.cmdowsFileChooserButton.setText(Messages.dots);
        this.chooseCPACSButton = new Button(cmdowsComp, 32);
        GridData chooseCPACSButtonData = new GridData();
        chooseCPACSButtonData.horizontalSpan = 2;
        this.chooseCPACSButton.setLayoutData((Object)chooseCPACSButtonData);
        this.chooseCPACSButton.setText(Messages.cpacsInputFile);
        this.cpacsFileLocation = new Text(cmdowsComp, 2048);
        this.cpacsFileLocation.setLayoutData((Object)new GridData(768));
        this.cpacsFileLocation.setEditable(false);
        this.cpacsFileChooserButton = new Button(cmdowsComp, 8);
        this.cpacsFileChooserButton.setText(Messages.dots);
        this.cpacsFileLocation.setEnabled(false);
        this.cpacsFileChooserButton.setEnabled(false);
        Label workflowNameLabel = new Label(cmdowsComp, 0);
        workflowNameLabel.setText(Messages.workflowFileName);
        GridData wflabelData = new GridData();
        wflabelData.horizontalSpan = 2;
        workflowNameLabel.setLayoutData((Object)wflabelData);
        this.workflowNameText = new Text(cmdowsComp, 2048);
        GridData wfNameData = new GridData(768);
        wfNameData.horizontalSpan = 2;
        this.workflowNameText.setLayoutData((Object)wfNameData);
        Composite projectComp = new Composite(cmdowsComp, 0);
        GridLayout projectLayout = new GridLayout(1, false);
        projectLayout.horizontalSpacing = 0;
        projectLayout.marginWidth = 0;
        projectLayout.marginLeft = -5;
        projectComp.setLayout((Layout)projectLayout);
        GridData projectData = new GridData(0x1000000, 1024, true, true, 2, 1);
        projectComp.setLayoutData((Object)projectData);
        super.createControl(projectComp);
        this.setControl((Control)cmdowsComp);
        this.projectNameTextField.setText("");
        this.provideMailConfigButton = new Button(cmdowsComp, 32);
        GridData provideMailConfigButtonData = new GridData();
        provideMailConfigButtonData.horizontalSpan = 2;
        this.provideMailConfigButton.setLayoutData((Object)provideMailConfigButtonData);
        this.provideMailConfigButton.setText("Provide SMTP information for Brics components");
        this.senderText = this.addLabelAndText(cmdowsComp, "Sender: ");
        this.smtpHostText = this.addLabelAndText(cmdowsComp, "SMTP Host: ");
        this.smtpPortText = this.addLabelAndText(cmdowsComp, "SMTP Port: ");
        new Label(cmdowsComp, 0);
        new Label(cmdowsComp, 0);
        this.smtpPortText.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(this.smtpPortText, 2));
        Label noteLabel = new Label(cmdowsComp, 0);
        noteLabel.setForeground(Display.getCurrent().getSystemColor(3));
        noteLabel.setText("WARNING: Since the CMDOWS file is not yet in a stable version, this import of CMDOWS files\n may also not be stable. Some files might not be parsed correctly and produce an error, others\n may parse but have missing links or some logical issues.");
        this.addListener();
        this.validateWizard();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), HELP_CONTEXT_ID);
    }

    private Text addLabelAndText(Composite comp, String labelText) {
        Label label = new Label(comp, 0);
        GridData senderLabelData = new GridData();
        senderLabelData.horizontalSpan = 2;
        label.setLayoutData((Object)senderLabelData);
        label.setText(labelText);
        Text text = new Text(comp, 2048);
        GridData senderTextData = new GridData(768);
        senderTextData.horizontalSpan = 2;
        text.setLayoutData((Object)senderTextData);
        text.setEnabled(false);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CMDOWSFileAndProjectSelectionPage.this.validateWizard();
            }
        });
        return text;
    }

    private void addListener() {
        this.cmdowsFileChooserButton.addSelectionListener((SelectionListener)new CMDOWSImportFileChooserSelectionListener(this.cmdowsFileLocation, this.workflowNameText));
        this.cpacsFileChooserButton.addSelectionListener((SelectionListener)new CMDOWSImportFileChooserSelectionListener(this.cpacsFileLocation));
        this.chooseCPACSButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                CMDOWSFileAndProjectSelectionPage.this.cpacsFileLocation.setEnabled(CMDOWSFileAndProjectSelectionPage.this.chooseCPACSButton.getSelection());
                CMDOWSFileAndProjectSelectionPage.this.cpacsFileChooserButton.setEnabled(CMDOWSFileAndProjectSelectionPage.this.chooseCPACSButton.getSelection());
                CMDOWSFileAndProjectSelectionPage.this.validateWizard();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.workflowNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (!CMDOWSFileAndProjectSelectionPage.this.projectNameTextField.isEnabled()) {
                    CMDOWSFileAndProjectSelectionPage.this.projectNameTextField.setText(CMDOWSFileAndProjectSelectionPage.this.workflowNameText.getText());
                }
                CMDOWSFileAndProjectSelectionPage.this.validateWizard();
            }
        });
        this.projectNameTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (!CMDOWSFileAndProjectSelectionPage.this.projectNameTextField.isEnabled() && !CMDOWSFileAndProjectSelectionPage.this.projectNameTextField.getText().equals(CMDOWSFileAndProjectSelectionPage.this.workflowNameText.getText())) {
                    CMDOWSFileAndProjectSelectionPage.this.projectNameTextField.setText(CMDOWSFileAndProjectSelectionPage.this.workflowNameText.getText());
                }
                CMDOWSFileAndProjectSelectionPage.this.validateWizard();
            }
        });
        this.useDefaultNameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (CMDOWSFileAndProjectSelectionPage.this.useDefaultNameButton.getSelection()) {
                    CMDOWSFileAndProjectSelectionPage.this.projectNameTextField.setText(CMDOWSFileAndProjectSelectionPage.this.workflowNameText.getText());
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.projectTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewCMDOWSImportWizard.setWorkbenchSelection((IStructuredSelection)event.getSelection());
            }
        });
        this.provideMailConfigButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                CMDOWSFileAndProjectSelectionPage.this.senderText.setEnabled(CMDOWSFileAndProjectSelectionPage.this.provideMailConfigButton.getSelection());
                CMDOWSFileAndProjectSelectionPage.this.smtpHostText.setEnabled(CMDOWSFileAndProjectSelectionPage.this.provideMailConfigButton.getSelection());
                CMDOWSFileAndProjectSelectionPage.this.smtpPortText.setEnabled(CMDOWSFileAndProjectSelectionPage.this.provideMailConfigButton.getSelection());
                CMDOWSFileAndProjectSelectionPage.this.validateWizard();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    protected void validateWizard() {
        boolean allValid;
        String projectName;
        String cmdowsFilePath = this.cmdowsFileLocation.getText();
        boolean cmdowsFileValid = CMDOWSFileAndProjectSelectionPage.isValidFile(cmdowsFilePath);
        boolean cpacsValid = true;
        if (this.chooseCPACSButton.getSelection()) {
            String cpacsFilePath = this.cpacsFileLocation.getText();
            cpacsValid = CMDOWSFileAndProjectSelectionPage.isValidFile(cpacsFilePath);
        }
        boolean workflowNameValid = true;
        String wfName = this.workflowNameText.getText();
        if (wfName == null || wfName.isEmpty()) {
            workflowNameValid = false;
        }
        boolean projectValid = true;
        ProjectUsages usage = this.getUsage();
        if (usage == ProjectUsages.NEW && ((projectName = this.projectNameTextField.getText()) == null || projectName.isEmpty())) {
            projectValid = false;
        }
        boolean mailValid = true;
        if (this.provideMailConfigButton.getSelection()) {
            String sender = this.senderText.getText();
            mailValid = sender != null && !sender.isEmpty();
            String smtpHost = this.smtpHostText.getText();
            mailValid &= smtpHost != null && !smtpHost.isEmpty();
            String smtpPort = this.smtpPortText.getText();
            mailValid &= smtpPort != null && !smtpPort.isEmpty();
        }
        if (!mailValid) {
            this.setMessage("Mail configuration not valid", 3);
        }
        if (!projectValid) {
            this.setMessage(Messages.projectNameError, 3);
        }
        if (!workflowNameValid) {
            this.setMessage(Messages.workflowNameError, 3);
        }
        if (!cpacsValid) {
            this.setMessage(Messages.cpacsLocationError, 3);
        }
        if (!cmdowsFileValid) {
            this.setMessage(Messages.cmdowsLocationError, 3);
        }
        boolean bl = allValid = cmdowsFileValid && cpacsValid && workflowNameValid && projectValid && mailValid;
        if (allValid) {
            this.setMessage("");
        }
        this.setPageComplete(allValid);
    }

    private static boolean isValidFile(String filePath) {
        boolean valid = true;
        if (filePath == null || filePath.isEmpty()) {
            valid = false;
        } else {
            File cmdowsFile = new File(filePath);
            if (!cmdowsFile.exists() || !cmdowsFile.isFile()) {
                valid = false;
            }
        }
        return valid;
    }

    protected void dialogChanged() {
    }

    public void performHelp() {
        super.performHelp();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.displayHelp(HELP_CONTEXT_ID);
    }

    public String getCmdowsFileLocation() {
        return this.cmdowsFileLocation.getText();
    }

    public boolean getCPACSChosen() {
        return this.chooseCPACSButton.getSelection();
    }

    public String getCPACSFileLocation() {
        return this.cpacsFileLocation.getText();
    }

    public String getWorkflowName() {
        return this.workflowNameText.getText();
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    public String[] getMailInformation() {
        if (this.provideMailConfigButton.getSelection()) {
            return new String[]{this.senderText.getText(), this.smtpHostText.getText(), this.smtpPortText.getText()};
        }
        return null;
    }

    private class CMDOWSImportFileChooserSelectionListener
    implements SelectionListener {
        private Text locationText;
        private Text otherText;

        CMDOWSImportFileChooserSelectionListener(Text locationText) {
            this.locationText = locationText;
            this.otherText = null;
        }

        CMDOWSImportFileChooserSelectionListener(Text locationText, Text additionalText) {
            this.locationText = locationText;
            this.otherText = additionalText;
        }

        public void widgetSelected(SelectionEvent arg0) {
            FileDialog dialog = new FileDialog(CMDOWSFileAndProjectSelectionPage.this.getShell());
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String location = dialog.open();
            if (location != null) {
                this.locationText.setText(location);
                if (this.otherText != null) {
                    String fileName = new File(location).getName();
                    this.otherText.setText(FilenameUtils.getBaseName((String)fileName));
                }
            } else {
                this.locationText.setText("");
                if (this.otherText != null) {
                    this.otherText.setText("");
                }
            }
            CMDOWSFileAndProjectSelectionPage.this.validateWizard();
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }
    }
}

