/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks;

import de.rcenvironment.components.optimizer.gui.properties.commands.OptimizerAddDynamicEndpointCommand;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowBlockInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowDescriptionTranslatorConstants;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowEndpointInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.utils.CMDOWSWorkflowCreationUtils;
import de.rcenvironment.supplemental.cmdows.importer.model.WorkflowSchemaModel;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockComponent;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.DataGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.ProcessGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameter;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameterType;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OptimizerBlock
extends WorkflowBlockInformation {
    private WorkflowNode optimizer = null;
    private WorkflowNode outerLoopInputMerger = null;
    private WorkflowNode selfLoopOutputMerger = null;
    private WorkflowNode selfLoopInputMerger = null;
    private String[] outerLoopMergerLinks;
    private String[] selfLoopMergerLinks;

    public OptimizerBlock(String nodeUID) {
        super(nodeUID);
    }

    public static WorkflowBlockInformation createBlock(Map<String, ComponentInstallation> installations, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode, WorkflowSchemaModel model) {
        SchemaDesignParameterType schemaDesignParameterType;
        OptimizerBlock blockInfo = new OptimizerBlock(processGraphNode.getKey());
        WorkflowNode newOptimizer = CMDOWSWorkflowCreationUtils.createWorkflowNode(installations.get("de.rcenvironment.optimizer"), processGraphNode.getKey());
        blockInfo.addWorkflowNode(newOptimizer);
        blockInfo.optimizer = newOptimizer;
        blockInfo.setMainNodeId(newOptimizer.getIdentifier());
        blockInfo.createInternalMerger(installations, processGraphNode, model);
        List<SchemaGraphNode<Object>> allInputs = ((DataGraphNode)model.getDataGraph().get(processGraphNode.getKey())).getParentNodeList();
        for (SchemaGraphNode<Object> input : allInputs) {
            OptimizerAddDynamicEndpointCommand command = null;
            SchemaDesignParameter schemaDesignParameter = (SchemaDesignParameter)input.getNodeContent();
            schemaDesignParameterType = schemaDesignParameter.getSchemaDesignParameterType();
            String inputName = schemaDesignParameter.getUID();
            if (schemaDesignParameterType.equals((Object)SchemaDesignParameterType.DEFAULT) && OptimizerBlock.getOptimizerParameterType(input, processGraphNode) == SchemaDesignParameterType.OBJECTIVE_VARIABLE) {
                command = new OptimizerAddDynamicEndpointCommand(EndpointType.INPUT, inputName, "Objective", DataType.Float, new HashMap(), new Refreshable[0]);
                CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(blockInfo.selfLoopInputMerger.getOutputDescriptionsManager(), schemaDesignParameter.getUID(), inputName);
            } else if (schemaDesignParameterType.equals((Object)SchemaDesignParameterType.DEFAULT) && OptimizerBlock.getOptimizerParameterType(input, processGraphNode) == SchemaDesignParameterType.CONSTRAINT_VARIABLE) {
                SchemaDesignParameter constVar = null;
                for (SchemaDesignParameter para : model.getDesignParameter(SchemaDesignParameterType.CONSTRAINT_VARIABLE)) {
                    if (!para.getRelatedParameter().equals(schemaDesignParameter)) continue;
                    constVar = para;
                    break;
                }
                if (constVar != null) {
                    HashMap<String, String> metaData = new HashMap<String, String>();
                    String constraintType = (String)constVar.getAdditionalInformation().get("constraintType");
                    String constraintOperator = (String)constVar.getAdditionalInformation().get(WorkflowDescriptionTranslatorConstants.CONSTRAINT_OPERATOR);
                    String constraintValue = (String)constVar.getAdditionalInformation().get("referenceValue");
                    metaData.put("lower", String.valueOf(-1.7976931348623157E308));
                    metaData.put("upper", String.valueOf(Double.MAX_VALUE));
                    if ("inequality".equals(constraintType)) {
                        if (constraintOperator.contains("<")) {
                            metaData.put("upper", constraintValue);
                        } else if (constraintOperator.contains(">")) {
                            metaData.put("lower", constraintValue);
                        }
                    }
                    command = new OptimizerAddDynamicEndpointCommand(EndpointType.INPUT, inputName, "Constraint", DataType.Float, metaData, new Refreshable[0]);
                    CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(blockInfo.selfLoopInputMerger.getOutputDescriptionsManager(), schemaDesignParameter.getUID(), schemaDesignParameter.getUID());
                }
            } else if (schemaDesignParameterType.equals((Object)SchemaDesignParameterType.CONSISTENCY_CONSTRAINT_VARIABLE)) {
                HashMap<String, String> metaData = new HashMap<String, String>();
                metaData.put("lower", "0");
                metaData.put("upper", "0");
                command = new OptimizerAddDynamicEndpointCommand(EndpointType.INPUT, inputName, "Constraint", DataType.Float, metaData, new Refreshable[0]);
                CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(blockInfo.selfLoopInputMerger.getOutputDescriptionsManager(), schemaDesignParameter.getUID(), schemaDesignParameter.getUID());
            } else if (schemaDesignParameterType.equals((Object)SchemaDesignParameterType.INITIAL_GUESS_COUPLING_VARIABLE) || schemaDesignParameterType.equals((Object)SchemaDesignParameterType.INITIAL_GUESS_DESIGN_VARIABLE)) {
                CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(blockInfo.outerLoopInputMerger.getOutputDescriptionsManager(), schemaDesignParameter.getRelatedParameter().getUID(), schemaDesignParameter.getUID());
            }
            if (command == null) continue;
            CMDOWSWorkflowCreationUtils.executeEndpointAddCommand(newOptimizer, (WorkflowNodeCommand)command);
        }
        List<SchemaGraphNode<Object>> allOutputs = model.getDataGraph().get(processGraphNode.getKey()).getAdjacencyList();
        Set<SchemaDesignParameter> blockOutputs = ((ExecutableBlockComponent)processGraphNode.getValue().getNodeContent()).getExecutableBlockComponentOutputs();
        for (SchemaGraphNode<Object> output : allOutputs) {
            schemaDesignParameterType = ((SchemaDesignParameter)output.getNodeContent()).getSchemaDesignParameterType();
            switch (schemaDesignParameterType) {
                case DEFAULT: {
                    SchemaDesignParameter desVarToOutput = null;
                    for (SchemaDesignParameter blockOutput : blockOutputs) {
                        if (!blockOutput.getUID().contains(output.getUID())) continue;
                        desVarToOutput = blockOutput;
                    }
                    if (desVarToOutput == null) break;
                    blockInfo.addDesignVariableToOptimzier((String)desVarToOutput.getAdditionalInformation().get("lowerBound"), (String)desVarToOutput.getAdditionalInformation().get("upperBound"), newOptimizer, (SchemaDesignParameter)output.getNodeContent());
                    break;
                }
                case COUPLING_COPY_VARIABLE: {
                    blockInfo.addDesignVariableToOptimzier(String.valueOf(-1.7976931348623157E308), String.valueOf(Double.MAX_VALUE), newOptimizer, (SchemaDesignParameter)output.getNodeContent());
                    SchemaDesignParameter relatedParameter = ((SchemaDesignParameter)output.getNodeContent()).getRelatedParameter();
                    CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(blockInfo.selfLoopOutputMerger.getInputDescriptionsManager(), relatedParameter.getUID(), relatedParameter.getUID());
                    CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(blockInfo.selfLoopOutputMerger.getInputDescriptionsManager(), ((SchemaDesignParameter)output.getNodeContent()).getUID(), ((SchemaDesignParameter)output.getNodeContent()).getUID());
                    break;
                }
            }
        }
        CMDOWSWorkflowCreationUtils.addForwardingCPACSEndpoints(newOptimizer, "_optimal");
        newOptimizer.getConfigurationDescription().setConfigurationValue("optimizerPackageCode", "dakota");
        newOptimizer.getConfigurationDescription().setConfigurationValue("algorithm", "Dakota Coliny COBYLA (Constraint Optimization By Linear Approximations)");
        return blockInfo;
    }

    @Override
    public void addMergerNodes(WorkflowSchemaModel schema, WorkflowBlockInformation blockInfo, Map<String, ComponentInstallation> installations) {
        ProcessGraphNode processGraphNode = (ProcessGraphNode)schema.getProcessGraph().get(blockInfo.getNodeUID());
        List<SchemaGraphNode<ExecutableBlock>> parentNodeList = processGraphNode.getParentNodeList();
        LinkedList<SchemaGraphNode<ExecutableBlock>> outerParents = new LinkedList<SchemaGraphNode<ExecutableBlock>>();
        LinkedList<SchemaGraphNode<ExecutableBlock>> selfParents = new LinkedList<SchemaGraphNode<ExecutableBlock>>();
        for (SchemaGraphNode<ExecutableBlock> parentNode : parentNodeList) {
            int parentProcessNumber = ((ProcessGraphNode)parentNode).getStepNumber();
            if (blockInfo.getLoop().getLoopStartProcessNumber() > parentProcessNumber) {
                outerParents.add(parentNode);
                continue;
            }
            selfParents.add(parentNode);
        }
        LinkedList<String> endpoints = new LinkedList<String>();
        endpoints.add("XML");
        endpoints.add("XML to integrate");
        if (outerParents.size() > 1) {
            this.outerLoopMergerLinks = new String[outerParents.size() - 1];
        }
        this.addInputMerger(installations, processGraphNode, outerParents, this.outerLoopMergerLinks, this.outerLoopInputMerger, endpoints, schema);
        if (selfParents.size() > 1) {
            this.selfLoopMergerLinks = new String[selfParents.size() - 1];
        }
        this.addInputMerger(installations, processGraphNode, selfParents, this.selfLoopMergerLinks, this.selfLoopInputMerger, endpoints, schema);
    }

    @Override
    public void linkInternalNodes(WorkflowDescription wfDescription, WorkflowSchemaModel schema) {
        CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.outerLoopInputMerger, "XML", this.optimizer, "CPACS_start", wfDescription);
        CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.optimizer, "CPACS", this.selfLoopOutputMerger, "XML", wfDescription);
        CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.optimizer, "CPACS", this.selfLoopOutputMerger, "XML to integrate", wfDescription);
        CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.selfLoopInputMerger, "XML", this.optimizer, "CPACS", wfDescription);
        for (EndpointDescription desc : this.outerLoopInputMerger.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
            SchemaDesignParameter parameter = (SchemaDesignParameter)schema.getDataGraph().get(desc.getName()).getNodeContent();
            String nameInOptimizer = String.valueOf(parameter.getUID()) + " - start value";
            if (parameter.getRelatedParameter() != null) {
                nameInOptimizer = String.valueOf(parameter.getRelatedParameter().getUID()) + " - start value";
            }
            CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.outerLoopInputMerger, desc.getName(), this.optimizer, nameInOptimizer, wfDescription);
        }
        for (EndpointDescription desc : this.selfLoopInputMerger.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
            CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.selfLoopInputMerger, desc.getName(), this.optimizer, desc.getName(), wfDescription);
        }
        Set<SchemaDesignParameter> ccvs = schema.getDesignParameter(SchemaDesignParameterType.COUPLING_COPY_VARIABLE);
        for (EndpointDescription desc : this.selfLoopOutputMerger.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
            String name = desc.getName();
            SchemaDesignParameter isCCV = null;
            if (ccvs != null) {
                for (SchemaDesignParameter ccv : ccvs) {
                    if (!ccv.getUID().equals(name)) continue;
                    isCCV = ccv;
                }
            }
            if (this.optimizer.getOutputDescriptionsManager().getEndpointDescription(name) != null) {
                CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.optimizer, name, this.selfLoopOutputMerger, name, wfDescription);
                continue;
            }
            if (isCCV == null) continue;
            CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.optimizer, isCCV.getRelatedParameter().getUID(), this.selfLoopOutputMerger, name, wfDescription);
        }
        LinkedList<String> endpoints = new LinkedList<String>();
        endpoints.add("XML");
        endpoints.add("XML to integrate");
        this.linkInternalMerger(this.outerLoopMergerLinks, this.outerLoopInputMerger, endpoints, wfDescription);
        this.linkInternalMerger(this.selfLoopMergerLinks, this.selfLoopInputMerger, endpoints, wfDescription);
    }

    @Override
    public WorkflowEndpointInformation getCPACSOutputInformation(EndpointCharacter type) {
        if (type == EndpointCharacter.OUTER_LOOP) {
            return new WorkflowEndpointInformation(this.optimizer, "CPACS_optimal");
        }
        return new WorkflowEndpointInformation(this.selfLoopOutputMerger, "XML");
    }

    @Override
    public int setNodePositions(int absoluteStartPosition) {
        int optimizerPosition = absoluteStartPosition;
        if (this.outerLoopMergerLinks != null) {
            optimizerPosition += 40;
        }
        optimizerPosition += 40;
        if (this.outerLoopMergerLinks != null) {
            this.positionLinkingMerger(optimizerPosition, this.outerLoopMergerLinks, -162);
        }
        this.outerLoopInputMerger.setLocation(optimizerPosition + 20, optimizerPosition - 60);
        this.getWorkflowNode(this.mainNodeId).setLocation(optimizerPosition, optimizerPosition);
        this.selfLoopOutputMerger.setLocation(optimizerPosition + 101, optimizerPosition + 20);
        this.selfLoopInputMerger.setLocation(optimizerPosition + 20, optimizerPosition + 101);
        if (this.selfLoopMergerLinks != null) {
            this.positionLinkingMerger(optimizerPosition, this.selfLoopMergerLinks, 162);
            optimizerPosition += 81;
        }
        return optimizerPosition += 175;
    }

    @Override
    public int[] getLabelColor() {
        return new int[]{Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue()};
    }

    private void createInternalMerger(Map<String, ComponentInstallation> installations, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode, WorkflowSchemaModel schema) {
        Set<SchemaDesignParameter> ccv = schema.getDesignParameter(SchemaDesignParameterType.COUPLING_COPY_VARIABLE);
        HashMap<String, String> ccvToAdd = new HashMap<String, String>();
        if (ccv != null) {
            for (SchemaDesignParameter couplingCopyVariable : ccv) {
                ccvToAdd.put(couplingCopyVariable.getRelatedParameter().getUID(), couplingCopyVariable.getUID());
            }
        }
        this.outerLoopInputMerger = CMDOWSWorkflowCreationUtils.createMergerNodeWithMergingScript(String.valueOf(processGraphNode.getKey()) + "_Outer_Input", installations, ccvToAdd);
        this.selfLoopInputMerger = CMDOWSWorkflowCreationUtils.addMergerNodeWithDefaultScript(String.valueOf(processGraphNode.getKey()) + "_Self_Input", installations);
        this.selfLoopOutputMerger = CMDOWSWorkflowCreationUtils.addMergerNodeWithDefaultScript(String.valueOf(processGraphNode.getKey()) + "_Self_Output", installations);
        this.addWorkflowNode(this.outerLoopInputMerger);
        this.addWorkflowNode(this.selfLoopInputMerger);
        this.addWorkflowNode(this.selfLoopOutputMerger);
    }

    private static SchemaDesignParameterType getOptimizerParameterType(SchemaGraphNode<Object> input, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode) {
        ExecutableBlock block = processGraphNode.getValue().getNodeContent();
        if (block instanceof ExecutableBlockComponent) {
            ExecutableBlockComponent blockComponent = (ExecutableBlockComponent)block;
            for (SchemaDesignParameter para : blockComponent.getExecutableBlockComponentInputs()) {
                if (!para.getRelatedParameter().getUID().equals(input.getUID())) continue;
                return para.getSchemaDesignParameterType();
            }
        }
        return null;
    }

    private void addDesignVariableToOptimzier(String lower, String upper, WorkflowNode newOptimizer, SchemaDesignParameter output) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("hasStartValue", Boolean.toString(false));
        metaData.put("startValue", "-");
        metaData.put("lower", lower);
        metaData.put("upper", upper);
        if (output.getRelatedParameter() != null) {
            output = output.getRelatedParameter();
        }
        OptimizerAddDynamicEndpointCommand command = new OptimizerAddDynamicEndpointCommand(EndpointType.OUTPUT, output.getUID(), "Design", DataType.Float, metaData, new Refreshable[0]);
        CMDOWSWorkflowCreationUtils.executeEndpointAddCommand(newOptimizer, (WorkflowNodeCommand)command);
        CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(this.selfLoopOutputMerger.getInputDescriptionsManager(), output.getUID(), output.getUID());
    }
}

