/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal;

import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.xml.XMLException;
import de.rcenvironment.core.utils.common.xml.api.XMLSupportService;
import de.rcenvironment.supplemental.cmdows.importer.api.CMDOWSNodeType;
import de.rcenvironment.supplemental.cmdows.importer.api.CMDOWSParsingState;
import de.rcenvironment.supplemental.cmdows.importer.api.SchemaParsingException;
import de.rcenvironment.supplemental.cmdows.importer.api.SchemaToWorkflowDescriptionParsingService;
import de.rcenvironment.supplemental.cmdows.importer.api.WorkflowDescriptionTranslatorService;
import de.rcenvironment.supplemental.cmdows.importer.internal.factory.ExecutableBlockFactory;
import de.rcenvironment.supplemental.cmdows.importer.internal.factory.SchemaGraphNodeFactory;
import de.rcenvironment.supplemental.cmdows.importer.internal.factory.SchemaParameterFactory;
import de.rcenvironment.supplemental.cmdows.importer.model.CMDOWSDataModel;
import de.rcenvironment.supplemental.cmdows.importer.model.CMDOWSProblemFormulation;
import de.rcenvironment.supplemental.cmdows.importer.model.DOESettings;
import de.rcenvironment.supplemental.cmdows.importer.model.SchemaHeader;
import de.rcenvironment.supplemental.cmdows.importer.model.WorkflowSchemaModel;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockComponentImpl;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockType;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.DataGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.ProcessGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameter;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameterType;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaParameter;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaParameterImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMDOWSParsingServiceImpl
implements SchemaToWorkflowDescriptionParsingService {
    private static final String NODE_NAME_CANNOT_BE_NULL_MSG = "Node name cannot be null!";
    private static XMLSupportService xmlSupportService;
    private WorkflowDescriptionPersistenceHandler wfPersistenceHandler = new WorkflowDescriptionPersistenceHandler();
    private SchemaHeader.SchemaHeaderBuilder schemaHeaderBuilder;
    private CMDOWSProblemFormulation.CMDOWSProblemFormulationBuilder problemFormulationBuilder;
    private DOESettings.DOESettingsBuilder doeSettingsBuilder;
    private ExecutableBlockFactory execBlockFactory;
    private SchemaParameterFactory parameterFactory;
    private SchemaGraphNodeFactory graphNodeFactory;
    private WorkflowSchemaModel modelForTest;

    protected void bindXMLSupportService(XMLSupportService instance) {
        xmlSupportService = instance;
    }

    protected void unbindXMLSupportService(XMLSupportService instance) {
        xmlSupportService = null;
    }

    protected WorkflowSchemaModel getWorkflowModel() {
        return this.modelForTest;
    }

    @Override
    public void parseSchemaToWorkflowFile(File schema, WorkflowDescriptionTranslatorService translator, String outputPath, String fileName, String cpacsFilePath) throws SchemaParsingException {
        this.parseSchemaToWorkflowFile(schema, translator, outputPath, fileName, cpacsFilePath, null);
    }

    @Override
    public void parseSchemaToWorkflowFile(File schema, WorkflowDescriptionTranslatorService translator, String outputPath, String fileName, String cpacsFilepath, String[] mailInformation) throws SchemaParsingException {
        if (!outputPath.isEmpty() && !new File(outputPath).isDirectory()) {
            throw new SchemaParsingException(StringUtils.format((String)"Given output path \"%s\" is not a directoy.", (Object[])new Object[]{outputPath}));
        }
        CMDOWSDataModel model = null;
        this.schemaHeaderBuilder = new SchemaHeader.SchemaHeaderBuilder();
        this.problemFormulationBuilder = new CMDOWSProblemFormulation.CMDOWSProblemFormulationBuilder();
        this.doeSettingsBuilder = new DOESettings.DOESettingsBuilder();
        this.execBlockFactory = new ExecutableBlockFactory();
        this.parameterFactory = new SchemaParameterFactory();
        this.graphNodeFactory = new SchemaGraphNodeFactory();
        try {
            Document document = xmlSupportService.readXMLFromFile(schema);
            model = new CMDOWSDataModel();
            if (document == null) {
                throw new SchemaParsingException("XML document cannot be null.");
            }
            ArrayList<Element> postProcessingElements = new ArrayList<Element>();
            this.readTree(document.getDocumentElement(), model, new CMDOWSParsingState(null), true, postProcessingElements);
            this.postWorkflowGraphsProcess(postProcessingElements, model);
            this.postProcessesSchemaModel(model);
            this.modelForTest = model;
        }
        catch (XMLException e) {
            throw new SchemaParsingException("Failed to read CMDOWS file. Aborted with message: " + e.getMessage());
        }
        WorkflowDescription wd = translator.parseSchemaModelToWorkflowDescription(model, cpacsFilepath, mailInformation);
        try {
            ByteArrayOutputStream stream = this.wfPersistenceHandler.writeWorkflowDescriptionToStream(wd);
            String workflowFileName = wd.getFileName();
            if (!fileName.isEmpty() && !(workflowFileName = fileName).endsWith(".wf")) {
                workflowFileName = String.valueOf(workflowFileName) + ".wf";
            }
            if (outputPath.isEmpty()) {
                File rootDirOfCmdowsFile = schema.getParentFile();
                FileUtils.writeByteArrayToFile((File)new File(rootDirOfCmdowsFile, workflowFileName), (byte[])stream.toByteArray());
            } else {
                File outputDir = new File(outputPath);
                FileUtils.writeByteArrayToFile((File)new File(outputDir, workflowFileName), (byte[])stream.toByteArray());
            }
        }
        catch (IOException iOException) {
            throw new SchemaParsingException("Failed to persist workflow description.");
        }
    }

    private void postWorkflowGraphsProcess(List<Element> postProcessingElements, CMDOWSDataModel model) throws SchemaParsingException {
        for (Element elt : postProcessingElements) {
            if (elt.getNodeName().equals("dataGraph")) {
                this.processGraphElements(elt, model, true, DataGraphNode.class);
                continue;
            }
            if (!elt.getNodeName().equals("processGraph")) continue;
            this.processProcessGraphElements(elt, model, true);
        }
    }

    private void postProcessesSchemaModel(CMDOWSDataModel model) {
        model.setHeader(this.schemaHeaderBuilder.build());
        model.setProblemFormulation(this.problemFormulationBuilder.doeSettings(this.doeSettingsBuilder.build()).build());
        model.setParamPool(this.parameterFactory.getTypedParamMap());
        this.problemFormulationBuilder = null;
        this.doeSettingsBuilder = null;
        this.schemaHeaderBuilder = null;
        this.graphNodeFactory.clear();
        this.execBlockFactory.clear();
        this.parameterFactory.clear();
    }

    private void readTree(Element elt, CMDOWSDataModel model, CMDOWSParsingState state, boolean continueRecursion, List<Element> postProcessingElements) throws SchemaParsingException {
        CMDOWSNodeType type = CMDOWSNodeType.getTypeByNodeName(elt.getNodeName());
        if (state.getCMDOWSNodeType() == null) {
            state.setCMDOWSNodeType(CMDOWSNodeType.getTypeByNodeName(elt.getNodeName()));
        }
        if (state.getCMDOWSNodeType() != null && type != null && !type.getNodeName().equals(state.getCMDOWSNodeType().getNodeName())) {
            state.resetState();
            state.setCMDOWSNodeType(type);
        }
        if (elt.hasChildNodes()) {
            NodeList children = elt.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Element child;
                if (children.item(i).getNodeType() == 1 && (continueRecursion = this.doParsingStep(elt, model, state, child = (Element)children.item(i), postProcessingElements))) {
                    this.readTree(child, model, state, continueRecursion, postProcessingElements);
                }
                ++i;
            }
        }
    }

    private boolean doParsingStep(Element elt, CMDOWSDataModel model, CMDOWSParsingState state, Element child, List<Element> postProcessingElements) throws SchemaParsingException {
        boolean continueWithRecursion = true;
        if (state.getCMDOWSNodeType() == null) {
            return true;
        }
        switch (state.getCMDOWSNodeType()) {
            case DESIGN_COMPETENCE: {
                this.addNodeUIDToStatesAdditionalInformation(state, elt, "designCompetence");
                continueWithRecursion = this.createDesignCompetenceOrMathematicalFunction(child, state, ExecutableBlockType.DESIGN_COMPETENCE);
                break;
            }
            case HEADER: {
                this.createHeader(child);
                break;
            }
            case PARAMETER: {
                this.addNodeUIDToStatesAdditionalInformation(state, elt, "parameter");
                this.createParameters(child, state);
                break;
            }
            case PROBLEM_FORMULATION: {
                this.addNodeUIDToStatesAdditionalInformation(state, elt, "problemForumlation");
                this.createProblemFormulation(child);
                break;
            }
            case PROBLEM_ROLES: {
                this.addNodeUIDToStatesAdditionalInformation(state, elt, "problemRoles");
                continueWithRecursion = this.createProblemRoleParameters(child);
                break;
            }
            case WORKFLOW: {
                this.addNodeUIDToStatesAdditionalInformation(state, elt, "workflow");
                this.createWorkflow(elt, model, postProcessingElements);
                continueWithRecursion = false;
                break;
            }
            case ARCHITECTURE_ELEMENTS: {
                this.addNodeUIDToStatesAdditionalInformation(state, elt, "architectureElements");
                continueWithRecursion = this.createArchitectureElements(child, state);
                break;
            }
            case MATHEMATICAL_FUNCTION: {
                this.addNodeUIDToStatesAdditionalInformation(state, elt, "mathematicalFunction");
                continueWithRecursion = this.createDesignCompetenceOrMathematicalFunction(child, state, ExecutableBlockType.MATHEMATICAL_FUNCTION);
                break;
            }
        }
        if (!continueWithRecursion) {
            state.resetState();
        }
        return continueWithRecursion;
    }

    private boolean createProblemRoleParameters(Element elt) throws SchemaParsingException {
        if (elt.hasChildNodes()) {
            NodeList children = elt.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Element childElement;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (childElement = (Element)child).getParentNode().getNodeName().equals("parameters")) {
                    this.createProblemRoleParameter(childElement, null);
                }
                ++i;
            }
        }
        return true;
    }

    private void createProblemRoleParameter(Element elt, String uid) throws SchemaParsingException {
        if (elt.hasChildNodes()) {
            NodeList children = elt.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element childElement = (Element)child;
                    if (childElement.hasAttribute("uID")) {
                        uid = childElement.getAttribute("uID").trim();
                        this.parameterFactory.getOrCreateSchemaParameterImpl(uid, SchemaDesignParameterType.DEFAULT);
                    } else if (childElement.getNodeName().equals("parameterUID")) {
                        this.parameterFactory.getOrCreateSchemaParameterImpl(uid, SchemaDesignParameterType.DEFAULT).setRelatedParameter(this.parameterFactory.getOrCreateSchemaParameterImpl(childElement.getTextContent(), SchemaDesignParameterType.DEFAULT));
                    } else {
                        this.parameterFactory.getOrCreateSchemaParameterImpl(uid, SchemaDesignParameterType.DEFAULT).addAdditionalInformationElement(childElement.getNodeName(), childElement.getTextContent());
                    }
                    this.createProblemRoleParameter(childElement, uid);
                }
                ++i;
            }
        }
    }

    private boolean createArchitectureElements(Element elt, CMDOWSParsingState state) throws SchemaParsingException {
        switch (elt.getNodeName()) {
            case "parameters": {
                state.addAdditionalInformation("childParsingScope", elt.getNodeName());
                break;
            }
            case "executableBlocks": {
                state.addAdditionalInformation("childParsingScope", elt.getNodeName());
                break;
            }
        }
        if (state.getAdditionalStateInformation("childParsingScope") == null) {
            return true;
        }
        if (state.getAdditionalStateInformation("childParsingScope").equals("parameters")) {
            this.createArchitectureElementsParam(elt, state);
        } else if (state.getAdditionalStateInformation("childParsingScope").equals("executableBlocks")) {
            this.createArchtiectureElementsExecBlock(elt);
        }
        return true;
    }

    private void createArchitectureElementsParam(Element elt, CMDOWSParsingState state) throws SchemaParsingException {
        SchemaParameterImpl param;
        String uid;
        if (elt.hasAttribute("uID")) {
            uid = elt.getAttribute("uID");
            SchemaDesignParameterType type = null;
            try {
                type = SchemaDesignParameterType.valueOf(elt.getNodeName());
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("No enum constant")) {
                    LogFactory.getLog(CMDOWSParsingServiceImpl.class).error((Object)StringUtils.format((String)"Could not read design parameter %s because type %s does not exist", (Object[])new Object[]{uid, elt.getNodeName()}));
                    type = SchemaDesignParameterType.DEFAULT;
                }
                throw e;
            }
            if (type != null) {
                this.parameterFactory.getOrCreateSchemaParameterImpl(uid, type);
                state.addAdditionalInformation("uID", uid);
            }
        }
        if (elt.getNodeName().equals("relatedParameterUID")) {
            uid = this.extractArchitectureElementUIDString(elt, state);
            param = this.parameterFactory.getOrCreateSchemaParameterImpl(uid, SchemaDesignParameterType.DEFAULT);
            param.setRelatedParameter(this.parameterFactory.getOrCreateSchemaParameterImpl(elt.getTextContent(), SchemaDesignParameterType.DEFAULT));
        } else if (elt.getNodeName().equals("label")) {
            uid = this.extractArchitectureElementUIDString(elt, state);
            param = this.parameterFactory.getOrCreateSchemaParameterImpl(uid, SchemaDesignParameterType.DEFAULT);
            param.setName(elt.getTextContent());
        }
    }

    private String extractArchitectureElementUIDString(Element elt, CMDOWSParsingState state) throws SchemaParsingException {
        Object uidObject = state.getAdditionalStateInformation("uID");
        String uid = null;
        if (!(uidObject instanceof String)) {
            throw new SchemaParsingException("UID is not an instance of the class String.");
        }
        uid = (String)uidObject;
        return uid;
    }

    private void createArchtiectureElementsExecBlock(Element elt) throws SchemaParsingException {
        String name;
        switch (name = elt.getNodeName()) {
            case "optimizer": {
                this.createExecutableBlockComponent(elt, ExecutableBlockType.OPTIMIZER);
                break;
            }
            case "converger": {
                this.createExecutableBlockComponent(elt, ExecutableBlockType.CONVERGER);
                break;
            }
            case "consistencyConstraintFunction": {
                this.createExecutableBlockComponent(elt, ExecutableBlockType.CONSITENCY_CONSTRAINT_FUNCTION);
                break;
            }
            case "doe": {
                this.createExecutableBlockComponent(elt, ExecutableBlockType.DOE);
                break;
            }
            case "coordinator": {
                this.createExecutableBlockComponent(elt, ExecutableBlockType.COORDINATOR);
                break;
            }
        }
    }

    private void createExecutableBlockComponent(Element elt, ExecutableBlockType type) throws SchemaParsingException {
        ExecutableBlockComponentImpl component = null;
        if (elt.hasAttribute("uID")) {
            component = this.execBlockFactory.getOrCreateExecutableBlockComponentImpl(elt.getAttribute("uID"), type);
        }
        if (component != null) {
            this.createExecutableBlockComponentContent(elt, component);
        }
    }

    private void createExecutableBlockComponentContent(Element elt, ExecutableBlockComponentImpl component) throws SchemaParsingException {
        block14: {
            if (!elt.hasChildNodes()) break block14;
            NodeList children = elt.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                block15: {
                    Node node = children.item(i);
                    if (node.getNodeType() != 1) break block15;
                    Element childElement = (Element)node;
                    block4 : switch (childElement.getNodeName()) {
                        case "label": {
                            component.setName(childElement.getTextContent());
                            break;
                        }
                        case "settings": {
                            switch (component.getExecutableBlockType()) {
                                case DOE: {
                                    this.createOptionalExecutableBlockComponentContent(childElement, component);
                                    break block4;
                                }
                            }
                            component.addMetaDatum("settings", childElement.getTextContent());
                            break;
                        }
                        default: {
                            this.createOptionalExecutableBlockComponentContent(childElement, component);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void createOptionalExecutableBlockComponentContent(Element elt, ExecutableBlockComponentImpl component) throws SchemaParsingException {
        ExecutableBlockType type = component.getExecutableBlockType();
        NodeList children = elt.getChildNodes();
        switch (type) {
            case OPTIMIZER: {
                int i = 0;
                while (i < children.getLength()) {
                    Node node = children.item(i);
                    if (node.getNodeType() == 1) {
                        Element childElement = (Element)node;
                        if (childElement.getNodeName().equals(SchemaDesignParameterType.DESIGN_VARIABLE.getName())) {
                            SchemaParameterImpl newSchemaParameter = this.parameterFactory.getOrCreateSchemaParameterImpl(childElement.getTextContent(), SchemaDesignParameterType.valueOf(childElement.getNodeName()));
                            component.addExecutableBlockComponentOutput(newSchemaParameter);
                        } else if (childElement.getNodeName().equals(SchemaDesignParameterType.OBJECTIVE_VARIABLE.getName()) || childElement.getNodeName().equals(SchemaDesignParameterType.CONSTRAINT_VARIABLE.getName())) {
                            String hackedParameter = childElement.getTextContent().trim();
                            if (hackedParameter.contains(SchemaDesignParameterType.CONSISTENCY_CONSTRAINT_VARIABLE.getName())) {
                                hackedParameter = hackedParameter.substring(hackedParameter.indexOf(47));
                            }
                            SchemaParameterImpl newSchemaParameter = this.parameterFactory.getOrCreateSchemaParameterImpl(hackedParameter, SchemaDesignParameterType.valueOf(childElement.getNodeName()));
                            component.addExecutableBlockComponentInput(newSchemaParameter);
                        }
                    }
                    ++i;
                }
                break;
            }
            case DOE: {
                if (elt.getNodeName().equals("settings")) {
                    HashMap<String, String> doeSettings = new HashMap<String, String>();
                    int i = 0;
                    while (i < children.getLength()) {
                        Node node = children.item(i);
                        if (node.getNodeType() == 1) {
                            Element childElement = (Element)node;
                            doeSettings.put(childElement.getNodeName(), childElement.getTextContent());
                        }
                        ++i;
                    }
                    component.addMetaDatum("settings", doeSettings);
                    break;
                }
                component.addExecutableBlockComponentOutput(this.parameterFactory.getOrCreateSchemaParameterImpl(elt.getTextContent(), SchemaDesignParameterType.DEFAULT));
                break;
            }
        }
    }

    private void createProblemFormulation(Element elt) {
        String content = elt.getTextContent();
        switch (elt.getNodeName()) {
            case "mdaoArchitecture": {
                this.problemFormulationBuilder = this.problemFormulationBuilder.mdaoArchitecture(content);
                break;
            }
            case "convergerType": {
                this.problemFormulationBuilder = this.problemFormulationBuilder.convergerType(content);
                break;
            }
            case "executableBlocksOrder": {
                String[] tempBlockOrder = content.split(",");
                String[] blockOrder = new String[tempBlockOrder.length];
                int i = 0;
                String[] stringArray = tempBlockOrder;
                int n = tempBlockOrder.length;
                int n2 = 0;
                while (n2 < n) {
                    String newBlock;
                    String block = stringArray[n2];
                    blockOrder[i] = newBlock = block.replace("'", "").replace("[", "").replace("]", "").trim();
                    ++i;
                    ++n2;
                }
                this.problemFormulationBuilder = this.problemFormulationBuilder.executableBlocksOrder(blockOrder);
                break;
            }
            case "allowUnconvergedCouplings": {
                this.problemFormulationBuilder = this.problemFormulationBuilder.allowUnconvergedCouplings(Boolean.parseBoolean(content));
                break;
            }
            case "doeMethod": {
                this.doeSettingsBuilder = this.doeSettingsBuilder.doeMethod(content);
                break;
            }
            case "doeRuns": {
                this.doeSettingsBuilder = this.doeSettingsBuilder.doeRuns(content);
                break;
            }
            case "doeSeed": {
                this.doeSettingsBuilder = this.doeSettingsBuilder.doeSeed(content);
                break;
            }
        }
    }

    private void createWorkflow(Element elt, CMDOWSDataModel model, List<Element> postProcessList) throws SchemaParsingException {
        this.processGraphElements(elt, model, postProcessList);
    }

    private void processGraphElements(Element elt, CMDOWSDataModel model, List<Element> postProcessList) throws SchemaParsingException {
        block15: {
            boolean doPostProcessing = false;
            if (!elt.hasChildNodes()) break block15;
            NodeList children = elt.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                block16: {
                    Node childNode = children.item(i);
                    if (childNode.getNodeType() != 1) break block16;
                    Element childElement = (Element)childNode;
                    switch (childElement.getNodeName()) {
                        case "dataGraph": {
                            doPostProcessing = !this.processGraphElements(childElement, model, true, DataGraphNode.class);
                            break;
                        }
                        case "processGraph": {
                            doPostProcessing = !this.processProcessGraphElements(childElement, model, true);
                            break;
                        }
                        case "problemDefinitionUID": {
                            model.setWorkflowName(String.valueOf(childElement.getTextContent()) + ".wf");
                            break;
                        }
                    }
                    if (doPostProcessing) {
                        postProcessList.add(childElement);
                    }
                }
                ++i;
            }
        }
    }

    private boolean processProcessGraphElements(Element elt, CMDOWSDataModel model, boolean continueWithRecursion) throws SchemaParsingException {
        if (!continueWithRecursion) {
            return false;
        }
        if (elt.hasChildNodes()) {
            NodeList children = elt.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                if (childNode.getNodeType() == 1) {
                    Element childElt = (Element)childNode;
                    if (childElt.getNodeName().equals("edges")) {
                        continueWithRecursion = this.processGraphElements(childElt, model, continueWithRecursion, ProcessGraphNode.class);
                    } else if (childElt.getNodeName().equals("nodes") && childElt.hasChildNodes()) {
                        HashMap<String, Integer[]> posMap = new HashMap<String, Integer[]>();
                        this.extractDiagonalPosition(childElt, posMap);
                        return this.processPosNodes(posMap, model);
                    }
                }
                ++i;
            }
        }
        return continueWithRecursion;
    }

    private boolean processPosNodes(Map<String, Integer[]> posMap, CMDOWSDataModel model) throws SchemaParsingException {
        for (Map.Entry<String, Integer[]> entry : posMap.entrySet()) {
            ProcessGraphNode node = this.graphNodeFactory.getOrCreateProcessGraphNode(entry.getKey(), null);
            if (node == null) {
                return false;
            }
            node.setDiagonalPosition(entry.getValue()[0]);
            node.setProcessStepNumber(entry.getValue()[1]);
            node.setConvergerStepNumber(entry.getValue()[2]);
        }
        return true;
    }

    private void extractDiagonalPosition(Element elt, Map<String, Integer[]> posMap) {
        String referenceUID = null;
        Integer pos = null;
        Integer procStep = null;
        Integer convStep = 0;
        int z = 0;
        while (z < elt.getChildNodes().getLength()) {
            Node c = elt.getChildNodes().item(z);
            if (c.getNodeType() == 1) {
                Element celt = (Element)c;
                if (celt.getNodeName().equals("diagonalPosition")) {
                    if (NumberUtils.isNumber((String)celt.getTextContent())) {
                        pos = Integer.parseInt(celt.getTextContent());
                    }
                } else if (celt.getNodeName().equals("processStepNumber")) {
                    if (NumberUtils.isNumber((String)celt.getTextContent())) {
                        procStep = Integer.parseInt(celt.getTextContent());
                    }
                } else if (celt.getNodeName().equals("convergerStepNumber")) {
                    if (NumberUtils.isNumber((String)celt.getTextContent())) {
                        convStep = Integer.parseInt(celt.getTextContent());
                    }
                } else if (celt.getNodeName().equals("referenceUID")) {
                    referenceUID = celt.getTextContent();
                } else {
                    this.extractDiagonalPosition(celt, posMap);
                }
            }
            ++z;
        }
        if (referenceUID != null && pos != null) {
            posMap.put(referenceUID, new Integer[]{pos, procStep, convStep});
        }
    }

    private boolean processGraphElements(Element elt, CMDOWSDataModel model, boolean continueWithRecursion, Class<? extends SchemaGraphNode<?>> clazz) throws SchemaParsingException {
        block30: {
            if (!continueWithRecursion) {
                return false;
            }
            if (!elt.hasChildNodes()) break block30;
            NodeList children = elt.getChildNodes();
            String fromUID = null;
            String toUID = null;
            int i = 0;
            while (i < children.getLength()) {
                block31: {
                    Node childNode = children.item(i);
                    if (childNode.getNodeType() != 1) break block31;
                    Element childElement = (Element)childNode;
                    String nodeName = childElement.getNodeName();
                    String content = childElement.getTextContent();
                    switch (nodeName) {
                        case "fromUID": {
                            fromUID = content.trim();
                            break;
                        }
                        case "toUID": {
                            toUID = content.trim();
                            break;
                        }
                        default: {
                            continueWithRecursion = this.processGraphElements(childElement, model, continueWithRecursion, clazz);
                        }
                    }
                }
                ++i;
            }
            if (fromUID != null && toUID != null) {
                SchemaGraphNode<Object> fromNode;
                Object fromNodeContent = null;
                if (this.parameterFactory.isParameterUIDExistent(fromUID)) {
                    fromNodeContent = this.parameterFactory.getOrCreateSchemaParameterImpl(fromUID, SchemaDesignParameterType.DEFAULT);
                } else if (this.execBlockFactory.isExecBlockUIDExistent(fromUID)) {
                    fromNodeContent = this.execBlockFactory.getExecutableBlock(fromUID);
                }
                if (fromNodeContent == null) {
                    continueWithRecursion = false;
                    return continueWithRecursion;
                }
                if (clazz.equals(DataGraphNode.class)) {
                    model.addNodeToDataGraph(fromUID, this.graphNodeFactory.getOrCreateDataGraphNode(fromUID, fromNodeContent));
                } else if (clazz.equals(ProcessGraphNode.class)) {
                    ExecutableBlock block = null;
                    if (!(fromNodeContent instanceof ExecutableBlock)) {
                        throw new SchemaParsingException("Tried to add malicious node to process graph.");
                    }
                    block = (ExecutableBlock)fromNodeContent;
                    model.addNodeToProcessGraph(fromUID, this.graphNodeFactory.getOrCreateProcessGraphNode(fromUID, block));
                }
                Object toNodeContent = null;
                if (this.parameterFactory.isParameterUIDExistent(toUID)) {
                    toNodeContent = this.parameterFactory.getOrCreateSchemaParameterImpl(toUID, SchemaDesignParameterType.DEFAULT);
                } else if (this.execBlockFactory.isExecBlockUIDExistent(toUID)) {
                    toNodeContent = this.execBlockFactory.getExecutableBlock(toUID);
                }
                if (toNodeContent == null) {
                    continueWithRecursion = false;
                    return continueWithRecursion;
                }
                if (clazz.equals(DataGraphNode.class)) {
                    fromNode = this.graphNodeFactory.getOrCreateDataGraphNode(fromUID, fromNodeContent);
                    ((DataGraphNode)fromNode).addAdjacencyToNode(this.graphNodeFactory.getOrCreateDataGraphNode(toUID, toNodeContent));
                    this.graphNodeFactory.getOrCreateDataGraphNode(toUID, toNodeContent).addParentAdjacencyToNode((DataGraphNode)fromNode);
                } else if (clazz.equals(ProcessGraphNode.class)) {
                    fromNode = this.graphNodeFactory.getOrCreateProcessGraphNode(fromUID, (ExecutableBlock)fromNodeContent);
                    if (!(toNodeContent instanceof ExecutableBlock)) {
                        throw new SchemaParsingException("Tried to add malicious node to process graph.");
                    }
                    ((ProcessGraphNode)fromNode).addAdjacencyToNode(this.graphNodeFactory.getOrCreateProcessGraphNode(toUID, (ExecutableBlock)toNodeContent));
                    this.graphNodeFactory.getOrCreateProcessGraphNode(toUID, (ExecutableBlock)toNodeContent).addParentAdjacencyToNode((ProcessGraphNode)fromNode);
                } else {
                    throw new SchemaParsingException("Inconsisten graph schema.");
                }
                continueWithRecursion = true;
            }
        }
        return continueWithRecursion;
    }

    private void addNodeUIDToStatesAdditionalInformation(CMDOWSParsingState state, Element elt, String toplevelNode) {
        if (elt.getNodeName().equals(toplevelNode)) {
            state.addAdditionalInformation("uID", elt.getAttribute("uID"));
        }
    }

    private boolean createDesignCompetenceOrMathematicalFunction(Element root, CMDOWSParsingState state, ExecutableBlockType type) throws SchemaParsingException {
        String content = root.getTextContent().trim();
        String nodeName = root.getNodeName().trim();
        String uid = this.getUIDAttribute(root, state);
        ExecutableBlockComponentImpl execBlock = this.execBlockFactory.getOrCreateExecutableBlockComponentImpl(uid, type);
        boolean continueWithTopLevelRecursion = true;
        switch (nodeName) {
            case "label": {
                execBlock.setName(content);
                break;
            }
            case "input": {
                SchemaParameter parameter = null;
                String equotationLabel = null;
                int i = 0;
                while (i < root.getChildNodes().getLength()) {
                    Node child = root.getChildNodes().item(i);
                    if (child.getNodeType() == 1) {
                        Element childElement = (Element)child;
                        if (childElement.getNodeName().trim().equals("parameterUID")) {
                            parameter = this.parameterFactory.getOrCreateSchemaParameterImpl(childElement.getTextContent().trim(), SchemaDesignParameterType.DEFAULT);
                        } else if (childElement.getNodeName().trim().equals("equationLabel")) {
                            equotationLabel = childElement.getTextContent().trim();
                        }
                    }
                    ++i;
                }
                execBlock.addExecutableBlockComponentInput((SchemaDesignParameter)parameter);
                if (parameter == null || equotationLabel == null) break;
                HashMap<String, String> equationLabel = (HashMap<String, String>)execBlock.getMetaData().get("equationLabel");
                if (equationLabel == null) {
                    equationLabel = new HashMap<String, String>();
                    execBlock.addMetaDatum("equationLabel", equationLabel);
                }
                equationLabel.put(parameter.getUID(), equotationLabel);
                break;
            }
            case "output": {
                SchemaParameterImpl outputParameter = null;
                HashMap<String, String> equationMap = new HashMap<String, String>();
                int i = 0;
                while (i < root.getChildNodes().getLength()) {
                    Node child = root.getChildNodes().item(i);
                    if (child.getNodeType() == 1) {
                        Element childElement = (Element)child;
                        if (childElement.getNodeName().trim().equals("parameterUID")) {
                            outputParameter = this.parameterFactory.getOrCreateSchemaParameterImpl(childElement.getTextContent().trim(), SchemaDesignParameterType.DEFAULT);
                        } else if (childElement.getNodeName().equals("equation") && childElement.getAttribute("language") != null) {
                            equationMap.put(childElement.getAttribute("language"), childElement.getTextContent());
                        }
                    }
                    ++i;
                }
                if (outputParameter != null) {
                    outputParameter.addAdditionalInformationElement("equations", equationMap);
                }
                execBlock.addExecutableBlockComponentOutput(outputParameter);
                break;
            }
            case "metadata": {
                this.createTopLevelMetaData(root, execBlock);
                break;
            }
            case "platformspecific": {
                this.createPlatformSpecificRoot(root, execBlock);
                continueWithTopLevelRecursion = false;
                break;
            }
        }
        return continueWithTopLevelRecursion;
    }

    private void createPlatformSpecificRoot(Element root, ExecutableBlockComponentImpl competence) throws SchemaParsingException {
        if (root.hasChildNodes()) {
            NodeList children = root.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element childElement = (Element)child;
                    competence.addPlatformSpecific(childElement.getNodeName(), this.createMetaData(childElement));
                }
                ++i;
            }
        }
    }

    private void createTopLevelMetaData(Element root, ExecutableBlockComponentImpl competence) throws SchemaParsingException {
        if (root.hasChildNodes()) {
            NodeList children = root.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element childElement = (Element)child;
                    competence.addMetaDatum(childElement.getNodeName(), this.createMetaData(childElement));
                }
                ++i;
            }
        }
    }

    private Object createMetaData(Element root) throws SchemaParsingException {
        if (root.hasChildNodes()) {
            NodeList children = root.getChildNodes();
            if (children.getLength() <= 1) {
                return root.getTextContent().trim();
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element childElement = (Element)child;
                    Object obj = this.createMetaData(childElement);
                    map.put(childElement.getNodeName(), obj);
                }
                ++i;
            }
            return map;
        }
        return null;
    }

    private void createParameters(Element root, CMDOWSParsingState state) throws SchemaParsingException {
        String content = root.getTextContent();
        String uid = this.getUIDAttribute(root, state);
        String nodeName = root.getNodeName();
        SchemaParameterImpl param = this.parameterFactory.getOrCreateSchemaParameterImpl(uid, SchemaDesignParameterType.DEFAULT);
        if (nodeName.equals("label") || nodeName.equals("name")) {
            param.setName(content);
        } else if (nodeName.equals("note")) {
            param.setNote(content);
        } else if (nodeName.equals("description")) {
            param.setDescription(content);
        }
    }

    private String getUIDAttribute(Element elt, CMDOWSParsingState state) throws SchemaParsingException {
        String nodeName = elt.getNodeName().trim();
        if (nodeName == null) {
            throw new SchemaParsingException(NODE_NAME_CANNOT_BE_NULL_MSG);
        }
        return (String)state.getAdditionalStateInformation("uID");
    }

    private void createHeader(Element root) throws SchemaParsingException {
        String content = root.getTextContent();
        switch (root.getNodeName()) {
            case "creator": {
                this.schemaHeaderBuilder = this.schemaHeaderBuilder.creator(content);
                break;
            }
            case "description": {
                this.schemaHeaderBuilder = this.schemaHeaderBuilder.description(content);
                break;
            }
            case "timestamp": {
                this.schemaHeaderBuilder = this.schemaHeaderBuilder.timestamp(content);
                break;
            }
            case "fileVersion": {
                this.schemaHeaderBuilder = this.schemaHeaderBuilder.fileVersion(this.getDoubleValueOfString(content));
                break;
            }
            case "cmdowsVersion": {
                this.schemaHeaderBuilder = this.schemaHeaderBuilder.schemaVersion(this.getDoubleValueOfString(content));
                break;
            }
        }
    }

    private Double getDoubleValueOfString(String content) throws SchemaParsingException {
        if (NumberUtils.isNumber((String)content)) {
            return Double.parseDouble(content);
        }
        throw new SchemaParsingException("File version of the cmdows file is not a numeric value!");
    }
}

