/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.incubator.configuration;

import de.rcenvironment.core.utils.incubator.configuration.ConfigurationConstants;
import de.rcenvironment.core.utils.incubator.configuration.ConfigurationProperty;
import de.rcenvironment.core.utils.incubator.configuration.annotation.Configurable;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;

public class ConfigurationPropertyImpl
implements ConfigurationProperty {
    private static final Configurable.LabelProvider DEFAULT_LABEL_PROVIDER = new Configurable.LabelProvider(){

        @Override
        public void setObject(Object object) {
        }

        @Override
        public String getLabel(Object object) {
            return object.toString();
        }
    };
    private final PropertyDescriptor descriptor;
    private final Class<?> type;
    private final boolean indexed;
    private final Class<? extends Configurable.ValueProvider> valueProviderType;
    private final Class<? extends Configurable.LabelProvider> labelProviderType;

    public ConfigurationPropertyImpl(PropertyDescriptor descriptor) {
        this(descriptor, descriptor.getReadMethod().getAnnotation(Configurable.class).labelProvider(), descriptor.getReadMethod().getAnnotation(Configurable.class).valueProvider());
    }

    public ConfigurationPropertyImpl(PropertyDescriptor descriptor, Class<? extends Configurable.LabelProvider> labelProviderType, Class<? extends Configurable.ValueProvider> valueProviderType) {
        this.descriptor = descriptor;
        this.labelProviderType = labelProviderType;
        this.valueProviderType = valueProviderType;
        this.indexed = descriptor instanceof IndexedPropertyDescriptor;
        this.type = this.indexed ? descriptor.getReadMethod().getReturnType().getComponentType() : descriptor.getReadMethod().getReturnType();
    }

    @Override
    public Configurable.ValueProvider getValueProvider() {
        if (this.valueProviderType == ConfigurationConstants.NO_VALUE_PROVIDER) {
            return null;
        }
        try {
            Configurable.ValueProvider choiceProvider = this.valueProviderType.newInstance();
            return choiceProvider;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Configurable.LabelProvider getLabelProvider() {
        if (this.labelProviderType == ConfigurationConstants.NO_LABEL_PROVIDER) {
            return DEFAULT_LABEL_PROVIDER;
        }
        try {
            Configurable.LabelProvider choiceProvider = this.labelProviderType.newInstance();
            return choiceProvider;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Object getValue(Object object) throws IllegalArgumentException {
        try {
            return this.descriptor.getReadMethod().invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setValue(Object object, Object value) throws IllegalArgumentException {
        try {
            this.descriptor.getWriteMethod().invoke(object, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

