/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common.security;

import de.rcenvironment.core.utils.common.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StringSubstitutionSecurityUtils {
    private static final String[] COMMON_FORBIDDEN_PATTERNS = new String[]{"\"", "[\\u0000-\\u001f]", "\\\\", "/", "\\*", "\\?"};
    private static boolean suppressLogMessageOnDeniedSubstitution = false;
    private static final Log LOG = LogFactory.getLog(StringSubstitutionSecurityUtils.class);

    private StringSubstitutionSecurityUtils() {
    }

    public static boolean isSafeForSubstitutionInsideDoubleQuotes(String string, SubstitutionContext context) {
        if (string == null) {
            throw new NullPointerException("The substitution string can not be 'null'");
        }
        if (context == null) {
            throw new NullPointerException("Internal error: Subsctitution context is 'null'");
        }
        Matcher matcher = context.getForbiddenCharactersRegexp().matcher(string);
        if (matcher.find()) {
            if (!suppressLogMessageOnDeniedSubstitution) {
                LOG.warn((Object)StringUtils.format("Denied string \"%s\" for substitution in context %s because of insecure character sequence <%s>", string, context.name(), matcher.group(0)));
            }
            return false;
        }
        return true;
    }

    protected static void setSuppressLogMessageOnDeniedSubstitution(boolean suppress) {
        suppressLogMessageOnDeniedSubstitution = suppress;
    }

    public static enum SubstitutionContext {
        WINDOWS_BATCH(new String[]{"%"}),
        LINUX_BASH(new String[]{"`", "\\$"}),
        JYTHON(new String[]{"'"});

        private static final String REGEXP_ALTERNATIVES_JOINER = "|";
        private final Pattern forbiddenCharactersRegexp;

        private SubstitutionContext(String[] customPatterns) {
            String patternString = org.apache.commons.lang3.StringUtils.join((Object[])COMMON_FORBIDDEN_PATTERNS, (String)REGEXP_ALTERNATIVES_JOINER);
            if (customPatterns.length > 0) {
                patternString = String.valueOf(patternString) + REGEXP_ALTERNATIVES_JOINER + org.apache.commons.lang3.StringUtils.join((Object[])customPatterns, (String)REGEXP_ALTERNATIVES_JOINER);
            }
            this.forbiddenCharactersRegexp = Pattern.compile(patternString);
        }

        public Pattern getForbiddenCharactersRegexp() {
            return this.forbiddenCharactersRegexp;
        }
    }
}

