/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.xpathchooser;

import de.rcenvironment.core.gui.xpathchooser.EVariableDirection;
import de.rcenvironment.core.gui.xpathchooser.VariableEntry;
import de.rcenvironment.core.gui.xpathchooser.XPathLocation;
import de.rcenvironment.core.gui.xpathchooser.XPathNode;
import de.rcenvironment.core.gui.xpathchooser.XPathParser;
import de.rcenvironment.core.gui.xpathchooser.XPathPredicate;
import de.rcenvironment.core.gui.xpathchooser.XPathStep;
import de.rcenvironment.core.gui.xpathchooser.XSDContentProvider;
import de.rcenvironment.core.gui.xpathchooser.XSDEditingSupport;
import de.rcenvironment.core.gui.xpathchooser.XSDLabelProvider;
import de.rcenvironment.core.gui.xpathchooser.model.XSDElement;
import de.rcenvironment.core.utils.common.variables.legacy.VariableType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class XPathChooserHelper {
    static final int PERCENT_100 = 100;
    private static final int PERCENT_85 = 81;
    private static final int TREE_COLUMNS = 3;
    private Tree tree;
    private TreeViewer treeViewer;
    private XSDElement doc;
    private VariableEntry xpathEntry;
    private Text text;

    public XPathChooserHelper(XSDElement root) {
        this.doc = root;
    }

    public Composite createContents(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        Group firstGroup = new Group(parent, 0);
        firstGroup.setText("XML");
        firstGroup.setLayout((Layout)new FillLayout());
        this.createTree((Composite)firstGroup);
        final Sash sash = new Sash(parent, 256);
        Group secondGroup = new Group(parent, 0);
        secondGroup.setText("XPath");
        secondGroup.setLayout((Layout)new FillLayout());
        this.createLabel((Composite)secondGroup);
        FormData firstData = new FormData();
        firstData.top = new FormAttachment(0, 0);
        firstData.bottom = new FormAttachment((Control)sash, 0);
        firstData.left = new FormAttachment(0, 0);
        firstData.right = new FormAttachment(100, 0);
        firstGroup.setLayoutData((Object)firstData);
        FormData sashData = new FormData();
        sashData.top = new FormAttachment(81, 0);
        sashData.left = new FormAttachment(0, 0);
        sashData.right = new FormAttachment(100, 0);
        sash.setLayoutData((Object)sashData);
        FormData secondData = new FormData();
        secondData.top = new FormAttachment((Control)sash, 0);
        secondData.bottom = new FormAttachment(100, 0);
        secondData.left = new FormAttachment(0, 0);
        secondData.right = new FormAttachment(100, 0);
        secondGroup.setLayoutData((Object)secondData);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((FormData)sash.getLayoutData()).top = new FormAttachment(0, event.y);
                sash.getParent().layout();
            }
        });
        return secondGroup;
    }

    private void createTree(Composite parent) {
        this.tree = new Tree(parent, 68356);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.tree.addListener(41, new Listener(){

            public void handleEvent(Event arg0) {
            }
        });
        this.treeViewer = new TreeViewer(this.tree);
        String[] columnNames = new String[]{"Element", "Attributes", "Values"};
        int c = 0;
        while (c < 3) {
            TreeViewerColumn tvc = new TreeViewerColumn(this.treeViewer, 0);
            tvc.getColumn().setText(columnNames[c]);
            tvc.getColumn().setResizable(true);
            tvc.getColumn().setMoveable(false);
            if (c >= 1) {
                tvc.setEditingSupport((EditingSupport)new XSDEditingSupport(this, (ColumnViewer)this.treeViewer, c));
            }
            ++c;
        }
        this.treeViewer.setContentProvider((IContentProvider)new XSDContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new XSDLabelProvider(this));
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
                if (thisSelection == null || thisSelection.isEmpty()) {
                    return;
                }
                Object selectedNode = thisSelection.getFirstElement();
                if (!XPathChooserHelper.this.treeViewer.isExpandable(selectedNode)) {
                    return;
                }
                XSDContentProvider provider = (XSDContentProvider)XPathChooserHelper.this.treeViewer.getContentProvider();
                if (!provider.hasChildren(selectedNode)) {
                    return;
                }
                XPathChooserHelper.this.treeViewer.setExpandedState(selectedNode, !XPathChooserHelper.this.treeViewer.getExpandedState(selectedNode));
            }
        });
        this.fillTree();
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                XPathChooserHelper.this.selectItem();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    public void selectItem() {
        TreeItem item = this.tree.getSelection()[0];
        this.xpathEntry = this.getVariableFromViewItem(item);
        this.text.setText(this.xpathEntry.getXpath());
    }

    public void createLabel(Composite parent) {
        this.text = new Text(parent, 72);
        this.xpathEntry = new VariableEntry(EVariableDirection.Incoming, "", "", VariableType.String);
    }

    private void fillTree() {
        this.treeViewer.setInput((Object)this.doc);
        this.treeViewer.expandAll();
        int[] columnWidths = new int[]{470, 120, 180};
        int c = 0;
        while (c < 3) {
            this.tree.getColumn(c).pack();
            this.tree.getColumn(c).setWidth(columnWidths[c]);
            ++c;
        }
    }

    String[] getAttributeValuesForCurrentTreeItem(XSDElement element, int column) {
        assert (element != null);
        assert (column >= 1);
        if (column == 1) {
            return element.getAttributeNames();
        }
        if (column == 2) {
            return element.getAttributeValues();
        }
        return XSDElement.EMPTY_STRING;
    }

    String[] getAttributeValuesForCurrentTreeItem(TreeItem item, int column) {
        XSDElement element = this.findModelItemFromViewItem(item);
        return this.getAttributeValuesForCurrentTreeItem(element, column);
    }

    static String getCurrentElementValue(XSDElement element, int column) {
        assert (column >= 1);
        if (column == 1) {
            return element.getCurrentAttributeName();
        }
        if (column == 2) {
            return element.getCurrentAttributeValue();
        }
        return null;
    }

    static void setCurrentElementValue(XSDElement element, int column, String value) {
        assert (column >= 1);
        if (column == 1) {
            element.setCurrentAttributeName(value);
        } else if (column == 2) {
            element.setCurrentAttributeValue(value);
        }
    }

    static void setElementValue(XSDElement element, String text, int column) {
        assert (column >= 1);
        if (column == 1) {
            element.setAttributeName(text);
        } else if (column == 2) {
            element.setAttributeValue(text);
        }
    }

    void setElementValue(TreeItem item, String value, int column) {
        XSDElement element = this.findModelItemFromViewItem(item);
        XPathChooserHelper.setElementValue(element, value, column);
    }

    private List<String> getPathFromViewItems(TreeItem item) {
        LinkedList<String> path = new LinkedList<String>();
        path.add(item.getText());
        TreeItem current = item;
        while (current.getParentItem() != null) {
            current = current.getParentItem();
            path.add(0, current.getText());
        }
        return path;
    }

    private List<XSDElement> getModelEntriesFromPath(List<String> path) {
        ArrayList<XSDElement> elements = new ArrayList<XSDElement>();
        XSDElement element = this.doc;
        for (String name : path) {
            for (XSDElement e : element.getElements()) {
                if (!e.getName().equals(name)) continue;
                element = e;
                elements.add(element);
            }
        }
        return elements;
    }

    private XSDElement findModelItemFromViewItem(TreeItem item) {
        List<String> path = this.getPathFromViewItems(item);
        List<XSDElement> elements = this.getModelEntriesFromPath(path);
        return elements.get(elements.size() - 1);
    }

    private VariableEntry getVariableFromViewItem(TreeItem item) {
        List<String> path = this.getPathFromViewItems(item);
        List<XSDElement> elements = this.getModelEntriesFromPath(path);
        StringBuilder sb = new StringBuilder();
        for (XSDElement element : elements) {
            if (element.getCurrentAttributeName() == null || element.getCurrentAttributeValue() == null || element.getCurrentAttributeName().equals("") || element.getCurrentAttributeValue().equals("")) {
                sb.append("/").append(element.getName());
                continue;
            }
            sb.append("/").append(element.getName()).append("[@").append(element.getCurrentAttributeName()).append("='").append(element.getCurrentAttributeValue()).append("']");
        }
        String baseName = elements.get(elements.size() - 1).getName();
        VariableEntry var = new VariableEntry(EVariableDirection.Incoming, this.createUniqueVariableName(baseName), sb.toString(), VariableType.String);
        return var;
    }

    private String createUniqueVariableName(String baseName) {
        String newName;
        String name = this.xpathEntry.getName().intern();
        if (!name.equals(baseName)) {
            return baseName;
        }
        int counter = 1;
        while (name.equals(newName = String.valueOf(baseName) + "_" + Integer.toString(counter))) {
            ++counter;
        }
        return newName;
    }

    void updateTreeAttributesFromTableEntry(VariableEntry entry) {
        XPathLocation xpath = XPathParser.parse(entry.getXpath());
        XSDElement element = this.doc;
        block0: for (XPathStep step : xpath.getSteps()) {
            for (XSDElement child : element.getElements()) {
                String pred;
                int splitPos;
                XPathNode node;
                XPathPredicate predicate;
                if (!child.getName().equals(step.getValue())) continue;
                element = child;
                if (!(step instanceof XPathNode) || (predicate = (node = (XPathNode)step).getPredicate()) == null || (splitPos = (pred = predicate.getValue()).indexOf(61)) < 0) continue block0;
                child.setAttributeName(pred.substring(1, splitPos));
                child.setAttributeValue(pred.substring(splitPos + 2, pred.length() - 1));
                continue block0;
            }
        }
        this.treeViewer.refresh();
    }

    VariableEntry getVariable() {
        return this.xpathEntry;
    }
}

