/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.properties;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.management.WorkflowHostService;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatum;
import de.rcenvironment.core.component.workflow.execution.api.GenericSubscriptionEventProcessor;
import de.rcenvironment.core.component.workflow.execution.api.GenericSubscriptionManager;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.workflow.view.properties.InputSubscriptionEventProcessor;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;

public final class InputModel {
    private static final int MAX_INPUT_COUNT = 25000;
    private static InputModel instance;
    private static Map<String, Map<String, Map<String, Deque<EndpointDatum>>>> allInputs;
    private static InputSubscriptionEventProcessor eventProcessor;
    private static GenericSubscriptionManager currentInputManager;
    private static CountDownLatch initialSubscriptionLatch;

    private InputModel() {
    }

    public static synchronized InputModel getInstance() {
        if (instance == null) {
            instance = new InputModel();
            initialSubscriptionLatch = new CountDownLatch(1);
            allInputs = new ConcurrentHashMap<String, Map<String, Map<String, Deque<EndpointDatum>>>>();
            eventProcessor = new InputSubscriptionEventProcessor(instance);
            currentInputManager = new GenericSubscriptionManager((GenericSubscriptionEventProcessor)eventProcessor, (CommunicationService)ServiceRegistry.createAccessFor((Object)instance).getService(CommunicationService.class), (WorkflowHostService)ServiceRegistry.createAccessFor((Object)instance).getService(WorkflowHostService.class));
            ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                @Override
                @TaskDescription(value="Initial inputs subscriptions")
                public void run() {
                    currentInputManager.updateSubscriptionsForPrefixes(new String[]{"rce.component.input:"});
                    initialSubscriptionLatch.countDown();
                }
            });
        }
        return instance;
    }

    public void updateSubscriptions() {
        try {
            initialSubscriptionLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for initial subscriptions to complete", e);
        }
        currentInputManager.updateSubscriptionsForPrefixes(new String[]{"rce.component.input:"});
    }

    public synchronized void addInputs(List<EndpointDatum> inputs) {
        for (EndpointDatum input : inputs) {
            if (!this.isValue(input)) continue;
            String workflowId = input.getWorkflowExecutionIdentifier();
            String componentId = input.getInputsComponentExecutionIdentifier();
            String inputName = input.getInputName();
            if (!allInputs.containsKey(workflowId)) {
                allInputs.put(workflowId, new HashMap());
            }
            if (!allInputs.get(workflowId).containsKey(componentId)) {
                allInputs.get(workflowId).put(componentId, new HashMap());
            }
            if (!allInputs.get(workflowId).get(componentId).containsKey(inputName)) {
                allInputs.get(workflowId).get(componentId).put(inputName, new LinkedList());
            }
            if (allInputs.size() > 25000) {
                allInputs.get(workflowId).get(componentId).get(inputName).removeFirst();
            }
            allInputs.get(workflowId).get(componentId).get(inputName).addLast(input);
        }
    }

    public synchronized Deque<EndpointDatum> getInputs(String workflowId, String componentId, String inputName) {
        LinkedList<Object> inputs = new LinkedList<EndpointDatum>();
        if (allInputs.containsKey(workflowId) && allInputs.get(workflowId).containsKey(componentId) && allInputs.get(workflowId).get(componentId).containsKey(inputName)) {
            inputs = new LinkedList(allInputs.get(workflowId).get(componentId).get(inputName));
        }
        return inputs;
    }

    private boolean isValue(EndpointDatum input) {
        return !input.getValue().getDataType().equals((Object)DataType.Internal);
    }

    public InputSubscriptionEventProcessor getEventProcessor() {
        return eventProcessor;
    }

    public static void ensureInputCaptureIsInitialized() {
        InputModel.getInstance();
    }
}

